/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.tree;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import org.apache.crimson.parser.AttributesEx;
import org.apache.crimson.tree.AttributeNode;
import org.apache.crimson.tree.AttributeNode1;
import org.apache.crimson.tree.DomEx;
import org.apache.crimson.tree.NodeBase;
import org.apache.crimson.tree.XmlWritable;
import org.apache.crimson.tree.XmlWriteContext;
import org.apache.crimson.util.XmlNames;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

final class AttributeSet
implements NamedNodeMap,
XmlWritable {
    private boolean readonly;
    private Vector list;
    private Element ownerElement;

    private AttributeSet() {
    }

    AttributeSet(Element element) {
        this.list = new Vector(5);
        this.ownerElement = element;
    }

    AttributeSet(AttributeSet attributeSet, boolean bl) {
        int n = attributeSet.getLength();
        this.list = new Vector(n);
        int n2 = 0;
        while (n2 < n) {
            Node node = attributeSet.item(n2);
            if (!(node instanceof AttributeNode)) {
                throw new IllegalArgumentException(((NodeBase)node).getMessage("A-003"));
            }
            AttributeNode attributeNode = (AttributeNode)node;
            node = attributeNode.cloneAttributeNode(bl);
            this.list.addElement(node);
            ++n2;
        }
    }

    AttributeSet(AttributeSet attributeSet) {
        int n = attributeSet.getLength();
        this.list = new Vector(n);
        int n2 = 0;
        while (n2 < n) {
            Node node = attributeSet.item(n2);
            if (!(node instanceof AttributeNode)) {
                throw new IllegalArgumentException(((NodeBase)node).getMessage("A-003"));
            }
            AttributeNode attributeNode = (AttributeNode)node;
            if (attributeNode.getSpecified()) {
                node = attributeNode.cloneAttributeNode(true);
                this.list.addElement(node);
            }
            ++n2;
        }
        this.list.trimToSize();
    }

    static AttributeSet createAttributeSet2(Attributes attributes) throws DOMException {
        AttributeSet attributeSet = new AttributeSet();
        int n = attributes.getLength();
        AttributesEx attributesEx = null;
        attributeSet.list = new Vector(n);
        if (attributes instanceof AttributesEx) {
            attributesEx = (AttributesEx)attributes;
        }
        int n2 = 0;
        while (n2 < n) {
            String string;
            String string2 = attributes.getQName(n2);
            if ("xmlns".equals(string2) || "xmlns".equals(XmlNames.getPrefix(string2))) {
                string = "http://www.w3.org/2000/xmlns/";
            } else {
                string = attributes.getURI(n2);
                if ("".equals(string)) {
                    string = null;
                }
            }
            AttributeNode attributeNode = new AttributeNode(string, string2, attributes.getValue(n2), attributesEx == null ? true : attributesEx.isSpecified(n2), attributesEx == null ? null : attributesEx.getDefault(n2));
            attributeSet.list.addElement(attributeNode);
            ++n2;
        }
        return attributeSet;
    }

    static AttributeSet createAttributeSet1(Attributes attributes) throws DOMException {
        AttributeSet attributeSet = new AttributeSet();
        int n = attributes.getLength();
        AttributesEx attributesEx = null;
        attributeSet.list = new Vector(n);
        if (attributes instanceof AttributesEx) {
            attributesEx = (AttributesEx)attributes;
        }
        int n2 = 0;
        while (n2 < n) {
            AttributeNode1 attributeNode1 = new AttributeNode1(attributes.getQName(n2), attributes.getValue(n2), attributesEx == null ? true : attributesEx.isSpecified(n2), attributesEx == null ? null : attributesEx.getDefault(n2));
            attributeSet.list.addElement(attributeNode1);
            ++n2;
        }
        return attributeSet;
    }

    void trimToSize() {
        this.list.trimToSize();
    }

    public void setReadonly() {
        this.readonly = true;
        int n = 0;
        while (n < this.list.size()) {
            ((AttributeNode)this.list.elementAt(n)).setReadonly(true);
            ++n;
        }
    }

    public boolean isReadonly() {
        if (this.readonly) {
            return true;
        }
        int n = 0;
        while (n < this.list.size()) {
            if (((AttributeNode)this.list.elementAt(n)).isReadonly()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    void setOwnerElement(Element element) {
        if (element != null && this.ownerElement != null) {
            throw new IllegalStateException(((NodeBase)((Object)element)).getMessage("A-004"));
        }
        this.ownerElement = element;
        int n = this.list.size();
        int n2 = 0;
        while (n2 < n) {
            AttributeNode attributeNode = (AttributeNode)this.list.elementAt(n2);
            attributeNode.setOwnerElement(null);
            attributeNode.setOwnerElement(element);
            ++n2;
        }
    }

    String getValue(String string) {
        Attr attr = (Attr)this.getNamedItem(string);
        if (attr == null) {
            return "";
        }
        return attr.getValue();
    }

    public Node getNamedItem(String string) {
        int n = this.list.size();
        int n2 = 0;
        while (n2 < n) {
            Node node = this.item(n2);
            if (node.getNodeName().equals(string)) {
                return node;
            }
            ++n2;
        }
        return null;
    }

    public Node getNamedItemNS(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        int n = 0;
        while (n < this.list.size()) {
            String string3;
            Node node = this.item(n);
            String string4 = node.getLocalName();
            if (string2.equals(string4) && (string == (string3 = node.getNamespaceURI()) || string != null && string.equals(string3))) {
                return node;
            }
            ++n;
        }
        return null;
    }

    public int getLength() {
        return this.list.size();
    }

    public Node item(int n) {
        if (n < 0 || n >= this.list.size()) {
            return null;
        }
        return (Node)this.list.elementAt(n);
    }

    public Node removeNamedItem(String string) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        int n = 0;
        while (n < this.list.size()) {
            Node node = (Node)this.list.elementAt(n);
            if (node.getNodeName().equals(string)) {
                this.list.removeElementAt(n);
                AttributeNode attributeNode = (AttributeNode)node;
                String string2 = attributeNode.getDefaultValue();
                if (string2 != null) {
                    AttributeNode attributeNode2 = attributeNode.cloneAttributeNode(true);
                    attributeNode2.setOwnerElement(attributeNode.getOwnerElement());
                    attributeNode2.setValue(string2);
                    attributeNode2.setSpecified(false);
                    this.list.addElement(attributeNode2);
                }
                attributeNode.setOwnerElement(null);
                return attributeNode;
            }
            ++n;
        }
        throw new DomEx(8);
    }

    public Node removeNamedItemNS(String string, String string2) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (string2 == null) {
            throw new DomEx(8);
        }
        int n = 0;
        while (n < this.list.size()) {
            String string3;
            Node node = (Node)this.list.elementAt(n);
            String string4 = node.getLocalName();
            if (string2.equals(string4) && (string == (string3 = node.getNamespaceURI()) || string != null && string.equals(string3))) {
                this.list.removeElementAt(n);
                AttributeNode attributeNode = (AttributeNode)node;
                String string5 = attributeNode.getDefaultValue();
                if (string5 != null) {
                    AttributeNode attributeNode2 = attributeNode.cloneAttributeNode(true);
                    attributeNode2.setOwnerElement(attributeNode.getOwnerElement());
                    attributeNode2.setValue(string5);
                    attributeNode2.setSpecified(false);
                    this.list.addElement(attributeNode2);
                }
                attributeNode.setOwnerElement(null);
                return attributeNode;
            }
            ++n;
        }
        throw new DomEx(8);
    }

    public Node setNamedItem(Node node) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (!(node instanceof AttributeNode) || node.getOwnerDocument() != this.ownerElement.getOwnerDocument()) {
            throw new DomEx(4);
        }
        AttributeNode attributeNode = (AttributeNode)node;
        if (attributeNode.getOwnerElement() != null) {
            throw new DomEx(10);
        }
        int n = this.list.size();
        int n2 = 0;
        while (n2 < n) {
            AttributeNode attributeNode2 = (AttributeNode)this.item(n2);
            if (attributeNode2.getNodeName().equals(node.getNodeName())) {
                if (attributeNode2.isReadonly()) {
                    throw new DomEx(7);
                }
                attributeNode.setOwnerElement(this.ownerElement);
                this.list.setElementAt(attributeNode, n2);
                attributeNode2.setOwnerElement(null);
                return attributeNode2;
            }
            ++n2;
        }
        attributeNode.setOwnerElement(this.ownerElement);
        this.list.addElement(node);
        return null;
    }

    public Node setNamedItemNS(Node node) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (!(node instanceof AttributeNode) || node.getOwnerDocument() != this.ownerElement.getOwnerDocument()) {
            throw new DomEx(4);
        }
        AttributeNode attributeNode = (AttributeNode)node;
        if (attributeNode.getOwnerElement() != null) {
            throw new DomEx(10);
        }
        String string = attributeNode.getLocalName();
        String string2 = attributeNode.getNamespaceURI();
        int n = this.list.size();
        int n2 = 0;
        while (n2 < n) {
            AttributeNode attributeNode2 = (AttributeNode)this.item(n2);
            String string3 = attributeNode2.getLocalName();
            String string4 = attributeNode2.getNamespaceURI();
            if ((string == string3 || string != null && string.equals(string3)) && (string2 == string4 || string2 != null && string2.equals(string4))) {
                if (attributeNode2.isReadonly()) {
                    throw new DomEx(7);
                }
                attributeNode.setOwnerElement(this.ownerElement);
                this.list.setElementAt(attributeNode, n2);
                attributeNode2.setOwnerElement(null);
                return attributeNode2;
            }
            ++n2;
        }
        attributeNode.setOwnerElement(this.ownerElement);
        this.list.addElement(attributeNode);
        return null;
    }

    public void writeXml(XmlWriteContext xmlWriteContext) throws IOException {
        Writer writer = xmlWriteContext.getWriter();
        int n = this.list.size();
        int n2 = 0;
        while (n2 < n) {
            AttributeNode attributeNode = (AttributeNode)this.list.elementAt(n2);
            if (attributeNode.getSpecified()) {
                writer.write(32);
                attributeNode.writeXml(xmlWriteContext);
            }
            ++n2;
        }
    }

    public void writeChildrenXml(XmlWriteContext xmlWriteContext) throws IOException {
    }

    public String toString() {
        try {
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            XmlWriteContext xmlWriteContext = new XmlWriteContext(charArrayWriter);
            this.writeXml(xmlWriteContext);
            return charArrayWriter.toString();
        }
        catch (IOException iOException) {
            return super.toString();
        }
    }
}

