/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.util.font;

import com.flagstone.transform.Movie;
import com.flagstone.transform.MovieTag;
import com.flagstone.transform.datatype.Bounds;
import com.flagstone.transform.font.DefineFont;
import com.flagstone.transform.font.DefineFont2;
import com.flagstone.transform.font.DefineFont3;
import com.flagstone.transform.font.FontInfo;
import com.flagstone.transform.font.FontInfo2;
import com.flagstone.transform.shape.Shape;
import com.flagstone.transform.util.font.Font;
import com.flagstone.transform.util.font.FontDecoder;
import com.flagstone.transform.util.font.FontFace;
import com.flagstone.transform.util.font.FontProvider;
import com.flagstone.transform.util.font.Glyph;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.DataFormatException;

public final class SWFFontDecoder
implements FontProvider,
FontDecoder {
    private final transient Map<Integer, Font> fonts = new LinkedHashMap<Integer, Font>();
    private transient List<Shape> glyphs;

    @Override
    public FontDecoder newDecoder() {
        return new SWFFontDecoder();
    }

    @Override
    public void read(File file) throws IOException, DataFormatException {
        Movie movie = new Movie();
        movie.decodeFromFile(file);
        this.decode(movie);
    }

    @Override
    public void read(URL url) throws IOException, DataFormatException {
        Movie movie = new Movie();
        movie.decodeFromUrl(url);
        this.decode(movie);
    }

    @Override
    public List<Font> getFonts() {
        return new ArrayList<Font>(this.fonts.values());
    }

    private void decode(Movie movie) throws IOException, DataFormatException {
        this.fonts.clear();
        for (MovieTag obj : movie.getObjects()) {
            if (obj instanceof DefineFont) {
                this.decode((DefineFont)obj);
                continue;
            }
            if (obj instanceof DefineFont2) {
                this.decode((DefineFont2)obj);
                continue;
            }
            if (obj instanceof FontInfo) {
                this.decode((FontInfo)obj);
                continue;
            }
            if (!(obj instanceof FontInfo2)) continue;
            this.decode((FontInfo2)obj);
        }
    }

    public void decode(DefineFont definition) {
        this.glyphs = definition.getShapes();
        this.fonts.put(definition.getIdentifier(), new Font());
    }

    public void decode(FontInfo info) {
        Font font = this.fonts.get(info.getIdentifier());
        font.setFace(new FontFace(info.getName(), info.isBold(), info.isItalic()));
        font.setEncoding(info.getEncoding());
        font.setAscent(0);
        font.setDescent(0);
        font.setLeading(0);
        int codeCount = info.getCodes().size();
        int highest = info.getCodes().get(codeCount - 1);
        font.setHighestChar((char)highest);
        if (!this.glyphs.isEmpty()) {
            for (int code : info.getCodes()) {
                font.addGlyph((char)code, new Glyph(this.glyphs.get(code)));
            }
        }
    }

    public void decode(FontInfo2 info) {
        Font font = this.fonts.get(info.getIdentifier());
        font.setFace(new FontFace(info.getName(), info.isBold(), info.isItalic()));
        font.setEncoding(info.getEncoding());
        font.setAscent(0);
        font.setDescent(0);
        font.setLeading(0);
        int codeCount = info.getCodes().size();
        int highest = info.getCodes().get(codeCount - 1);
        font.setHighestChar((char)highest);
        if (!this.glyphs.isEmpty()) {
            for (int code : info.getCodes()) {
                font.addGlyph((char)code, new Glyph(this.glyphs.get(code)));
            }
        }
    }

    public void decode(DefineFont2 object) {
        Font font = new Font();
        font.setFace(new FontFace(object.getName(), object.isBold(), object.isItalic()));
        font.setEncoding(object.getEncoding());
        font.setAscent(object.getAscent());
        font.setDescent(object.getDescent());
        font.setLeading(object.getLeading());
        int glyphCount = object.getShapes().size();
        int codeCount = object.getCodes().size();
        int highest = object.getCodes().get(codeCount - 1);
        font.setMissingGlyph(0);
        font.setNumberOfGlyphs(glyphCount);
        font.setHighestChar((char)highest);
        if (glyphCount > 0) {
            Bounds bounds = null;
            for (int i = 0; i < glyphCount; ++i) {
                Shape shape = object.getShapes().get(i);
                if (object.getBounds() != null) {
                    bounds = object.getBounds().get(i);
                }
                int advance = object.getAdvances() == null ? 0 : object.getAdvances().get(i);
                int code = object.getCodes().get(i);
                font.addGlyph((char)code, new Glyph(shape, bounds, advance));
            }
        }
        this.fonts.put(object.getIdentifier(), font);
    }

    public void decode(DefineFont3 object) {
        Font font = new Font();
        font.setFace(new FontFace(object.getName(), object.isBold(), object.isItalic()));
        font.setEncoding(object.getEncoding());
        font.setAscent(object.getAscent());
        font.setDescent(object.getDescent());
        font.setLeading(object.getLeading());
        int glyphCount = object.getShapes().size();
        int highest = object.getCodes().get(glyphCount - 1);
        font.setMissingGlyph(0);
        font.setNumberOfGlyphs(glyphCount);
        font.setHighestChar((char)highest);
        if (glyphCount > 0) {
            Bounds bounds = null;
            for (int i = 0; i < glyphCount; ++i) {
                Shape shape = object.getShapes().get(i);
                if (object.getBounds() != null) {
                    bounds = object.getBounds().get(i);
                }
                int advance = object.getAdvances() == null ? 0 : object.getAdvances().get(i);
                int code = object.getCodes().get(i);
                font.addGlyph((char)code, new Glyph(shape, bounds, advance));
            }
        }
        this.fonts.put(object.getIdentifier(), font);
    }
}

