/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.tools;

import com.flagstone.transform.Movie;
import com.flagstone.transform.MovieTag;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public final class MovieWriter {
    public void write(Movie movie, File file) throws IOException {
        PrintWriter writer = new PrintWriter(file);
        this.write(movie, (Writer)writer);
        writer.close();
    }

    public void write(Movie movie, Writer writer) throws IOException {
        for (MovieTag tag : movie.getObjects()) {
            this.write(tag, writer);
        }
    }

    public void write(Object obj, Writer writer) throws IOException {
        int level = 0;
        boolean start = false;
        boolean coord = false;
        String str = obj.toString();
        for (char c : str.toCharArray()) {
            if (c == '{') {
                writer.append(c).append('\n');
                this.indent(writer, ++level);
                start = true;
                continue;
            }
            if (c == '}') {
                writer.append(';').append('\n');
                this.indent(writer, --level);
                writer.append(c);
                continue;
            }
            if (c == '[') {
                writer.append(c).append('\n');
                this.indent(writer, ++level);
                continue;
            }
            if (c == ']') {
                writer.append('\n');
                this.indent(writer, --level);
                writer.append(c);
                continue;
            }
            if (c == ';') {
                writer.append(c).append('\n');
                this.indent(writer, level);
                start = true;
                continue;
            }
            if (c == ',') {
                writer.append(c);
                if (coord) continue;
                writer.append('\n');
                this.indent(writer, level);
                start = true;
                continue;
            }
            if (c == '<') {
                writer.append('[');
                continue;
            }
            if (c == '>') {
                writer.append(']');
                continue;
            }
            if (c == '(') {
                writer.append(c);
                coord = true;
                continue;
            }
            if (c == ')') {
                writer.append(c);
                coord = false;
                continue;
            }
            if (c == '=') {
                writer.append(' ').append('=').append(' ');
                continue;
            }
            if (c == ' ') {
                if (start) continue;
                writer.append(c);
                continue;
            }
            writer.append(c);
            start = false;
        }
        writer.append(',').append('\n');
        writer.flush();
    }

    private void indent(Writer writer, int level) throws IOException {
        for (int i = 0; i < level; ++i) {
            writer.append('\t');
        }
    }
}

