/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.sound;

import com.flagstone.transform.MovieTag;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.sound.SoundInfo;
import java.io.IOException;

public final class StartSound
implements MovieTag {
    private static final String FORMAT = "StartSound: { sound=%s}";
    private SoundInfo sound;
    private transient int length;

    public StartSound(SWFDecoder coder) throws IOException {
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        this.sound = new SoundInfo(coder.readUnsignedShort(), coder);
        coder.check(this.length);
        coder.unmark();
    }

    public StartSound(SoundInfo aSound) {
        this.setSound(aSound);
    }

    public StartSound(StartSound object) {
        this.sound = object.sound.copy();
    }

    public SoundInfo getSound() {
        return this.sound;
    }

    public void setSound(SoundInfo aSound) {
        if (aSound == null) {
            throw new IllegalArgumentException();
        }
        this.sound = aSound;
    }

    @Override
    public StartSound copy() {
        return new StartSound(this);
    }

    public String toString() {
        return String.format(FORMAT, this.sound);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = this.sound.prepareToEncode(context);
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(1023);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0x3C0 | this.length);
        }
        coder.mark();
        this.sound.encode(coder, context);
        coder.check(this.length);
        coder.unmark();
    }
}

