/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.image;

public final class JPEGInfo {
    private static final int BYTE_MASK = 255;
    public static final int SOI = 65496;
    public static final int EOI = 65497;
    public static final int SOF0 = 65472;
    public static final int SOF2 = 65474;
    public static final int JPG = 65480;
    public static final int SOFF = 65487;
    public static final int DHT = 65476;
    public static final int DQT = 65499;
    public static final int DRI = 65501;
    public static final int SOS = 65498;
    public static final int RST = 65488;
    public static final int APP = 65504;
    public static final int COM = 65534;
    private transient int width;
    private transient int height;

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void decode(byte[] image) {
        int limit = image.length - 2;
        int index = 0;
        while (index < limit) {
            int marker;
            if ((marker = (image[index++] & 0xFF) << 8 | image[index++] & 0xFF) == 65496 || marker == 65497) continue;
            int length = (image[index++] & 0xFF) << 8 | image[index++] & 0xFF;
            if (marker >= 65472 && marker <= 65487 && marker != 65476 && marker != 65480) {
                int n = ++index;
                int n2 = ++index;
                this.height = (image[n] & 0xFF) << 8 | image[n2] & 0xFF;
                int n3 = ++index;
                int n4 = ++index;
                ++index;
                this.width = (image[n3] & 0xFF) << 8 | image[n4] & 0xFF;
                break;
            }
            index += length - 2;
        }
    }
}

