/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.font;

import com.flagstone.transform.DefineTag;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.datatype.Bounds;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import com.flagstone.transform.font.CharacterFormat;
import com.flagstone.transform.font.Kerning;
import com.flagstone.transform.shape.Shape;
import com.flagstone.transform.shape.ShapeData;
import com.flagstone.transform.text.Language;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class DefineFont3
implements DefineTag {
    private static final String FORMAT = "DefineFont3: { identifier=%d; encoding=%d; small=%b; italic=%b; bold=%b; language=%s; name=%s; shapes=%s; codes=%s; ascent=%d; descent=%d; leading=%d; advances=%s; bounds=%s; kernings=%s}";
    private int identifier;
    private int encoding;
    private boolean small;
    private boolean italic;
    private boolean bold;
    private int language;
    private String name;
    private List<Shape> shapes;
    private List<Integer> codes;
    private int ascent;
    private int descent;
    private int leading;
    private List<Integer> advances;
    private List<Bounds> bounds;
    private List<Kerning> kernings;
    private transient int length;
    private transient int[] table;
    private transient boolean wideOffsets;
    private transient boolean wideCodes;

    public DefineFont3(SWFDecoder coder, Context context) throws IOException {
        int i;
        int i2;
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        this.identifier = coder.readUnsignedShort();
        this.shapes = new ArrayList<Shape>();
        this.codes = new ArrayList<Integer>();
        this.advances = new ArrayList<Integer>();
        this.bounds = new ArrayList<Bounds>();
        this.kernings = new ArrayList<Kerning>();
        int bits = coder.readByte();
        boolean containsLayout = (bits & 0x80) != 0;
        int format = bits >> 4 & 7;
        this.encoding = 0;
        if (format == 1) {
            this.encoding = 1;
        } else if (format == 2) {
            this.small = true;
        } else if (format == 4) {
            this.encoding = 2;
        }
        this.wideOffsets = (bits & 8) != 0;
        this.wideCodes = (bits & 4) != 0;
        this.italic = (bits & 2) != 0;
        boolean bl = this.bold = (bits & 1) != 0;
        if (this.wideCodes) {
            context.put(4, 1);
        }
        this.language = coder.readByte();
        int nameLength = coder.readByte();
        this.name = coder.readString(nameLength);
        if (this.name.length() > 0) {
            while (this.name.charAt(this.name.length() - 1) == '\u0000') {
                this.name = this.name.substring(0, this.name.length() - 1);
            }
        }
        int glyphCount = coder.readUnsignedShort();
        int[] offset = new int[glyphCount + 1];
        if (this.wideOffsets) {
            for (i2 = 0; i2 < glyphCount; ++i2) {
                offset[i2] = coder.readInt();
            }
        } else {
            for (i2 = 0; i2 < glyphCount; ++i2) {
                offset[i2] = coder.readUnsignedShort();
            }
        }
        if (coder.bytesRead() < this.length) {
            offset[glyphCount] = this.wideOffsets ? coder.readInt() : coder.readUnsignedShort();
        }
        for (i = 0; i < glyphCount; ++i) {
            Shape shape = new Shape();
            shape.add(new ShapeData(offset[i + 1] - offset[i], coder));
            this.shapes.add(shape);
        }
        if (this.wideCodes) {
            for (i = 0; i < glyphCount; ++i) {
                this.codes.add(coder.readUnsignedShort());
            }
        } else {
            for (i = 0; i < glyphCount; ++i) {
                this.codes.add(coder.readByte());
            }
        }
        if (containsLayout || coder.bytesRead() < this.length) {
            this.ascent = coder.readSignedShort();
            this.descent = coder.readSignedShort();
            this.leading = coder.readSignedShort();
            for (i = 0; i < glyphCount; ++i) {
                this.advances.add(coder.readSignedShort());
            }
            for (i = 0; i < glyphCount; ++i) {
                this.bounds.add(new Bounds(coder));
            }
            int kerningCount = coder.readUnsignedShort();
            for (int i3 = 0; i3 < kerningCount; ++i3) {
                this.kernings.add(new Kerning(coder, context));
            }
        }
        context.remove(4);
        coder.check(this.length);
        coder.unmark();
    }

    public DefineFont3(int uid, String fontName) {
        this.setIdentifier(uid);
        this.setName(fontName);
        this.encoding = 0;
        this.shapes = new ArrayList<Shape>();
        this.codes = new ArrayList<Integer>();
        this.advances = new ArrayList<Integer>();
        this.bounds = new ArrayList<Bounds>();
        this.kernings = new ArrayList<Kerning>();
    }

    public DefineFont3(DefineFont3 object) {
        this.identifier = object.identifier;
        this.encoding = object.encoding;
        this.small = object.small;
        this.italic = object.italic;
        this.bold = object.bold;
        this.language = object.language;
        this.name = object.name;
        this.ascent = object.ascent;
        this.descent = object.descent;
        this.leading = object.leading;
        this.shapes = new ArrayList<Shape>(object.shapes.size());
        for (Shape shape : object.shapes) {
            this.shapes.add(shape.copy());
        }
        this.codes = new ArrayList<Integer>(object.codes);
        this.advances = new ArrayList<Integer>(object.advances);
        this.bounds = new ArrayList<Bounds>(object.bounds);
        this.kernings = new ArrayList<Kerning>(object.kernings);
    }

    @Override
    public int getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(int uid) {
        if (uid < 1 || uid > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, uid);
        }
        this.identifier = uid;
    }

    public DefineFont3 addGlyph(int code, Shape obj) {
        if (code < 0 || code > 65535) {
            throw new IllegalArgumentRangeException(0, 65535, code);
        }
        this.codes.add(code);
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        this.shapes.add(obj);
        return this;
    }

    public DefineFont3 addAdvance(int anAdvance) {
        if (anAdvance < Short.MIN_VALUE || anAdvance > Short.MAX_VALUE) {
            throw new IllegalArgumentRangeException(Short.MIN_VALUE, Short.MAX_VALUE, anAdvance);
        }
        this.advances.add(anAdvance);
        return this;
    }

    public DefineFont3 add(Bounds rect) {
        if (rect == null) {
            throw new IllegalArgumentException();
        }
        this.bounds.add(rect);
        return this;
    }

    public DefineFont3 add(Kerning anObject) {
        if (anObject == null) {
            throw new IllegalArgumentException();
        }
        this.kernings.add(anObject);
        return this;
    }

    public CharacterFormat getEncoding() {
        CharacterFormat value;
        switch (this.encoding) {
            case 0: {
                value = CharacterFormat.UCS2;
                break;
            }
            case 1: {
                value = CharacterFormat.ANSI;
                break;
            }
            case 2: {
                value = CharacterFormat.SJIS;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return value;
    }

    public boolean isSmall() {
        return this.small;
    }

    public void setSmall(boolean aBool) {
        this.small = aBool;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public boolean isBold() {
        return this.bold;
    }

    public Language getLanguage() {
        return Language.fromInt(this.language);
    }

    public void setLanguage(Language lang) {
        this.language = lang.getValue();
    }

    public String getName() {
        return this.name;
    }

    public List<Shape> getShapes() {
        return this.shapes;
    }

    public List<Integer> getCodes() {
        return this.codes;
    }

    public int getAscent() {
        return this.ascent;
    }

    public int getDescent() {
        return this.descent;
    }

    public int getLeading() {
        return this.leading;
    }

    public List<Integer> getAdvances() {
        return this.advances;
    }

    public List<Bounds> getBounds() {
        return this.bounds;
    }

    public List<Kerning> getKernings() {
        return this.kernings;
    }

    public void setEncoding(CharacterFormat anEncoding) {
        switch (anEncoding) {
            case UCS2: {
                this.encoding = 0;
                break;
            }
            case ANSI: {
                this.encoding = 1;
                break;
            }
            case SJIS: {
                this.encoding = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setItalic(boolean aBool) {
        this.italic = aBool;
    }

    public void setBold(boolean aBool) {
        this.bold = aBool;
    }

    public void setName(String aString) {
        if (aString == null) {
            throw new IllegalArgumentException();
        }
        this.name = aString;
    }

    public void setShapes(List<Shape> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.shapes = list;
    }

    public void setCodes(List<Integer> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.codes = list;
    }

    public void setAscent(int aNumber) {
        if (aNumber < Short.MIN_VALUE || aNumber > Short.MAX_VALUE) {
            throw new IllegalArgumentRangeException(Short.MIN_VALUE, Short.MAX_VALUE, aNumber);
        }
        this.ascent = aNumber;
    }

    public void setDescent(int aNumber) {
        if (aNumber < Short.MIN_VALUE || aNumber > Short.MAX_VALUE) {
            throw new IllegalArgumentRangeException(Short.MIN_VALUE, Short.MAX_VALUE, aNumber);
        }
        this.descent = aNumber;
    }

    public void setLeading(int aNumber) {
        if (aNumber < Short.MIN_VALUE || aNumber > Short.MAX_VALUE) {
            throw new IllegalArgumentRangeException(Short.MIN_VALUE, Short.MAX_VALUE, aNumber);
        }
        this.leading = aNumber;
    }

    public void setAdvances(List<Integer> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.advances = list;
    }

    public void setBounds(List<Bounds> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.bounds = list;
    }

    public void setKernings(List<Kerning> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.kernings = list;
    }

    @Override
    public DefineFont3 copy() {
        return new DefineFont3(this);
    }

    public String toString() {
        return String.format(FORMAT, this.identifier, this.encoding, this.small, this.italic, this.bold, this.language, this.name, this.shapes, this.codes, this.ascent, this.descent, this.leading, this.advances, this.bounds, this.kernings);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.wideCodes = context.get(1) > 5 || this.encoding != 1;
        context.put(11, 1);
        context.put(12, context.contains(9) ? 1 : 0);
        if (this.wideCodes) {
            context.put(4, 1);
        }
        int count = this.shapes.size();
        int index = 0;
        int tableEntry = this.wideOffsets ? (count << 2) + 4 : (count << 1) + 2;
        this.table = new int[count + 1];
        int glyphLength = 0;
        for (Shape shape : this.shapes) {
            this.table[index++] = tableEntry;
            int shapeLength = shape.prepareToEncode(context);
            glyphLength += shapeLength;
            tableEntry += shapeLength;
        }
        this.table[index++] = tableEntry;
        this.wideOffsets = this.shapes.size() * 2 + glyphLength > 65535;
        this.length = 5;
        this.length += context.strlen(this.name);
        this.length += 2;
        this.length += this.shapes.size() * (this.wideOffsets ? 4 : 2);
        this.length += this.wideOffsets ? 4 : 2;
        this.length += glyphLength;
        this.length += this.shapes.size() * (this.wideCodes ? 2 : 1);
        if (this.containsLayoutInfo()) {
            this.length += 6;
            this.length += this.advances.size() * 2;
            for (Bounds bound : this.bounds) {
                this.length += bound.prepareToEncode(context);
            }
            this.length += 2;
            this.length += this.kernings.size() * (this.wideCodes ? 6 : 4);
        }
        context.put(11, 0);
        context.put(12, 0);
        context.remove(4);
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        int i;
        int format = this.encoding == 1 ? 1 : (this.small ? 2 : (this.encoding == 2 ? 4 : 0));
        if (this.length > 62) {
            coder.writeShort(4863);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0x12C0 | this.length);
        }
        coder.mark();
        coder.writeShort(this.identifier);
        context.put(11, 1);
        context.put(12, context.contains(9) ? 1 : 0);
        if (this.wideCodes) {
            context.put(4, 1);
        }
        int bits = 0;
        bits |= this.containsLayoutInfo() ? 128 : 0;
        bits |= format << 4;
        bits |= this.wideOffsets ? 8 : 0;
        bits |= this.wideCodes ? 4 : 0;
        bits |= this.italic ? 2 : 0;
        coder.writeByte(bits |= this.bold ? 1 : 0);
        coder.writeByte(this.language);
        coder.writeByte(context.strlen(this.name));
        coder.writeString(this.name);
        coder.writeShort(this.shapes.size());
        if (this.wideOffsets) {
            for (i = 0; i < this.table.length; ++i) {
                coder.writeInt(this.table[i]);
            }
        } else {
            for (i = 0; i < this.table.length; ++i) {
                coder.writeShort(this.table[i]);
            }
        }
        for (Shape shape : this.shapes) {
            shape.encode(coder, context);
        }
        if (this.wideCodes) {
            for (Integer code : this.codes) {
                coder.writeShort(code);
            }
        } else {
            for (Integer code : this.codes) {
                coder.writeByte(code);
            }
        }
        if (this.containsLayoutInfo()) {
            coder.writeShort(this.ascent);
            coder.writeShort(this.descent);
            coder.writeShort(this.leading);
            for (Integer advance : this.advances) {
                coder.writeShort(advance);
            }
            for (Bounds bound : this.bounds) {
                bound.encode(coder, context);
            }
            coder.writeShort(this.kernings.size());
            for (Kerning kerning : this.kernings) {
                kerning.encode(coder, context);
            }
        }
        context.put(11, 0);
        context.put(12, 0);
        context.remove(4);
        coder.check(this.length);
        coder.unmark();
    }

    private boolean containsLayoutInfo() {
        boolean layout = this.ascent != 0 || this.descent != 0 || this.leading != 0 || !this.advances.isEmpty() || !this.bounds.isEmpty() || !this.kernings.isEmpty();
        return layout;
    }
}

