/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.coder;

public final class Coder {
    public static final int BIT0 = 1;
    public static final int BIT1 = 2;
    public static final int BIT2 = 4;
    public static final int BIT3 = 8;
    public static final int BIT4 = 16;
    public static final int BIT5 = 32;
    public static final int BIT6 = 64;
    public static final int BIT7 = 128;
    public static final int BIT10 = 1024;
    public static final int BIT15 = 32768;
    public static final int NIB0 = 15;
    public static final int NIB1 = 240;
    public static final int NIB2 = 3840;
    public static final int NIB3 = 61440;
    public static final int PAIR0 = 3;
    public static final int PAIR1 = 12;
    public static final int PAIR2 = 48;
    public static final int PAIR3 = 192;
    public static final int LOWEST3 = 7;
    public static final int LOWEST5 = 31;
    public static final int LOWEST7 = 127;
    public static final int LOWEST10 = 1023;
    public static final int LOWEST12 = 4095;
    public static final int LOWEST15 = Short.MAX_VALUE;
    public static final int TO_LOWER_BYTE = 8;
    public static final int TO_UPPER_BYTE = 8;
    public static final int TO_LOWER_NIB = 4;
    public static final int TO_UPPER_NIB = 4;
    public static final int USHORT_MAX = 65535;
    public static final int SHORT_MIN = Short.MIN_VALUE;
    public static final int SHORT_MAX = Short.MAX_VALUE;
    public static final int ALIGN_BYTE1 = 8;
    public static final int ALIGN_BYTE2 = 16;
    public static final int ALIGN_BYTE3 = 24;
    public static final int ALIGN_NIB1 = 4;
    public static final int ALIGN_NIB2 = 8;
    public static final int ALIGN_NIB3 = 12;
    public static final float SCALE_8 = 256.0f;
    public static final float SCALE_14 = 16384.0f;
    public static final float SCALE_16 = 65536.0f;
    public static final int VAR_INT_MAX = 127;
    public static final int VAR_INT_SHIFT = 7;
    public static final int LENGTH_FIELD = 63;
    public static final int LENGTH_FIELD_SIZE = 6;
    public static final int IS_EXTENDED = 63;
    public static final int SHORT_HEADER = 2;
    public static final int HEADER_LIMIT = 62;
    public static final int LONG_HEADER = 6;
    public static final int ACTION_HEADER = 3;
    private static final int BITS_PER_INT = 32;
    private static final int MSB_MASK = Integer.MIN_VALUE;

    public static int unsignedSize(int value) {
        int counter;
        int val = value < 0 ? -value - 1 : value;
        int mask = Integer.MIN_VALUE;
        for (counter = 32; (val & mask) == 0 && counter > 0; --counter) {
            mask >>>= 1;
        }
        return counter;
    }

    public static int size(int value) {
        int counter;
        int val;
        int mask = Integer.MIN_VALUE;
        int n = val = value < 0 ? -value - 1 : value;
        for (counter = 32; (val & mask) == 0 && counter > 0; --counter) {
            mask >>>= 1;
        }
        return counter + 1;
    }

    public static int maxSize(int ... values) {
        int max = 0;
        for (int value : values) {
            int size = Coder.size(value);
            max = max > size ? max : size;
        }
        return max;
    }

    public static int sizeVariableU32(int value) {
        int size = 1;
        for (int val = value; val > 127; val >>>= 7) {
            ++size;
        }
        return size;
    }

    private Coder() {
    }
}

