/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.action;

import com.flagstone.transform.action.Action;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import java.io.IOException;

public final class GotoLabel
implements Action {
    private static final String FORMAT = "GotoLabel: { label=%s}";
    private final transient String label;
    private transient int length;

    public GotoLabel(SWFDecoder coder) throws IOException {
        this.length = coder.readUnsignedShort();
        this.label = coder.readString();
    }

    public GotoLabel(String aString) {
        if (aString == null || aString.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.label = aString;
    }

    public GotoLabel(GotoLabel object) {
        this.label = object.label;
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public GotoLabel copy() {
        return this;
    }

    public String toString() {
        return String.format(FORMAT, this.label);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = context.strlen(this.label);
        return 3 + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeByte(140);
        coder.writeShort(this.length);
        coder.writeString(this.label);
    }
}

