/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.MovieTag;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.datatype.ColorTransform;
import com.flagstone.transform.datatype.CoordTransform;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import java.io.IOException;

public final class Place
implements MovieTag {
    private static final String FORMAT = "Place: { layer=%d; identifier=%d; transform=%s; colorTransform=%s}";
    private int identifier;
    private int layer;
    private CoordTransform transform;
    private ColorTransform colorTransform;
    private transient int length;

    public Place(SWFDecoder coder, Context context) throws IOException {
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        this.identifier = coder.readUnsignedShort();
        this.layer = coder.readUnsignedShort();
        this.transform = new CoordTransform(coder);
        if (coder.bytesRead() < this.length) {
            this.colorTransform = new ColorTransform(coder, context);
        }
        coder.check(this.length);
        coder.unmark();
    }

    public Place(int uid, int level, CoordTransform position) {
        this.setIdentifier(uid);
        this.setLayer(level);
        this.setTransform(position);
    }

    public Place(int uid, int level, CoordTransform matrix, ColorTransform cxform) {
        this.setIdentifier(uid);
        this.setLayer(level);
        this.setTransform(matrix);
        this.setColorTransform(cxform);
    }

    public Place(Place object) {
        this.identifier = object.identifier;
        this.layer = object.layer;
        this.transform = object.transform;
        this.colorTransform = object.colorTransform;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public Place setIdentifier(int uid) {
        if (uid < 1 || uid > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, uid);
        }
        this.identifier = uid;
        return this;
    }

    public int getLayer() {
        return this.layer;
    }

    public Place setLayer(int aNumber) {
        if (aNumber < 1 || aNumber > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, aNumber);
        }
        this.layer = aNumber;
        return this;
    }

    public CoordTransform getTransform() {
        return this.transform;
    }

    public Place setTransform(CoordTransform matrix) {
        if (matrix == null) {
            throw new IllegalArgumentException();
        }
        this.transform = matrix;
        return this;
    }

    public ColorTransform getColorTransform() {
        return this.colorTransform;
    }

    public Place setLocation(int xCoord, int yCoord) {
        this.transform = CoordTransform.translate(xCoord, yCoord);
        return this;
    }

    public Place setColorTransform(ColorTransform cxform) {
        this.colorTransform = cxform;
        return this;
    }

    @Override
    public Place copy() {
        return new Place(this);
    }

    public String toString() {
        return String.format(FORMAT, this.identifier, this.layer, this.transform, this.colorTransform);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = 4;
        this.length += this.transform.prepareToEncode(context);
        if (this.colorTransform != null) {
            this.length += this.colorTransform.prepareToEncode(context);
        }
        return 2 + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(319);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0x100 | this.length);
        }
        coder.mark();
        coder.writeShort(this.identifier);
        coder.writeShort(this.layer);
        this.transform.encode(coder, context);
        if (this.colorTransform != null) {
            this.colorTransform.encode(coder, context);
        }
        coder.check(this.length);
        coder.unmark();
    }
}

