/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.MovieTag;
import com.flagstone.transform.action.Action;
import com.flagstone.transform.action.ActionData;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.coder.SWFFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class DoAction
implements MovieTag {
    private static final String FORMAT = "DoAction: { actions=%s}";
    private List<Action> actions;
    private transient int length;

    public DoAction(SWFDecoder coder, Context context) throws IOException {
        SWFFactory<Action> decoder = context.getRegistry().getActionDecoder();
        this.actions = new ArrayList<Action>();
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        if (decoder == null) {
            this.actions.add(new ActionData(coder.readBytes(new byte[this.length])));
        } else {
            while (coder.bytesRead() < this.length) {
                decoder.getObject(this.actions, coder, context);
            }
        }
        coder.check(this.length);
        coder.unmark();
    }

    public DoAction() {
        this.actions = new ArrayList<Action>();
    }

    public DoAction(List<Action> list) {
        this.setActions(list);
    }

    public DoAction(DoAction object) {
        this.actions = new ArrayList<Action>(object.actions);
    }

    public DoAction add(Action anAction) {
        if (anAction == null) {
            throw new IllegalArgumentException();
        }
        this.actions.add(anAction);
        return this;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(List<Action> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.actions = list;
    }

    @Override
    public DoAction copy() {
        return new DoAction(this);
    }

    public String toString() {
        return String.format(FORMAT, this.actions.toString());
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = 0;
        for (Action action : this.actions) {
            this.length += action.prepareToEncode(context);
        }
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(831);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0x300 | this.length);
        }
        coder.mark();
        for (Action action : this.actions) {
            action.encode(coder, context);
        }
        coder.check(this.length);
        coder.unmark();
    }
}

