/*
 * Decompiled with CFR 0.152.
 */
package com.hammurapi.jcapture;

import com.hammurapi.jcapture.MappedImage;
import com.hammurapi.jcapture.Region;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Callable;
import javax.imageio.ImageIO;

public class ScreenShot
implements Callable<ScreenShot> {
    private final ScreenShot prev;
    private final int secNo;
    private ScreenShot next;
    private final long timeStamp;
    private int grabRange;
    private boolean transparency;
    private MappedImage image;
    private Point mousePosition;
    private double scale;
    private boolean border;
    private Dimension size;
    private FileChannel imageChannel;
    private String imageFormat;
    private List<Region> regions;
    private long totalPixels;
    private long differentPixels;
    private double diffThreshold = 0.7;

    public ScreenShot(BufferedImage image, Point mousePosition, ScreenShot prev, long timeStamp, int grabRange, boolean transparency, boolean border, double scale, FileChannel imageChannel, String imageFormat) throws IOException {
        this.image = new MappedImage(image, imageFormat, imageChannel);
        this.mousePosition = mousePosition;
        this.prev = prev;
        if (prev == null) {
            this.secNo = 0;
        } else {
            prev.next = this;
            this.secNo = prev.secNo + 1;
        }
        this.timeStamp = timeStamp;
        this.grabRange = grabRange;
        this.transparency = transparency;
        this.scale = scale;
        this.border = border;
        this.imageChannel = imageChannel;
        this.imageFormat = imageFormat;
    }

    public Point getMousePosition() {
        return this.mousePosition;
    }

    public float getFramesPerSecond() {
        long start = this.timeStamp;
        long end = 0L;
        int length = 0;
        ScreenShot sibling = this.next;
        while (sibling != null) {
            ++length;
            end = sibling.timeStamp;
            sibling = sibling.next;
        }
        if (length == 0) {
            return -1.0f;
        }
        return (float)((double)length * 1000.0) / (float)(end - start);
    }

    public double getDiffLevel() {
        return (double)this.differentPixels / (double)this.totalPixels;
    }

    @Override
    public ScreenShot call() throws Exception {
        BufferedImage img = this.image.getImage();
        if (this.scale < 0.99 || this.scale > 1.01) {
            BufferedImage scaled = new BufferedImage((int)((double)img.getWidth() * this.scale), (int)((double)img.getHeight() * this.scale), img.getType());
            Graphics2D g = scaled.createGraphics();
            g.setComposite(AlphaComposite.Src);
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.drawImage(img, 0, 0, scaled.getWidth(), scaled.getHeight(), null);
            g.dispose();
            img = scaled;
            if (this.mousePosition != null) {
                this.mousePosition = new Point((int)((double)this.mousePosition.x * this.scale), (int)((double)this.mousePosition.y * this.scale));
            }
        }
        if (this.border) {
            Graphics2D ssg = img.createGraphics();
            ssg.setColor(Color.GRAY);
            ssg.drawRect(0, 0, img.getWidth() - 1, img.getHeight() - 1);
        }
        this.size = new Dimension(this.image.getWidth(), this.image.getHeight());
        this.regions = new ArrayList<Region>();
        if (this.prev == null) {
            this.regions.add(new Region(this.image));
        } else {
            BufferedImage pimg = this.prev.image.getImage();
            int w = img.getWidth();
            for (int x = 0; x < w; ++x) {
                int h = img.getHeight();
                block1: for (int y = 0; y < h; ++y) {
                    int oldPixel;
                    ++this.totalPixels;
                    int newPixel = img.getRGB(x, y);
                    if (newPixel == (oldPixel = pimg.getRGB(x, y))) continue;
                    ++this.differentPixels;
                    for (Region region : this.regions) {
                        if (!region.merge(x, y)) continue;
                        continue block1;
                    }
                    this.regions.add(new Region(img, this.imageFormat, this.imageChannel, pimg, this.transparency, x, y, this.grabRange));
                }
            }
            if (this.getDiffLevel() > this.diffThreshold) {
                this.regions.clear();
                this.regions.add(new Region(this.image));
            } else {
                for (int i = 0; i < this.regions.size() - 1; ++i) {
                    ListIterator<Region> lit = this.regions.listIterator(i + 1);
                    Region master = this.regions.get(i);
                    while (lit.hasNext()) {
                        if (!master.merge(lit.next())) continue;
                        lit.remove();
                    }
                }
                for (Region region : this.regions) {
                    region.grabImage();
                }
            }
            if (this.prev != null) {
                this.prev.image = null;
            }
        }
        ListIterator<Region> oit = this.regions.listIterator();
        block6: while (oit.hasNext()) {
            Region or = oit.next();
            if (oit.hasPrevious()) {
                ListIterator<Region> iit = this.regions.listIterator(oit.previousIndex());
                while (iit.hasPrevious()) {
                    if (!or.dedup(iit.previous())) continue;
                    continue block6;
                }
            }
            ScreenShot sibling = this.prev;
            while (sibling != null) {
                for (Region sr : sibling.regions) {
                    if (!or.dedup(sr)) continue;
                    continue block6;
                }
                sibling = sibling.prev;
            }
        }
        return this;
    }

    public void dump(File dir, String imageFormat) throws IOException {
        for (int i = 0; i < this.regions.size(); ++i) {
            BufferedImage img = this.regions.get(i).getImage().getImage();
            if (img == null) continue;
            ImageIO.write((RenderedImage)img, imageFormat, new File(dir, "s_" + this.secNo + "_" + i + "." + imageFormat));
        }
    }

    public List<Region> getRegions() {
        return this.regions;
    }

    public int getSecNo() {
        return this.secNo;
    }

    public boolean isActive() {
        if (!this.regions.isEmpty()) {
            return true;
        }
        if (this.mousePosition == null) {
            if (this.prev == null) {
                return false;
            }
            return this.prev.getMousePosition() != null;
        }
        if (this.prev == null) {
            return true;
        }
        return !this.mousePosition.equals(this.prev.getMousePosition());
    }

    public Dimension getSize() {
        return this.size;
    }
}

