/*
 * Decompiled with CFR 0.152.
 */
package com.hammurapi.jcapture;

import com.hammurapi.jcapture.VideoEncoder;
import java.awt.Dimension;
import java.io.Closeable;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;

public class Movie
implements Closeable {
    private float framesPerSecond;
    private List<VideoEncoder.Fragment> fragments;
    private Dimension frameDimension;
    private Closeable imagesFileCloseable;

    public Movie(Dimension frameDimension, float framesPerSecond, List<VideoEncoder.Fragment> fragments, Closeable imagesFileCloseable) {
        this.frameDimension = frameDimension;
        this.framesPerSecond = framesPerSecond;
        this.fragments = fragments;
        this.imagesFileCloseable = imagesFileCloseable;
    }

    public List<VideoEncoder.Fragment> getFragments() {
        return this.fragments;
    }

    public float getFramesPerSecond() {
        return this.framesPerSecond;
    }

    public Dimension getFrameDimension() {
        return this.frameDimension;
    }

    public String toString() {
        int frames = 0;
        for (VideoEncoder.Fragment f : this.fragments) {
            frames += f.getFrames().size();
        }
        long length = (long)((float)frames / this.framesPerSecond);
        return MessageFormat.format("{0,number,00}:{1,number,00}:{2,number,00}, {3} frames", length / 3600L, length / 60L % 60L, length % 60L, frames);
    }

    @Override
    public void close() throws IOException {
        if (this.imagesFileCloseable != null) {
            this.imagesFileCloseable.close();
        }
    }
}

