/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.shapers;

import edu.xtec.jclic.shapers.ShapeData;
import edu.xtec.jclic.shapers.Shaper;
import edu.xtec.util.JDomUtility;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;

public class Holes
extends Shaper {
    protected double scaleW = 1.0;
    protected double scaleH = 1.0;
    protected ShapeData enclosingShapeData = null;
    protected boolean showEnclosure = true;
    public static final String SHAPE = "shape";
    public static final String SHOW_ENCLOSURE = "showEnclosure";
    protected static final String SCALE_W = "scaleX";
    protected static final String SCALE_H = "scaleY";
    protected static final String ENCLOSING = "enclosing";

    public Holes(int n, int n2) {
        super(1, 1);
        this.shapeData = new ShapeData[0];
        this.nCols = n;
        this.nRows = n2;
    }

    public void reset(int n, int n2) {
        this.nCols = n;
        this.nRows = n2;
        this.initiated = false;
    }

    public String getEditorPanelClassName() {
        return this.getClass().getPackage().getName() + ".HolesEditorPanel";
    }

    public Element getJDomElement() {
        Element element = super.getJDomElement();
        if (!this.showEnclosure) {
            element.setAttribute(SHOW_ENCLOSURE, JDomUtility.boolString((boolean)this.showEnclosure));
        }
        if (this.scaleW != 1.0) {
            element.setAttribute(SCALE_W, Double.toString(this.scaleW));
        }
        if (this.scaleH != 1.0) {
            element.setAttribute(SCALE_H, Double.toString(this.scaleH));
        }
        if (this.enclosingShapeData != null) {
            element.addContent((Content)new Element(ENCLOSING).addContent((Content)this.enclosingShapeData.getJDomElement(this.scaleW, this.scaleH)));
        }
        if (this.shapeData != null) {
            int n = 0;
            while (n < this.nCells) {
                element.addContent((Content)this.shapeData[n].getJDomElement(this.scaleW, this.scaleH));
                ++n;
            }
        }
        return element;
    }

    public void setProperties(Element element, Object object) throws Exception {
        List list;
        this.scaleW = JDomUtility.getDoubleAttr((Element)element, (String)SCALE_W, (double)this.scaleW);
        this.scaleH = JDomUtility.getDoubleAttr((Element)element, (String)SCALE_H, (double)this.scaleH);
        this.showEnclosure = JDomUtility.getBoolAttr((Element)element, (String)SHOW_ENCLOSURE, (boolean)this.showEnclosure);
        Element element2 = element.getChild(ENCLOSING);
        if (element2 != null) {
            element2 = element2.getChild(SHAPE);
            this.enclosingShapeData = ShapeData.getShapeData(element2, this.scaleW, this.scaleH);
            this.showEnclosure = true;
        }
        if (!(list = element.getChildren(SHAPE)).isEmpty()) {
            this.nCells = list.size();
            this.shapeData = new ShapeData[this.nCells];
            int n = 0;
            while (n < this.nCells) {
                this.shapeData[n] = ShapeData.getShapeData((Element)list.get(n), this.scaleW, this.scaleH);
                ++n;
            }
        } else {
            this.nCells = 0;
            this.nRows = 0;
            this.nCols = 0;
            this.shapeData = null;
        }
    }

    protected void buildShapes() {
        if (this.nCells > 0) {
            this.initiated = true;
        }
    }

    public boolean hasRemainder() {
        return this.showEnclosure;
    }

    protected ShapeData getEnclosingShapeData() {
        if (!this.showEnclosure) {
            return null;
        }
        return this.enclosingShapeData != null ? this.enclosingShapeData : super.getEnclosingShapeData();
    }

    public Object clone() throws CloneNotSupportedException {
        Holes holes = (Holes)super.clone();
        if (this.enclosingShapeData != null) {
            this.enclosingShapeData = (ShapeData)this.enclosingShapeData.clone();
        }
        return holes;
    }

    public void removeShape(int n) {
        if (this.shapeData == null || n < 0 || n >= this.shapeData.length) {
            return;
        }
        ShapeData[] shapeDataArray = new ShapeData[this.shapeData.length - 1];
        System.arraycopy(this.shapeData, 0, shapeDataArray, 0, n);
        System.arraycopy(this.shapeData, n + 1, shapeDataArray, n, this.shapeData.length - n - 1);
        this.nCells = shapeDataArray.length;
        this.shapeData = shapeDataArray;
    }

    public void addShape(ShapeData shapeData) {
        ShapeData[] shapeDataArray = new ShapeData[this.shapeData.length + 1];
        System.arraycopy(this.shapeData, 0, shapeDataArray, 0, this.shapeData.length);
        shapeDataArray[this.shapeData.length] = shapeData;
        this.nCells = shapeDataArray.length;
        this.shapeData = shapeDataArray;
    }

    public void modifyShape(int n, ShapeData shapeData) {
        if (n >= 0 && n < this.shapeData.length) {
            shapeData.comment = this.shapeData[n] != null ? this.shapeData[n].comment : "";
            this.shapeData[n] = shapeData;
        }
    }
}

