/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.media;

import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.media.AudioPlayer;
import edu.xtec.util.ExtendedByteArrayInputStream;
import edu.xtec.util.StreamIO;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.tritonus.applet.AppletMpegSPIWorkaround;
import org.tritonus.applet.AppletVorbisSPIWorkaround;

public class JavaSoundAudioPlayer
implements AudioPlayer {
    private Clip clip;
    protected AudioInputStream ais;
    protected boolean isMpeg;
    protected boolean isOgg;
    protected boolean isWav;
    static final int INTERNAL_BUFFER_SIZE = 1024;
    static final int CHECK_BUFFER_SIZE = 96;
    static final int BIT_SAMPLE_SIZE = 16;
    static final boolean BIG_ENDIAN = true;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;
    static /* synthetic */ Class class$javax$sound$sampled$Clip;

    public boolean setDataSource(Object object) throws Exception {
        DataLine.Info info;
        Object object2;
        this.close();
        InputStream inputStream = null;
        AudioFileFormat audioFileFormat = null;
        if (object instanceof ExtendedByteArrayInputStream) {
            inputStream = this.checkInputStream((InputStream)object, ((ExtendedByteArrayInputStream)object).getName());
        } else if (object instanceof InputStream) {
            inputStream = this.checkInputStream((InputStream)object, null);
        } else if (object instanceof File) {
            inputStream = this.checkInputStream(new FileInputStream((File)object), ((File)object).getName());
        } else {
            object2 = null;
            if (object instanceof URL) {
                object2 = (URL)object;
            } else if (object instanceof String) {
                object2 = new URL((String)object);
            }
            if (object2 != null) {
                inputStream = this.checkInputStream(((URL)object2).openStream(), object.toString());
            }
        }
        if (inputStream != null) {
            if (this.isMpeg || !this.isWav && !this.isOgg) {
                try {
                    audioFileFormat = AppletMpegSPIWorkaround.getAudioFileFormat((InputStream)inputStream);
                    this.ais = AppletMpegSPIWorkaround.getAudioInputStream((InputStream)inputStream);
                    this.isMpeg = true;
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                    this.isMpeg = false;
                }
            }
            if (this.isOgg || !this.isMpeg && !this.isWav) {
                try {
                    audioFileFormat = AppletVorbisSPIWorkaround.getAudioFileFormat((InputStream)inputStream);
                    this.ais = AppletVorbisSPIWorkaround.getAudioInputStream((InputStream)inputStream);
                    this.isOgg = true;
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                    this.isOgg = false;
                }
            }
            if (this.isWav || !this.isMpeg && !this.isOgg) {
                audioFileFormat = AudioSystem.getAudioFileFormat(inputStream);
                this.ais = AudioSystem.getAudioInputStream(inputStream);
            }
        }
        if (this.ais != null && !AudioSystem.isLineSupported(info = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = JavaSoundAudioPlayer.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, (AudioFormat)(object2 = this.ais.getFormat()), 1024))) {
            Object object3 = object2;
            AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, ((AudioFormat)object3).getSampleRate(), 16, ((AudioFormat)object3).getChannels(), ((AudioFormat)object3).getChannels() * 2, ((AudioFormat)object3).getSampleRate(), true);
            this.ais = this.isMpeg ? AppletMpegSPIWorkaround.getAudioInputStream((AudioFormat)audioFormat, (AudioInputStream)this.ais) : (this.isOgg ? AppletVorbisSPIWorkaround.getAudioInputStream((AudioFormat)audioFormat, (AudioInputStream)this.ais) : AudioSystem.getAudioInputStream(audioFormat, this.ais));
        }
        return this.ais != null;
    }

    public Clip getClip() throws Exception {
        if (this.clip == null && this.ais != null) {
            this.clip = (Clip)AudioSystem.getLine(new DataLine.Info(class$javax$sound$sampled$Clip == null ? (class$javax$sound$sampled$Clip = JavaSoundAudioPlayer.class$("javax.sound.sampled.Clip")) : class$javax$sound$sampled$Clip, this.ais.getFormat(), 1024));
        }
        return this.clip;
    }

    public void realize(String string, MediaBag mediaBag) throws Exception {
        if (string != null) {
            this.setDataSource(mediaBag.getMediaDataSource(string));
        }
        if (this.ais != null && this.getClip() != null) {
            this.clip.open(this.ais);
        }
    }

    public void close() {
        if (this.clip != null) {
            this.clip.close();
            this.clip = null;
        }
        this.ais = null;
    }

    public void play() {
        try {
            this.stop();
            if (this.getClip() != null) {
                this.clip.setFramePosition(0);
                this.clip.start();
            }
        }
        catch (Exception exception) {
            System.err.println("Error playing sound:\n" + exception);
        }
    }

    public void stop() {
        if (this.clip != null && this.clip.isActive()) {
            this.clip.stop();
        }
    }

    protected InputStream checkInputStream(InputStream inputStream, String string) throws Exception {
        String string2;
        String string3 = string2 = string == null ? null : string.toLowerCase();
        if (string2 != null) {
            if (string2.endsWith(".wav")) {
                this.isWav = true;
            } else if (string2.endsWith(".ogg")) {
                this.isOgg = true;
            } else if (string2.endsWith(".mp3")) {
                this.isMpeg = true;
            }
        }
        if (string2 == null || this.isWav) {
            byte[] byArray = null;
            if (!inputStream.markSupported()) {
                byArray = StreamIO.readInputStream((InputStream)inputStream);
                inputStream = new ByteArrayInputStream(byArray);
            }
            inputStream.mark(96);
            byte[] byArray2 = new byte[96];
            inputStream.read(byArray2);
            inputStream.reset();
            if (byArray2[0] == 82 && byArray2[1] == 73 && byArray2[2] == 70 && byArray2[3] == 70 && byArray2[8] == 87 && byArray2[9] == 65 && byArray2[10] == 86 && byArray2[11] == 69 && byArray2[12] == 102 && byArray2[13] == 109 && byArray2[14] == 116 && byArray2[15] == 32 && byArray2[20] == 85 && byArray2[21] == 0) {
                int n = -1;
                int n2 = 17;
                while (n2 < 90) {
                    if (byArray2[n2] == 100 && byArray2[n2 + 1] == 97 && byArray2[n2 + 2] == 116 && byArray2[n2 + 3] == 97) {
                        n = n2 + 4 + 4;
                        inputStream.skip(n);
                        this.isWav = false;
                        this.isMpeg = true;
                        break;
                    }
                    ++n2;
                }
            }
        }
        return inputStream;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

