/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.media;

import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.media.EventSoundsElement;
import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.Options;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import org.jdom.Content;
import org.jdom.Element;

public class EventSounds
implements Domable,
Cloneable {
    public static boolean globalEnabled = true;
    public static final String ELEMENT_NAME = "eventSounds";
    public static final String ENABLED = "enabled";
    public static final int START = 0;
    public static final int CLICK = 1;
    public static final int ACTION_ERROR = 2;
    public static final int ACTION_OK = 3;
    public static final int FINISHED_ERROR = 4;
    public static final int FINISHED_OK = 5;
    public static final int NUM_EVENTS = 6;
    public static final String[] EVENT_NAMES = new String[]{"start", "click", "actionError", "actionOk", "finishedError", "finishedOk"};
    protected EventSounds parent;
    protected EventSoundsElement[] elements = new EventSoundsElement[6];
    protected int enabled = 2;

    public EventSounds(EventSounds eventSounds) {
        this.parent = eventSounds;
    }

    public Element getJDomElement() {
        Element element = new Element(ELEMENT_NAME);
        boolean bl = true;
        if (this.enabled != 2) {
            element.setAttribute(ENABLED, JDomUtility.triStateString((int)this.enabled));
            bl = false;
        }
        int n = 0;
        while (n < 6) {
            Element element2;
            if (this.elements[n] != null && (element2 = this.elements[n].getJDomElement()) != null) {
                element.addContent((Content)element2);
                bl = false;
            }
            ++n;
        }
        return bl ? null : element;
    }

    public static EventSounds getEventSounds(Element element) throws Exception {
        EventSounds eventSounds = new EventSounds(null);
        eventSounds.setProperties(element, null);
        return eventSounds;
    }

    public void setProperties(Element element, Object object) throws Exception {
        JDomUtility.checkName((Element)element, (String)ELEMENT_NAME);
        this.enabled = JDomUtility.getTriStateAttr((Element)element, (String)ENABLED, (int)this.enabled);
        Iterator iterator = element.getChildren().iterator();
        while (iterator.hasNext()) {
            int n;
            EventSoundsElement eventSoundsElement = EventSoundsElement.getEventSoundsElement((Element)iterator.next());
            if (eventSoundsElement == null || (n = JDomUtility.getStrIndexAttr((String)eventSoundsElement.getId(), (String[])EVENT_NAMES, (int)-1)) < 0 || n >= 6) continue;
            this.elements[n] = eventSoundsElement;
        }
    }

    public static void listReferences(Element element, HashMap hashMap) {
        int n = 0;
        while (n < 6) {
            Element element2 = element.getChild(EVENT_NAMES[n]);
            if (element2 != null) {
                hashMap.put(element2.getAttributeValue("file"), "media");
            }
            ++n;
        }
    }

    public void setParent(EventSounds eventSounds) {
        this.parent = eventSounds;
    }

    public boolean realize(Options options, MediaBag mediaBag) {
        Exception exception = null;
        try {
            int n = 0;
            while (n < 6) {
                if (this.elements[n] != null) {
                    this.elements[n].realize(options, mediaBag);
                }
                ++n;
            }
        }
        catch (Exception exception2) {
            System.err.println("Error realizing event sound:\n" + exception2);
            exception = exception2;
        }
        return exception == null;
    }

    public void setDataSource(int n, Object object, Options options) throws Exception {
        if (n < 0 || n >= 6) {
            return;
        }
        if (this.elements[n] == null) {
            this.elements[n] = new EventSoundsElement(EVENT_NAMES[n]);
        }
        this.elements[n].setDataSource(object, options);
    }

    public EventSoundsElement getElement(int n) {
        if (n < 0 || n >= 6) {
            return null;
        }
        return this.elements[n];
    }

    public EventSoundsElement createElement(int n) {
        if (n < 0 || n >= 6) {
            return null;
        }
        if (this.elements[n] == null) {
            this.elements[n] = new EventSoundsElement(EVENT_NAMES[n]);
        }
        return this.elements[n];
    }

    public int getEnabledChain(int n) {
        int n2 = this.enabled;
        if (n2 == 2 && n >= 0 && n < 6) {
            if (this.elements[n] == null) {
                n2 = this.parent == null ? n2 : this.parent.getEnabledChain(n);
            } else {
                n2 = this.elements[n].getEnabled();
                if (n2 == 2 && this.parent != null) {
                    n2 = this.parent.getEnabledChain(n);
                }
            }
        }
        return n2;
    }

    public EventSoundsElement getElementChain(int n) {
        EventSoundsElement eventSoundsElement = null;
        if (n < 0 || n >= 6) {
            return null;
        }
        eventSoundsElement = this.elements[n];
        if (eventSoundsElement == null && this.parent != null) {
            return this.parent.getElementChain(n);
        }
        return eventSoundsElement;
    }

    public void playNow(int n) {
        if (!globalEnabled) {
            return;
        }
        EventSoundsElement eventSoundsElement = null;
        if (this.getEnabledChain(n) != 0 && (eventSoundsElement = this.getElementChain(n)) != null) {
            eventSoundsElement.play();
        }
    }

    public void play(int n) {
        if (!globalEnabled) {
            return;
        }
        EventSoundsElement eventSoundsElement = null;
        if (this.getEnabledChain(n) != 0 && (eventSoundsElement = this.getElementChain(n)) != null) {
            final EventSoundsElement eventSoundsElement2 = eventSoundsElement;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    eventSoundsElement2.play();
                }
            });
        }
    }

    public void close() {
        int n = 0;
        while (n < 6) {
            if (this.elements[n] != null) {
                this.elements[n].close();
                this.elements[n] = null;
            }
            ++n;
        }
        this.parent = null;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public Object clone() {
        EventSounds eventSounds = new EventSounds(this.parent);
        int n = 0;
        while (n < this.elements.length) {
            if (this.elements[n] != null) {
                eventSounds.elements[n] = (EventSoundsElement)this.elements[n].clone();
            }
            ++n;
        }
        eventSounds.enabled = this.enabled;
        return eventSounds;
    }

    public int getEnabled() {
        return this.enabled;
    }

    public void setEnabled(int n) {
        this.enabled = n;
    }
}

