/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.boxes.AbstractBox;
import edu.xtec.jclic.boxes.ActiveBagContent;
import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.media.ActiveMediaPlayer;
import edu.xtec.jclic.misc.Utils;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceBridge;
import edu.xtec.util.StrUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.text.AttributedString;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

public class ActiveBox
extends AbstractBox
implements Cloneable {
    public static boolean compressImages = true;
    public static boolean USE_TRANSFORM = false;
    public int idOrder;
    public int idLoc;
    public int idAss;
    protected ActiveBoxContent content;
    protected ActiveBoxContent altContent;
    public boolean hasHostedComponent;
    protected ActiveMediaPlayer hostedMediaPlayer;

    public ActiveBox(AbstractBox abstractBox, JComponent jComponent, BoxBase boxBase) {
        super(abstractBox, jComponent, boxBase);
        this.clear();
        this.idLoc = -1;
        this.idOrder = -1;
        this.idAss = -1;
        this.hasHostedComponent = false;
    }

    public ActiveBox(AbstractBox abstractBox, JComponent jComponent, int n, Rectangle2D rectangle2D, BoxBase boxBase) {
        super(abstractBox, jComponent, boxBase);
        this.clear();
        this.idLoc = n;
        this.setBounds(rectangle2D);
    }

    public void setHostedMediaPlayer(ActiveMediaPlayer activeMediaPlayer) {
        ActiveMediaPlayer activeMediaPlayer2 = this.hostedMediaPlayer;
        this.hostedMediaPlayer = activeMediaPlayer;
        if (activeMediaPlayer2 != null && activeMediaPlayer2 != activeMediaPlayer) {
            activeMediaPlayer2.linkTo(null);
        }
    }

    public ActiveBoxContent getCurrentContent() {
        return this.isAlternative() ? this.altContent : this.content;
    }

    public ActiveBoxContent getContent() {
        if (this.content == null) {
            this.setContent(new ActiveBoxContent());
        }
        return this.content;
    }

    public void clear() {
        this.content = null;
        this.altContent = null;
        this.idOrder = -1;
        this.setInactive(true);
        if (!this.hasHostedComponent) {
            this.setHostedComponent(null);
        }
        this.setHostedMediaPlayer(null);
    }

    public boolean isEquivalent(ActiveBox activeBox, boolean bl) {
        return activeBox != null && this.content != null && this.content.isEquivalent(activeBox.content, bl);
    }

    public boolean isCurrentContentEquivalent(ActiveBox activeBox, boolean bl) {
        return activeBox != null && this.getCurrentContent() != null && this.getCurrentContent().isEquivalent(activeBox.getCurrentContent(), bl);
    }

    public void exchangeLocation(ActiveBox activeBox) {
        Point2D.Double double_ = new Point2D.Double(this.x, this.y);
        int n = this.idLoc;
        this.setLocation(activeBox.getLocation());
        activeBox.setLocation(double_);
        this.idLoc = activeBox.idLoc;
        activeBox.idLoc = n;
    }

    public void copyContent(ActiveBox activeBox) {
        this.idOrder = activeBox.idOrder;
        this.idAss = activeBox.idAss;
        this.content = activeBox.content;
        this.altContent = activeBox.altContent;
        if (this.content != null) {
            if (this.content.bb != null) {
                this.setBoxBase(this.content.bb);
            }
            if (this.content.border != null && activeBox.hasBorder() != this.content.border.booleanValue()) {
                this.setBorder(this.content.border);
            }
            if (this.content.img != null && this.content.animated) {
                Utils.refreshAnimatedImage(this.content.img);
            }
        }
        this.setInactive(activeBox.isInactive());
        this.setInverted(activeBox.isInverted());
        this.setAlternative(activeBox.isAlternative());
        this.setHostedComponent(activeBox.getHostedComponent());
        this.hasHostedComponent = activeBox.hasHostedComponent;
        this.setHostedMediaPlayer(activeBox.hostedMediaPlayer);
        if (this.hostedMediaPlayer != null) {
            this.hostedMediaPlayer.setVisualComponentVisible(!this.isInactive() && this.isVisible());
        }
    }

    public void exchangeContent(ActiveBox activeBox) {
        ActiveBox activeBox2 = new ActiveBox(this.getParent(), this.getContainerX(), this.getBoxBaseX());
        activeBox2.copyContent(this);
        this.copyContent(activeBox);
        activeBox.copyContent(activeBox2);
    }

    public void setTextContent(String string) {
        if (string == null) {
            string = "";
        }
        if (this.content == null) {
            this.content = new ActiveBoxContent();
        }
        this.content.rawText = new String(string);
        this.content.text = new String(string);
        this.content.mediaContent = null;
        this.content.img = null;
        this.setHostedComponent(null);
        this.setInactive(false);
        this.checkHostedComponent();
        this.setHostedMediaPlayer(null);
    }

    public void setIdOrder(int n) {
        this.idOrder = n;
    }

    public void setIdAss(int n) {
        this.idAss = n;
    }

    public void setDefaultIdAss() {
        this.idAss = this.content == null ? -1 : this.content.id;
    }

    public boolean isAtPlace() {
        return this.idOrder == this.idLoc;
    }

    public void setContent(ActiveBoxContent activeBoxContent) {
        this.setHostedComponent(null);
        this.setHostedMediaPlayer(null);
        this.content = activeBoxContent;
        if (this.content != null) {
            if (this.content.bb != this.getBoxBaseX()) {
                this.setBoxBase(this.content.bb);
            }
            if (this.content.border != null && this.hasBorder() != this.content.border.booleanValue()) {
                this.setBorder(this.content.border);
            }
            this.setInactive(false);
            if (activeBoxContent.img != null && activeBoxContent.animated) {
                Utils.refreshAnimatedImage(activeBoxContent.img);
            }
            this.checkHostedComponent();
            this.checkAutoStartMedia();
        } else {
            this.clear();
        }
    }

    public void checkAutoStartMedia() {
        ActiveBoxContent activeBoxContent = this.getContent();
        if (activeBoxContent != null && activeBoxContent.mediaContent != null && activeBoxContent.mediaContent.autoStart && activeBoxContent.amp != null) {
            final ActiveMediaPlayer activeMediaPlayer = activeBoxContent.amp;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    activeMediaPlayer.play(ActiveBox.this);
                }
            });
        }
    }

    public void setAltContent(ActiveBoxContent activeBoxContent) {
        this.altContent = activeBoxContent;
        this.checkHostedComponent();
        if (this.isAlternative() && this.hostedMediaPlayer != null) {
            this.setHostedMediaPlayer(null);
        }
    }

    public void setCurrentContent(ActiveBoxContent activeBoxContent) {
        if (this.isAlternative()) {
            this.setAltContent(activeBoxContent);
        } else {
            this.setContent(activeBoxContent);
        }
        this.repaint();
    }

    public void setContent(ActiveBagContent activeBagContent, int n) {
        if (n < 0) {
            n = this.idOrder;
        }
        if (activeBagContent == null || n >= activeBagContent.getNumCells()) {
            return;
        }
        if (activeBagContent.bb != this.getBoxBaseX()) {
            this.setBoxBase(activeBagContent.bb);
        }
        this.setContent(activeBagContent.getActiveBoxContent(n));
    }

    public void setAltContent(ActiveBagContent activeBagContent, int n) {
        if (n < 0) {
            n = this.idOrder;
        }
        if (activeBagContent == null || activeBagContent.isEmpty() || n > activeBagContent.getNumCells()) {
            return;
        }
        this.setAltContent(activeBagContent.getActiveBoxContent(n));
    }

    public boolean switchToAlt(ResourceBridge resourceBridge) {
        if (this.isAlternative() || this.altContent == null || this.altContent.isEmpty()) {
            return false;
        }
        this.setHostedComponent(null);
        this.setHostedMediaPlayer(null);
        this.setAlternative(true);
        this.checkHostedComponent();
        this.checkAutoStartMedia();
        return true;
    }

    protected void checkHostedComponent() {
        if (this.hasHostedComponent) {
            return;
        }
        ActiveBoxContent activeBoxContent = this.getCurrentContent();
        BoxBase boxBase = this.getBoxBaseResolve();
        Component component = null;
        if (!this.isInactive() && activeBoxContent != null && activeBoxContent.htmlText != null) {
            String string = activeBoxContent.htmlText;
            if (activeBoxContent.innerHtmlText != null) {
                Color color;
                Color color2 = this.isInactive() ? boxBase.inactiveColor : (color = this.isInverted() ? boxBase.textColor : boxBase.backColor);
                Color color3 = this.isInverted() ? boxBase.backColor : (this.isAlternative() ? boxBase.alternativeColor : boxBase.textColor);
                Font font = boxBase.getOriginalFont();
                string = "<html><body bgcolor=\"#" + Integer.toHexString(color.getRGB() & 0xFFFFFF) + "\">" + "<div style=\"" + "background: #" + Integer.toHexString(color.getRGB() & 0xFFFFFF) + "; " + "color: #" + Integer.toHexString(color3.getRGB() & 0xFFFFFF) + "; " + "font-family: " + font.getFontName() + "; " + "font-size: " + font.getSize() + "pt; " + (font.isBold() ? "font-weight: bold;" : "") + "text-align: " + (activeBoxContent.txtAlign[0] == 0 ? "left" : (activeBoxContent.txtAlign[0] == 2 ? "right" : "center")) + "; " + "width: 100%; " + "\">" + activeBoxContent.innerHtmlText + "</div>" + "</body></html>";
            }
            if ((component = this.getHostedComponent()) != null && component instanceof JLabel) {
                ((JLabel)component).setText(string);
                return;
            }
            component = new JLabel(string);
        }
        this.setHostedComponent(component);
    }

    public boolean updateContent(Graphics2D graphics2D, Rectangle rectangle, ImageObserver imageObserver) {
        block37: {
            TextLayout textLayout;
            int n;
            LineBreakMeasurer lineBreakMeasurer;
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            BoxBase boxBase;
            ActiveBoxContent activeBoxContent;
            block38: {
                Cloneable cloneable;
                activeBoxContent = this.getCurrentContent();
                boxBase = this.getBoxBaseResolve();
                if (this.isInactive() || activeBoxContent == null || this.width < 2.0 || this.height < 2.0) {
                    return true;
                }
                Rectangle2D.Double double_ = null;
                if (activeBoxContent.img != null) {
                    if (activeBoxContent.imgClip != null) {
                        Rectangle rectangle2 = activeBoxContent.imgClip.getBounds();
                        if (USE_TRANSFORM) {
                            if (rectangle2.width > 0 && rectangle2.height > 0) {
                                AffineTransform affineTransform = null;
                                if ((double)rectangle2.width != this.width || (double)rectangle2.height != this.height) {
                                    d5 = this.width / (double)rectangle2.width;
                                    d4 = this.height / (double)rectangle2.height;
                                    affineTransform = AffineTransform.getScaleInstance(d5, d4);
                                    affineTransform.translate(this.x / d5 - (double)rectangle2.x, this.y / d4 - (double)rectangle2.y);
                                } else {
                                    affineTransform = AffineTransform.getTranslateInstance(this.x - (double)rectangle2.x, this.y - (double)rectangle2.y);
                                }
                                graphics2D.drawImage(activeBoxContent.img, affineTransform, imageObserver);
                            }
                        } else {
                            graphics2D.drawImage(activeBoxContent.img, (int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), rectangle2.x, rectangle2.y, rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height, imageObserver);
                        }
                    } else {
                        double d6;
                        double d7;
                        boolean bl = false;
                        double d8 = activeBoxContent.img.getWidth(imageObserver);
                        if (d8 == 0.0) {
                            d8 = this.width;
                        }
                        if ((d5 = (double)activeBoxContent.img.getHeight(imageObserver)) == 0.0) {
                            d5 = this.height;
                        }
                        double d9 = 1.0;
                        if (compressImages && this.width > 0.0 && this.height > 0.0 && (d8 > this.width || d5 > this.height)) {
                            d9 = Math.min(this.width / d8, this.height / d5);
                            d8 *= d9;
                            d5 *= d9;
                            bl = true;
                        }
                        double d10 = activeBoxContent.imgAlign[0] == 0 ? 0.0 : (d7 = activeBoxContent.imgAlign[0] == 2 ? this.width - d8 : (this.width - d8) / 2.0);
                        double d11 = activeBoxContent.imgAlign[1] == 0 ? 0.0 : (d6 = activeBoxContent.imgAlign[1] == 2 ? this.height - d5 : (this.height - d5) / 2.0);
                        if (bl) {
                            if (USE_TRANSFORM) {
                                cloneable = AffineTransform.getScaleInstance(d9, d9);
                                cloneable.translate((this.x + d7) / d9, (this.y + d6) / d9);
                                graphics2D.drawImage(activeBoxContent.img, (AffineTransform)cloneable, imageObserver);
                            } else {
                                graphics2D.drawImage(activeBoxContent.img, (int)(this.x + d7), (int)(this.y + d6), (int)d8, (int)d5, imageObserver);
                            }
                        } else {
                            graphics2D.drawImage(activeBoxContent.img, (int)(this.x + d7), (int)(this.y + d6), imageObserver);
                        }
                        if (activeBoxContent.avoidOverlapping && activeBoxContent.text != null) {
                            double_ = new Rectangle2D.Double(Math.max(0.0, d7), Math.max(0.0, d6), Math.min(this.width, d8), Math.min(this.height, d5));
                        }
                    }
                }
                if (activeBoxContent.text == null || activeBoxContent.text.length() <= 0) break block37;
                d3 = this.x;
                d5 = this.y;
                d4 = this.width;
                d2 = this.height;
                if (double_ == null) break block38;
                double[] dArray = new double[]{0.0, double_.x, double_.x + double_.width, d4};
                double[] dArray2 = new double[]{0.0, double_.y, double_.y + double_.height, d2};
                Rectangle2D.Double[] doubleArray = new Rectangle2D.Double[]{new Rectangle2D.Double(dArray[0], dArray2[0], dArray[3], dArray2[1]), new Rectangle2D.Double(dArray[0], dArray2[2], dArray[3], dArray2[3] - dArray2[2]), new Rectangle2D.Double(dArray[0], dArray2[0], dArray[1], dArray2[3]), new Rectangle2D.Double(dArray[2], dArray2[0], dArray[3] - dArray[2], dArray2[3])};
                cloneable = doubleArray[0];
                d = ((Rectangle2D.Double)cloneable).width * ((Rectangle2D.Double)cloneable).height;
                int n2 = 1;
                while (n2 < doubleArray.length) {
                    block39: {
                        double d12;
                        block40: {
                            d12 = doubleArray[n2].width * doubleArray[n2].height;
                            if (!(d12 > d - 1.0)) break block39;
                            if (!(Math.abs(d12 - d) <= 1.0)) break block40;
                            boolean bl = false;
                            switch (n2) {
                                case 1: {
                                    bl = activeBoxContent.txtAlign[1] == 2;
                                    break;
                                }
                                case 2: {
                                    bl = activeBoxContent.txtAlign[0] == 0;
                                    break;
                                }
                                case 3: {
                                    boolean bl2 = bl = activeBoxContent.txtAlign[0] == 2;
                                }
                            }
                            if (!bl) break block39;
                        }
                        d = d12;
                        cloneable = doubleArray[n2];
                    }
                    ++n2;
                }
                d3 += ((Rectangle2D.Double)cloneable).x;
                d5 += ((Rectangle2D.Double)cloneable).y;
                d4 = ((Rectangle2D.Double)cloneable).width;
                d2 = ((Rectangle2D.Double)cloneable).height;
            }
            double d13 = Math.max(5.0, d4 - (double)(2 * boxBase.textMargin));
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            int n3 = StrUtils.countSpaces((String)activeBoxContent.text) + 1;
            while (true) {
                AttributedString attributedString = new AttributedString(activeBoxContent.text);
                attributedString.addAttribute(TextAttribute.FONT, boxBase.getFont());
                lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), fontRenderContext);
                double d14 = 0.0;
                d = 0.0;
                double d15 = 0.0;
                lineBreakMeasurer.setPosition(0);
                n = activeBoxContent.text.indexOf(10);
                int n4 = 0;
                while (lineBreakMeasurer.getPosition() < activeBoxContent.text.length() && d < d2) {
                    if (n > lineBreakMeasurer.getPosition()) {
                        textLayout = lineBreakMeasurer.nextLayout((float)d13, n, false);
                        n = activeBoxContent.text.indexOf(10, lineBreakMeasurer.getPosition());
                    } else {
                        textLayout = lineBreakMeasurer.nextLayout((float)d13);
                    }
                    if (textLayout == null) break;
                    double d16 = textLayout.getVisibleAdvance();
                    if (d16 > d14) {
                        d14 = d16;
                    }
                    d15 = textLayout.getLeading();
                    d += (double)(textLayout.getAscent() + textLayout.getDescent()) + d15;
                    ++n4;
                }
                if ((d -= d15) <= d2 && n4 <= n3 || !boxBase.reduceFont()) break;
                JComponent jComponent = this.getContainerResolve();
                if (jComponent == null) continue;
                RepaintManager.currentManager(jComponent).markCompletelyDirty(jComponent);
            }
            double d17 = d5 + (activeBoxContent.txtAlign[1] == 0 ? 0.0 : (activeBoxContent.txtAlign[1] == 2 ? d2 - d : (d2 - d) / 2.0));
            graphics2D.setColor(this.isInverted() ? boxBase.backColor : (this.isAlternative() ? boxBase.alternativeColor : boxBase.textColor));
            lineBreakMeasurer.setPosition(0);
            n = activeBoxContent.text.indexOf(10);
            d = 0.0;
            while (lineBreakMeasurer.getPosition() < activeBoxContent.text.length() && d < d2) {
                if (n > lineBreakMeasurer.getPosition()) {
                    textLayout = lineBreakMeasurer.nextLayout((float)d13, n, false);
                    n = activeBoxContent.text.indexOf(10, lineBreakMeasurer.getPosition());
                } else {
                    textLayout = lineBreakMeasurer.nextLayout((float)d13);
                }
                if (textLayout == null) break;
                double d18 = textLayout.getVisibleAdvance();
                double d19 = d3 + (double)boxBase.textMargin + (activeBoxContent.txtAlign[0] == 0 ? 0.0 : (activeBoxContent.txtAlign[0] == 2 ? d13 - d18 : (d13 - d18) / 2.0));
                if (!textLayout.isLeftToRight()) {
                    d19 -= d18;
                }
                d += (double)textLayout.getAscent();
                if (boxBase.shadow) {
                    graphics2D.setColor(boxBase.shadowColor);
                    textLayout.draw(graphics2D, (float)(d19 + (double)(boxBase.getDynFontSize() / 10.0f)), (float)(d17 + d + (double)(boxBase.getDynFontSize() / 10.0f)));
                    graphics2D.setColor(this.isInverted() ? boxBase.backColor : (this.isAlternative() ? boxBase.alternativeColor : boxBase.textColor));
                }
                textLayout.draw(graphics2D, (float)d19, (float)(d17 + d));
                d += (double)(textLayout.getDescent() + textLayout.getLeading());
            }
        }
        return true;
    }

    public boolean playMedia(PlayStation playStation) {
        ActiveBoxContent activeBoxContent = this.getCurrentContent();
        if (activeBoxContent != null) {
            if (activeBoxContent.animated) {
                Utils.refreshAnimatedImage(activeBoxContent.img);
                this.repaint();
            }
            if (activeBoxContent.mediaContent != null) {
                playStation.playMedia(activeBoxContent.mediaContent, this);
                return true;
            }
        }
        return false;
    }

    public String getDescription() {
        return this.content == null ? "" : this.content.getDescription();
    }

    public void setBounds(Rectangle2D rectangle2D) {
        super.setBounds(rectangle2D);
        if (this.hostedMediaPlayer != null) {
            this.hostedMediaPlayer.checkVisualComponentBounds(this);
        }
    }

    public void end() {
        this.clear();
        super.end();
    }

    public static void checkOptions(Options options) {
        if (!options.getBoolean("java14") && options.getBoolean("Mac")) {
            USE_TRANSFORM = true;
        }
    }
}

