/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.jclic.bags.ActivitySequenceElement;
import edu.xtec.jclic.bags.ActivitySequenceJump;
import edu.xtec.jclic.bags.JumpInfo;
import edu.xtec.jclic.edit.Editable;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.jclic.report.Reporter;
import edu.xtec.jclic.report.SequenceReg;
import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.jdom.Content;
import org.jdom.Element;

public class ActivitySequence
implements Editable,
Domable {
    private int currentAct;
    private Vector elements;
    protected JClicProject project;
    public static final String ELEMENT_NAME = "sequence";

    public ActivitySequence(JClicProject jClicProject) {
        this.project = jClicProject;
        this.elements = new Vector(20);
        this.currentAct = -1;
    }

    public Editor getEditor(Editor editor) {
        return Editor.createEditor(this.getClass().getName() + "Editor", this, editor);
    }

    public JClicProject getProject() {
        return this.project;
    }

    public void add(ActivitySequenceElement activitySequenceElement) {
        this.elements.add(activitySequenceElement);
        if (this.elements.size() == 1) {
            this.currentAct = 0;
            if (activitySequenceElement.getTag() == null) {
                activitySequenceElement.setTag("start");
            }
        }
    }

    public void insertElementAt(ActivitySequenceElement activitySequenceElement, int n) {
        this.elements.insertElementAt(activitySequenceElement, n);
    }

    public void remove(ActivitySequenceElement activitySequenceElement) {
        if (this.elements.contains(activitySequenceElement)) {
            if (this.elements.indexOf(activitySequenceElement) == this.currentAct) {
                this.currentAct = -1;
            }
            this.elements.remove(activitySequenceElement);
        }
    }

    public int getSize() {
        return this.elements.size();
    }

    public Element getJDomElement() {
        Element element = new Element(ELEMENT_NAME);
        int n = 0;
        while (n < this.elements.size()) {
            element.addContent((Content)this.getElement(n, false).getJDomElement());
            ++n;
        }
        return element;
    }

    public void setProperties(Element element, Object object) throws Exception {
        JDomUtility.checkName((Element)element, (String)ELEMENT_NAME);
        Iterator iterator = element.getChildren("item").iterator();
        while (iterator.hasNext()) {
            this.add(ActivitySequenceElement.getActivitySequenceElement((Element)iterator.next()));
        }
    }

    public void clear() {
        this.currentAct = -1;
        this.elements.clear();
    }

    public int getElementIndex(ActivitySequenceElement activitySequenceElement) {
        return activitySequenceElement == null ? -1 : this.elements.indexOf(activitySequenceElement);
    }

    public boolean checkAllElements() throws Exception {
        boolean bl = true;
        int n = 0;
        while (n < this.elements.size()) {
            if (this.project.activityBag.getElement(this.getElement(n, false).getActivityName()) == null) {
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    public ActivitySequenceElement getElement(int n, boolean bl) {
        ActivitySequenceElement activitySequenceElement = null;
        try {
            activitySequenceElement = (ActivitySequenceElement)this.elements.get(n);
        }
        catch (Exception exception) {
            activitySequenceElement = null;
        }
        if (activitySequenceElement != null && bl) {
            this.currentAct = n;
        }
        return activitySequenceElement;
    }

    public ActivitySequenceElement getElementByTag(String string, boolean bl) {
        int n = this.elements.size();
        if (n < 1 || string == null) {
            return null;
        }
        String string2 = FileSystem.stdFn(string);
        ActivitySequenceElement activitySequenceElement = null;
        int n2 = 0;
        while (n2 < n) {
            activitySequenceElement = this.getElement(n2, false);
            if (activitySequenceElement != null && activitySequenceElement.getTag() != null && activitySequenceElement.getTag().equals(string2)) break;
            ++n2;
        }
        if (n2 == n) {
            activitySequenceElement = null;
        } else if (bl) {
            this.currentAct = n2;
        }
        return activitySequenceElement;
    }

    public ActivitySequenceElement[] getElements() {
        Object[] objectArray = new ActivitySequenceElement[this.elements.size()];
        this.elements.copyInto(objectArray);
        return objectArray;
    }

    public boolean hasNextAct(boolean bl) {
        boolean bl2 = false;
        ActivitySequenceElement activitySequenceElement = this.getCurrentAct();
        if (activitySequenceElement != null) {
            if (activitySequenceElement.fwdJump == null) {
                bl2 = true;
            } else {
                switch (activitySequenceElement.fwdJump.action) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        bl2 = bl;
                        break;
                    }
                    default: {
                        bl2 = true;
                    }
                }
            }
        }
        return bl2;
    }

    public boolean hasPrevAct(boolean bl) {
        boolean bl2 = false;
        ActivitySequenceElement activitySequenceElement = this.getCurrentAct();
        if (activitySequenceElement != null) {
            if (activitySequenceElement.backJump == null) {
                bl2 = true;
            } else {
                switch (activitySequenceElement.backJump.action) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        bl2 = bl;
                        break;
                    }
                    default: {
                        bl2 = true;
                    }
                }
            }
        }
        return bl2;
    }

    public int getNavButtonsFlag() {
        int n = 0;
        ActivitySequenceElement activitySequenceElement = this.getCurrentAct();
        if (activitySequenceElement != null) {
            n = activitySequenceElement.navButtons;
        }
        return n;
    }

    public JumpInfo getJump(boolean bl, Reporter reporter) {
        JumpInfo jumpInfo = null;
        ActivitySequenceElement activitySequenceElement = this.getCurrentAct();
        if (activitySequenceElement != null) {
            ActivitySequenceJump activitySequenceJump;
            ActivitySequenceJump activitySequenceJump2 = activitySequenceJump = bl ? activitySequenceElement.backJump : activitySequenceElement.fwdJump;
            if (activitySequenceJump == null) {
                int n = this.currentAct + (bl ? -1 : 1);
                if (n >= this.elements.size() || n < 0) {
                    n = 0;
                }
                jumpInfo = new JumpInfo(0, n);
            } else {
                SequenceReg.Info info;
                int n = -1;
                int n2 = -1;
                if (reporter != null && (info = reporter.getCurrentSequenceInfo()) != null) {
                    n = (int)info.tScore;
                    n2 = (int)(info.tTime / 1000L);
                }
                jumpInfo = activitySequenceJump.resolveJump(n, n2);
            }
        }
        return jumpInfo;
    }

    public ActivitySequenceElement getCurrentAct() {
        return this.getElement(this.currentAct, false);
    }

    public int getCurrentActNum() {
        return this.currentAct;
    }

    public String getSequenceForElement(int n) {
        String string = null;
        if (n >= 0 && n < this.elements.size()) {
            int n2 = n;
            while (n2 >= 0) {
                string = this.getElement(n2, false).getTag();
                if (string != null) break;
                --n2;
            }
        }
        return string;
    }

    public ActivitySequenceElement getElementByActivityName(String string) {
        ActivitySequenceElement activitySequenceElement = null;
        if (string != null) {
            int n = 0;
            while (n < this.elements.size()) {
                ActivitySequenceElement activitySequenceElement2 = this.getElement(n, false);
                if (activitySequenceElement2.getActivityName().equalsIgnoreCase(string)) {
                    activitySequenceElement = activitySequenceElement2;
                    break;
                }
                ++n;
            }
        }
        return activitySequenceElement;
    }

    public boolean checkCurrentActivity(String string) {
        ActivitySequenceElement activitySequenceElement = this.getCurrentAct();
        if (activitySequenceElement == null || !activitySequenceElement.getActivityName().equalsIgnoreCase(string)) {
            int n = 0;
            while (n < this.elements.size()) {
                if (this.getElement(n, false).getActivityName().equalsIgnoreCase(string)) {
                    this.currentAct = n;
                    return false;
                }
                ++n;
            }
            activitySequenceElement = new ActivitySequenceElement(string, 0, 3);
            activitySequenceElement.fwdJump = new ActivitySequenceJump(1);
            activitySequenceElement.backJump = new ActivitySequenceJump(1);
            this.elements.add(activitySequenceElement);
            this.currentAct = this.elements.size() - 1;
            return false;
        }
        return true;
    }

    public void listReferences(String string, HashMap hashMap) {
        int n = 0;
        while (n < this.elements.size()) {
            this.getElement(n, false).listReferences(string, hashMap);
            ++n;
        }
    }
}

