/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled.convert;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import org.tritonus.share.TCircularBuffer;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.convert.TAudioInputStream;

public abstract class TAsynchronousFilteredAudioInputStream
extends TAudioInputStream
implements TCircularBuffer.Trigger {
    private static final int DEFAULT_BUFFER_SIZE = 327670;
    private static final int DEFAULT_MIN_AVAILABLE = 4096;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private TCircularBuffer m_circularBuffer;
    private int m_nMinAvailable;
    private byte[] m_abSingleByte;

    public TAsynchronousFilteredAudioInputStream(AudioFormat audioFormat, long l) {
        this(audioFormat, l, 327670, 4096);
    }

    public TAsynchronousFilteredAudioInputStream(AudioFormat audioFormat, long l, int n, int n2) {
        super(new ByteArrayInputStream(EMPTY_BYTE_ARRAY), audioFormat, l);
        if (TDebug.TraceAudioConverter) {
            TDebug.out("TAsynchronousFilteredAudioInputStream.<init>(): begin");
        }
        this.m_circularBuffer = new TCircularBuffer(n, false, true, this);
        this.m_nMinAvailable = n2;
        if (TDebug.TraceAudioConverter) {
            TDebug.out("TAsynchronousFilteredAudioInputStream.<init>(): end");
        }
    }

    protected TCircularBuffer getCircularBuffer() {
        return this.m_circularBuffer;
    }

    protected boolean writeMore() {
        return this.getCircularBuffer().availableWrite() > this.m_nMinAvailable;
    }

    public int read() throws IOException {
        int n;
        int n2 = -1;
        if (this.m_abSingleByte == null) {
            this.m_abSingleByte = new byte[1];
        }
        n2 = (n = this.read(this.m_abSingleByte)) == -1 ? -1 : this.m_abSingleByte[0] & 0xFF;
        return n2;
    }

    public int read(byte[] byArray) throws IOException {
        if (TDebug.TraceAudioConverter) {
            TDebug.out("TAsynchronousFilteredAudioInputStream.read(byte[]): begin");
        }
        int n = this.read(byArray, 0, byArray.length);
        if (TDebug.TraceAudioConverter) {
            TDebug.out("TAsynchronousFilteredAudioInputStream.read(byte[]): end");
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (TDebug.TraceAudioConverter) {
            TDebug.out("TAsynchronousFilteredAudioInputStream.read(byte[], int, int): begin");
        }
        int n3 = this.m_circularBuffer.read(byArray, n, n2);
        if (TDebug.TraceAudioConverter) {
            TDebug.out("TAsynchronousFilteredAudioInputStream.read(byte[], int, int): end");
        }
        return n3;
    }

    public long skip(long l) throws IOException {
        long l2 = 0L;
        while (l2 < l) {
            int n = this.read();
            if (n == -1) {
                return l2;
            }
            ++l2;
        }
        return l;
    }

    public int available() throws IOException {
        return this.m_circularBuffer.availableRead();
    }

    public void close() throws IOException {
        this.m_circularBuffer.close();
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int n) {
    }

    public void reset() throws IOException {
        throw new IOException("mark not supported");
    }

    public abstract void execute();
}

