/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.controller.Controller;
import freemind.controller.NodeKeyListener;
import freemind.controller.NodeMouseMotionListener;
import freemind.main.Tools;
import freemind.modes.MindMap;
import freemind.modes.MindMapArrowLink;
import freemind.modes.MindMapLink;
import freemind.modes.MindMapNode;
import freemind.view.mindmapview.ArrowLinkView;
import freemind.view.mindmapview.CloudView;
import freemind.view.mindmapview.MindMapLayout;
import freemind.view.mindmapview.NodeView;
import freemind.view.mindmapview.RootNodeView;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;

public class MapView
extends JPanel
implements Printable {
    private MindMap model;
    private NodeView rootView;
    private Vector selected = new Vector();
    private Controller controller;
    private float zoom = 1.0f;
    private boolean disableMoveCursor = true;
    private int siblingMaxLevel;
    private boolean isPrinting = false;
    private NodeView shiftSelectionOrigin = null;
    private int maxNodeWidth = 0;
    private Vector ArrowLinkViews;

    public MapView(MindMap model, Controller controller) {
        this.model = model;
        this.controller = controller;
        this.setAutoscrolls(true);
        this.getModel().addTreeModelListener(new MapModelHandler());
        this.setLayout(new MindMapLayout(this));
        this.initRoot();
        this.setBackground(this.getModel().getBackgroundColor());
        this.addMouseListener(controller.getMapMouseMotionListener());
        this.addMouseMotionListener(controller.getMapMouseMotionListener());
        this.addMouseWheelListener(controller.getMapMouseWheelListener());
        this.disableMoveCursor = Tools.safeEquals(controller.getProperty("disable_cursor_move_paper"), "true");
    }

    public void initRoot() {
        this.rootView = NodeView.newNodeView((MindMapNode)this.getModel().getRoot(), this);
        this.rootView.insert();
        this.getMindMapLayout().updateTreeHeightsAndRelativeYOfWholeMap();
        this.revalidate();
    }

    public int getMaxNodeWidth() {
        if (this.maxNodeWidth == 0) {
            try {
                this.maxNodeWidth = Integer.parseInt(this.controller.getProperty("max_node_width"));
            }
            catch (NumberFormatException e) {
                this.maxNodeWidth = Integer.parseInt(this.controller.getProperty("el__max_default_window_width"));
            }
        }
        return this.maxNodeWidth;
    }

    public void centerNode(NodeView node) {
        JViewport viewPort = (JViewport)this.getParent();
        Dimension d = viewPort.getExtentSize();
        this.scrollRectToVisible(new Rectangle(node.getLocation().x + node.getPreferredSize().width / 2 - d.width / 2, node.getLocation().y + node.getPreferredSize().height / 2 - d.height / 2, d.width, d.height));
        this.scrollRectToVisible(new Rectangle(node.getLocation().x + node.getPreferredSize().width / 2 - d.width / 2, node.getLocation().y + node.getPreferredSize().height / 2 - d.height / 2, d.width, d.height));
    }

    public void scrollNodeToVisible(NodeView node) {
        this.scrollNodeToVisible(node, 0);
    }

    public void scrollNodeToVisible(NodeView node, int extraWidth) {
        int HORIZ_SPACE = 10;
        int HORIZ_SPACE2 = 20;
        int VERT_SPACE = 5;
        int VERT_SPACE2 = 10;
        int xLeft = node.getLocation().x - 10;
        int xRight = node.getSize().width + 20;
        if (extraWidth < 0) {
            xLeft += extraWidth;
        } else {
            xRight += extraWidth;
        }
        if (xLeft < 0) {
            this.getMindMapLayout().resizeMap(xLeft);
        } else if (xRight > this.getSize().width) {
            this.getMindMapLayout().resizeMap(xRight);
        }
        if (node != null) {
            this.scrollRectToVisible(new Rectangle(xLeft, node.getLocation().y - 5, xRight, node.getSize().height + 10));
        }
    }

    public void scrollBy(int x, int y) {
        JViewport mapViewport = (JViewport)this.getParent();
        Point currentPoint = mapViewport.getViewPosition();
        currentPoint.translate(x, y);
        if (currentPoint.getX() < 0.0) {
            currentPoint.setLocation(0.0, currentPoint.getY());
        }
        if (currentPoint.getY() < 0.0) {
            currentPoint.setLocation(currentPoint.getX(), 0.0);
        }
        double maxX = this.getSize().getWidth() - mapViewport.getExtentSize().getWidth();
        double maxY = this.getSize().getHeight() - mapViewport.getExtentSize().getHeight();
        if (currentPoint.getX() > maxX) {
            currentPoint.setLocation(maxX, currentPoint.getY());
        }
        if (currentPoint.getY() > maxY) {
            currentPoint.setLocation(currentPoint.getX(), maxY);
        }
        mapViewport.setViewPosition(currentPoint);
    }

    private NodeView getNeighbour(int directionCode) {
        NodeView oldSelected = this.getSelected();
        NodeView newSelected = null;
        switch (directionCode) {
            case 37: {
                this.setSiblingMaxLevel(oldSelected.getModel().getNodeLevel());
                if (oldSelected.isRoot()) {
                    LinkedList left = ((RootNodeView)oldSelected).getLeft();
                    if (left.size() == 0) {
                        return null;
                    }
                    newSelected = oldSelected.getModel().getPreferredChild().getViewer();
                    if (!left.contains(newSelected)) {
                        newSelected = (NodeView)left.getFirst();
                    }
                } else if (!oldSelected.isLeft()) {
                    newSelected = oldSelected.getParentView();
                } else {
                    if (oldSelected.getModel().isFolded()) {
                        this.getModel().setFolded(oldSelected.getModel(), false);
                        return null;
                    }
                    if (oldSelected.getChildrenViews().size() == 0) {
                        return null;
                    }
                    newSelected = oldSelected.getModel().getPreferredChild().getViewer();
                }
                this.setSiblingMaxLevel(newSelected.getModel().getNodeLevel());
                break;
            }
            case 39: {
                this.setSiblingMaxLevel(oldSelected.getModel().getNodeLevel());
                if (oldSelected.isRoot()) {
                    LinkedList right = ((RootNodeView)oldSelected).getRight();
                    if (right.size() == 0) {
                        return null;
                    }
                    newSelected = oldSelected.getModel().getPreferredChild().getViewer();
                    if (!right.contains(newSelected)) {
                        newSelected = (NodeView)right.getFirst();
                    }
                } else if (oldSelected.isLeft()) {
                    newSelected = oldSelected.getParentView();
                } else {
                    if (oldSelected.getModel().isFolded()) {
                        this.getModel().setFolded(oldSelected.getModel(), false);
                        return null;
                    }
                    if (oldSelected.getChildrenViews().size() == 0) {
                        return null;
                    }
                    newSelected = oldSelected.getModel().getPreferredChild().getViewer();
                }
                this.setSiblingMaxLevel(newSelected.getModel().getNodeLevel());
                break;
            }
            case 38: {
                newSelected = oldSelected.getPreviousSibling();
                break;
            }
            case 40: {
                newSelected = oldSelected.getNextSibling();
                break;
            }
            case 33: {
                newSelected = oldSelected.getPreviousPage();
                break;
            }
            case 34: {
                newSelected = oldSelected.getNextPage();
            }
        }
        return newSelected;
    }

    public void move(KeyEvent e) {
        NodeView newSelected = this.getNeighbour(e.getKeyCode());
        if (newSelected != null) {
            this.extendSelectionWithKeyMove(newSelected, e);
            this.scrollNodeToVisible(newSelected);
            e.consume();
        }
    }

    private void extendSelectionWithKeyMove(NodeView newlySelectedNodeView, KeyEvent e) {
        if (e.isShiftDown()) {
            boolean enlargingMove;
            if (e.getKeyCode() == 37 || e.getKeyCode() == 39) {
                this.shiftSelectionOrigin = null;
                NodeView toBeNewSelected = newlySelectedNodeView.isParentOf(this.getSelected()) ? newlySelectedNodeView : this.getSelected();
                this.selectBranch(toBeNewSelected, false);
                this.makeTheSelected(toBeNewSelected);
                return;
            }
            if (this.shiftSelectionOrigin == null) {
                this.shiftSelectionOrigin = this.getSelected();
            }
            int deltaY = newlySelectedNodeView.getY() - this.shiftSelectionOrigin.getY();
            NodeView currentSelected = this.getSelected();
            if (e.getKeyCode() == 33) {
                while (true) {
                    if (currentSelected.getY() > this.shiftSelectionOrigin.getY()) {
                        this.deselect(currentSelected);
                    } else {
                        this.makeTheSelected(currentSelected);
                    }
                    if (currentSelected.getY() <= newlySelectedNodeView.getY()) break;
                    currentSelected = currentSelected.getPreviousSibling();
                }
                return;
            }
            if (e.getKeyCode() == 34) {
                while (true) {
                    if (currentSelected.getY() < this.shiftSelectionOrigin.getY()) {
                        this.deselect(currentSelected);
                    } else {
                        this.makeTheSelected(currentSelected);
                    }
                    if (currentSelected.getY() >= newlySelectedNodeView.getY()) break;
                    currentSelected = currentSelected.getNextSibling();
                }
                return;
            }
            boolean bl = enlargingMove = deltaY > 0 && e.getKeyCode() == 40 || deltaY < 0 && e.getKeyCode() == 38;
            if (enlargingMove) {
                this.toggleSelected(newlySelectedNodeView);
            } else {
                this.toggleSelected(this.getSelected());
                this.makeTheSelected(newlySelectedNodeView);
            }
        } else {
            this.shiftSelectionOrigin = null;
            this.selectAsTheOnlyOneSelected(newlySelectedNodeView);
        }
    }

    public void moveToRoot() {
        this.selectAsTheOnlyOneSelected(this.getRoot());
        this.centerNode(this.getRoot());
    }

    public void selectAsTheOnlyOneSelected(NodeView newSelected) {
        LinkedList oldSelecteds = this.getSelecteds();
        this.selected.clear();
        this.selected.add(0, newSelected);
        newSelected.requestFocus();
        if (newSelected.getModel().getParentNode() != null) {
            newSelected.getModel().getParentNode().setPreferredChild(newSelected.getModel());
        }
        newSelected.repaint();
        ListIterator e = oldSelecteds.listIterator();
        while (e.hasNext()) {
            NodeView oldSelected = (NodeView)e.next();
            oldSelected.repaint();
        }
    }

    public void toggleSelected(NodeView newSelected) {
        NodeView oldSelected = this.getSelected();
        if (this.isSelected(newSelected)) {
            if (this.selected.size() > 1) {
                this.selected.remove(newSelected);
                oldSelected = newSelected;
            }
        } else {
            this.selected.add(0, newSelected);
        }
        this.getSelected().requestFocus();
        this.getSelected().repaint();
        if (oldSelected != null) {
            oldSelected.repaint();
        }
    }

    public void makeTheSelected(NodeView newSelected) {
        if (this.isSelected(newSelected)) {
            this.selected.remove(newSelected);
        }
        this.selected.add(0, newSelected);
        this.getSelected().requestFocus();
        this.getSelected().repaint();
    }

    public void deselect(NodeView newSelected) {
        if (this.isSelected(newSelected)) {
            this.selected.remove(newSelected);
            newSelected.repaint();
        }
    }

    public void selectBranch(NodeView newlySelectedNodeView, boolean extend) {
        if (!extend) {
            this.selectAsTheOnlyOneSelected(newlySelectedNodeView);
        } else if (!this.isSelected(newlySelectedNodeView)) {
            this.toggleSelected(newlySelectedNodeView);
        }
        ListIterator e = newlySelectedNodeView.getChildrenViews().listIterator();
        while (e.hasNext()) {
            NodeView target = (NodeView)e.next();
            this.selectBranch(target, true);
        }
    }

    public boolean selectContinuous(NodeView newSelected) {
        NodeView nodeView;
        NodeView nodeView2;
        NodeView oldSelected = null;
        LinkedList selList = this.getSelecteds();
        ListIterator j = selList.listIterator();
        while (j.hasNext()) {
            NodeView selectedNode = (NodeView)j.next();
            if (selectedNode == newSelected || !newSelected.isSiblingOf(selectedNode)) continue;
            oldSelected = selectedNode;
            break;
        }
        if (oldSelected == null) {
            if (!this.isSelected(newSelected)) {
                this.toggleSelected(newSelected);
                return true;
            }
            return false;
        }
        boolean oldPositionLeft = oldSelected.isLeft();
        boolean newPositionLeft = newSelected.isLeft();
        ListIterator i = newSelected.getSiblingViews().listIterator();
        while (i.hasNext() && (nodeView2 = (NodeView)i.next()) != oldSelected) {
        }
        ListIterator i_backup = i;
        while (i.hasNext()) {
            nodeView = (NodeView)i.next();
            if (nodeView.isLeft() != oldPositionLeft && nodeView.isLeft() != newPositionLeft) continue;
            if (!this.isSelected(nodeView)) break;
            this.deselect(nodeView);
        }
        if ((i = i_backup).hasPrevious()) {
            i.previous();
            while (i.hasPrevious()) {
                nodeView = (NodeView)i.previous();
                if (nodeView.isLeft() != oldPositionLeft && nodeView.isLeft() != newPositionLeft) continue;
                if (!this.isSelected(nodeView)) break;
                this.deselect(nodeView);
            }
        }
        i = newSelected.getSiblingViews().listIterator();
        i = newSelected.getSiblingViews().listIterator();
        while (i.hasNext()) {
            nodeView = (NodeView)i.next();
            if (nodeView != newSelected && nodeView != oldSelected) continue;
            if (this.isSelected(nodeView)) break;
            this.toggleSelected(nodeView);
            break;
        }
        while (i.hasNext()) {
            nodeView = (NodeView)i.next();
            if (!(nodeView.isLeft() != oldPositionLeft && nodeView.isLeft() != newPositionLeft || this.isSelected(nodeView))) {
                this.toggleSelected(nodeView);
            }
            if (nodeView != newSelected && nodeView != oldSelected) continue;
            break;
        }
        this.toggleSelected(oldSelected);
        this.toggleSelected(oldSelected);
        return true;
    }

    public MindMap getModel() {
        return this.model;
    }

    public void setMoveCursor(boolean isHand) {
        int requiredCursor;
        int n = requiredCursor = isHand && !this.disableMoveCursor ? 13 : 0;
        if (this.getCursor().getType() != requiredCursor) {
            this.setCursor(new Cursor(requiredCursor));
        }
    }

    NodeMouseMotionListener getNodeMouseMotionListener() {
        return this.getController().getNodeMouseMotionListener();
    }

    NodeKeyListener getNodeKeyListener() {
        return this.getController().getNodeKeyListener();
    }

    DragGestureListener getNodeDragListener() {
        return this.getController().getNodeDragListener();
    }

    DropTargetListener getNodeDropListener() {
        return this.getController().getNodeDropListener();
    }

    public NodeView getSelected() {
        if (this.selected.size() > 0) {
            return (NodeView)this.selected.get(0);
        }
        return null;
    }

    private NodeView getSelected(int i) {
        return (NodeView)this.selected.get(i);
    }

    public LinkedList getSelecteds() {
        LinkedList<NodeView> result = new LinkedList<NodeView>();
        for (int i = 0; i < this.selected.size(); ++i) {
            result.add(this.getSelected(i));
        }
        return result;
    }

    public LinkedList getSelectedsByDepth() {
        LinkedList result = this.getSelecteds();
        Collections.sort(result, new nodesDepthComparator());
        return result;
    }

    public ArrayList getSelectedsSortedByY() {
        TreeMap<Integer, NodeView> sortedNodes = new TreeMap<Integer, NodeView>();
        for (int i = 0; i < this.selected.size(); ++i) {
            sortedNodes.put(new Integer(this.getSelected(i).getY()), this.getSelected(i));
        }
        ArrayList selectedNodes = new ArrayList();
        Iterator it = sortedNodes.entrySet().iterator();
        while (it.hasNext()) {
            selectedNodes.add(it.next().getValue());
        }
        return selectedNodes;
    }

    public ArrayList getSelectedNodesSortedByY() {
        TreeMap<Integer, MindMapNode> sortedNodes = new TreeMap<Integer, MindMapNode>();
        for (int i = 0; i < this.selected.size(); ++i) {
            sortedNodes.put(new Integer(this.getSelected(i).getY()), this.getSelected(i).getModel());
        }
        ArrayList selectedNodes = new ArrayList();
        Iterator it = sortedNodes.entrySet().iterator();
        while (it.hasNext()) {
            selectedNodes.add(it.next().getValue());
        }
        return selectedNodes;
    }

    public boolean isSelected(NodeView n) {
        if (this.isPrinting) {
            return false;
        }
        return this.selected.contains(n);
    }

    public float getZoom() {
        return this.zoom;
    }

    public int getZoomed(int number) {
        return (int)((float)number * this.zoom);
    }

    public void setZoom(float zoom) {
        this.zoom = zoom;
        this.getRoot().updateAll();
        this.getMindMapLayout().updateTreeHeightsAndRelativeYOfWholeMap();
        this.getMindMapLayout().layout();
        this.repaint();
    }

    public void paintChildren(Graphics graphics) {
        this.paintClouds(this.rootView, graphics, 0);
        HashMap labels = new HashMap();
        this.ArrowLinkViews = new Vector();
        this.collectLabels(this.rootView, labels);
        this.paintLinks(this.rootView, (Graphics2D)graphics, labels, null);
        super.paintChildren(graphics);
        this.paintEdges(this.rootView, (Graphics2D)graphics);
    }

    protected void paintClouds(NodeView source, Graphics graphics, int iterativeLevel) {
        ListIterator e = source.getChildrenViews().listIterator();
        while (e.hasNext()) {
            NodeView target = (NodeView)e.next();
            if (target.getModel().getCloud() != null) {
                CloudView cloud = new CloudView(target.getModel().getCloud(), target, iterativeLevel);
                cloud.paint(graphics);
                this.paintClouds(target, graphics, iterativeLevel + 1);
                continue;
            }
            this.paintClouds(target, graphics, iterativeLevel);
        }
    }

    protected void collectLabels(NodeView source, HashMap labels) {
        if (this.getModel().getLinkRegistry() == null) {
            return;
        }
        String label = this.getModel().getLinkRegistry().getLabel(source.getModel());
        if (label != null) {
            labels.put(label, source);
        }
        ListIterator e = source.getChildrenViews().listIterator();
        while (e.hasNext()) {
            NodeView target = (NodeView)e.next();
            this.collectLabels(target, labels);
        }
    }

    protected void paintLinks(NodeView source, Graphics2D graphics, HashMap labels, HashSet LinkAlreadyVisited) {
        if (this.getModel().getLinkRegistry() == null) {
            return;
        }
        if (LinkAlreadyVisited == null) {
            LinkAlreadyVisited = new HashSet<MindMapLink>();
        }
        Vector vec = this.getModel().getLinkRegistry().getAllLinks(source.getModel());
        for (int i = 0; i < vec.size(); ++i) {
            MindMapLink ref = (MindMapLink)vec.get(i);
            if (!LinkAlreadyVisited.add(ref) || !(ref instanceof MindMapArrowLink)) continue;
            ArrowLinkView arrowLink = new ArrowLinkView((MindMapArrowLink)ref, ref.getSource().getViewer(), ref.getTarget().getViewer());
            arrowLink.paint(graphics);
            this.ArrowLinkViews.add(arrowLink);
            Rectangle rec = arrowLink.getBounds();
        }
        ListIterator e = source.getChildrenViews().listIterator();
        while (e.hasNext()) {
            NodeView target = (NodeView)e.next();
            this.paintLinks(target, graphics, labels, LinkAlreadyVisited);
        }
    }

    public MindMapArrowLink detectCollision(Point p) {
        for (int i = 0; i < this.ArrowLinkViews.size(); ++i) {
            ArrowLinkView arrowView = (ArrowLinkView)this.ArrowLinkViews.get(i);
            if (!arrowView.detectCollision(p)) continue;
            return arrowView.getModel();
        }
        return null;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        boolean fitToPage = Tools.safeEquals(this.controller.getProperty("fit_to_page"), "true");
        double userZoomFactor = 1.0;
        try {
            userZoomFactor = Double.parseDouble(this.controller.getProperty("user_zoom"));
        }
        catch (Exception e) {
            // empty catch block
        }
        userZoomFactor = Math.max(0.0, userZoomFactor);
        userZoomFactor = Math.min(2.0, userZoomFactor);
        if (fitToPage && pageIndex > 0) {
            return 1;
        }
        this.isPrinting = true;
        this.setZoom(this.getZoom());
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color background = this.getBackground();
        this.setBackground(Color.white);
        Rectangle boundingRectangle = this.getInnerBounds(this.rootView);
        double zoomFactor = 1.0;
        if (fitToPage) {
            double zoomFactorX = pageFormat.getImageableWidth() / boundingRectangle.getWidth();
            double zoomFactorY = pageFormat.getImageableHeight() / boundingRectangle.getHeight();
            zoomFactor = Math.min(zoomFactorX, zoomFactorY);
        } else {
            int nrPagesInHeight;
            zoomFactor = userZoomFactor;
            int nrPagesInWidth = (int)Math.ceil(zoomFactor * boundingRectangle.getWidth() / pageFormat.getImageableWidth());
            if (pageIndex >= nrPagesInWidth * (nrPagesInHeight = (int)Math.ceil(zoomFactor * boundingRectangle.getHeight() / pageFormat.getImageableHeight()))) {
                return 1;
            }
            int yPageCoord = (int)Math.floor(pageIndex / nrPagesInWidth);
            int xPageCoord = pageIndex - yPageCoord * nrPagesInWidth;
            graphics2D.translate(-pageFormat.getImageableWidth() * (double)xPageCoord, -pageFormat.getImageableHeight() * (double)yPageCoord);
        }
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        graphics2D.scale(zoomFactor, zoomFactor);
        graphics2D.translate(-boundingRectangle.getX(), -boundingRectangle.getY());
        this.print(graphics2D);
        this.setBackground(background);
        this.isPrinting = false;
        this.setZoom(this.getZoom());
        return 0;
    }

    public boolean isPrinting() {
        return this.isPrinting;
    }

    public Dimension getPreferredSize() {
        return this.getLayout().preferredLayoutSize(this);
    }

    private Rectangle getInnerBounds(NodeView source) {
        Rectangle r = source.getBounds();
        ListIterator e = source.getChildrenViews().listIterator();
        while (e.hasNext()) {
            NodeView target = (NodeView)e.next();
            r.add(this.getInnerBounds(target));
        }
        return r;
    }

    private void paintEdges(NodeView source, Graphics2D g) {
        ListIterator e = source.getChildrenViews().listIterator();
        while (e.hasNext()) {
            NodeView target = (NodeView)e.next();
            target.getEdge().paint(g);
            this.paintEdges(target, g);
        }
    }

    protected NodeView getRoot() {
        return this.rootView;
    }

    private MindMapLayout getMindMapLayout() {
        return (MindMapLayout)this.getLayout();
    }

    private MapView getMap() {
        return this;
    }

    public Controller getController() {
        return this.controller;
    }

    public int getSiblingMaxLevel() {
        return this.siblingMaxLevel;
    }

    public void setSiblingMaxLevel(int level) {
        this.siblingMaxLevel = level;
    }

    private class MapModelHandler
    implements TreeModelListener {
        private MapModelHandler() {
        }

        public void treeNodesChanged(TreeModelEvent e) {
            NodeView node;
            MapView.this.setBackground(MapView.this.getModel().getBackgroundColor());
            try {
                node = ((MindMapNode)e.getChildren()[0]).getViewer();
            }
            catch (Exception ex) {
                node = ((MindMapNode)e.getTreePath().getLastPathComponent()).getViewer();
            }
            node.update();
            MapView.this.getMindMapLayout().updateTreeHeightsAndRelativeYOfDescendantsAndAncestors(node);
            MapView.this.getMindMapLayout().layout();
            MapView.this.repaint();
        }

        public void treeNodesInserted(TreeModelEvent e) {
            MindMapNode parent = (MindMapNode)e.getTreePath().getLastPathComponent();
            NodeView parentView = parent.getViewer();
            MindMapNode child = (MindMapNode)e.getChildren()[0];
            if (child != null) {
                parentView.insert(child);
                MapView.this.getMindMapLayout().updateTreeHeightFromChildren(child.getViewer());
            }
            MapView.this.getMindMapLayout().updateTreeHeightsAndRelativeYOfAncestors(parentView);
            MapView.this.getMindMapLayout().layout();
            parentView.requestFocus();
            MapView.this.repaint();
        }

        public void treeNodesRemoved(TreeModelEvent e) {
            NodeView node = ((MindMapNode)e.getChildren()[0]).getViewer();
            NodeView parent = ((MindMapNode)e.getTreePath().getLastPathComponent()).getViewer();
            if (node == null) {
                System.err.println("MapView.treeNodesRemoved tried to delete null as node.");
                return;
            }
            node.remove();
            MindMapNode preferred = parent.getModel().getPreferredChild();
            if (preferred != null) {
                MapView.this.selectAsTheOnlyOneSelected(preferred.getViewer());
            } else {
                MapView.this.selectAsTheOnlyOneSelected(parent);
            }
            MapView.this.getMindMapLayout().updateTreeHeightsAndRelativeYOfAncestors(parent);
            MapView.this.getMindMapLayout().layout();
            parent.requestFocus();
            MapView.this.repaint();
        }

        public void treeStructureChanged(TreeModelEvent e) {
            ArrayList<MindMapNode> selectedNodes = new ArrayList<MindMapNode>();
            ListIterator it = MapView.this.getSelecteds().listIterator();
            while (it.hasNext()) {
                selectedNodes.add(((NodeView)it.next()).getModel());
            }
            MindMapNode selectedNode = MapView.this.getSelected().getModel();
            MindMapNode subtreeRoot = (MindMapNode)e.getTreePath().getLastPathComponent();
            if (subtreeRoot.isRoot()) {
                subtreeRoot.getViewer().remove();
                MapView.this.rootView = NodeView.newNodeView(MapView.this.getRoot().getModel(), MapView.this.getMap());
                MapView.this.rootView.insert();
            } else {
                boolean nodeIsLeft = subtreeRoot.getViewer().isLeft();
                subtreeRoot.getViewer().remove();
                NodeView nodeView = NodeView.newNodeView(subtreeRoot, MapView.this.getMap());
                nodeView.setLeft(nodeIsLeft);
                nodeView.insert();
            }
            MapView.this.getMindMapLayout().updateTreeHeightsAndRelativeYOfDescendantsAndAncestors(subtreeRoot.getViewer());
            MapView.this.getMindMapLayout().layout();
            MapView.this.selected.clear();
            ListIterator it2 = selectedNodes.listIterator();
            while (it2.hasNext()) {
                MapView.this.selected.add(0, ((MindMapNode)it2.next()).getViewer());
            }
            selectedNode.getViewer().requestFocus();
            MapView.this.repaint();
        }
    }

    protected class nodesDepthComparator
    implements Comparator {
        public int compare(Object p1, Object p2) {
            Object[] path2;
            MindMapNode n1 = ((NodeView)p1).getModel();
            MindMapNode n2 = ((NodeView)p2).getModel();
            Object[] path1 = MapView.this.getModel().getPathToRoot(n1);
            int depth = path1.length - (path2 = MapView.this.getModel().getPathToRoot(n2)).length;
            if (depth > 0) {
                return -1;
            }
            if (depth < 0) {
                return 1;
            }
            return 0;
        }
    }
}

