/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.panels;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.activities.panels.MenuElement;
import edu.xtec.jclic.edit.Editable;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.media.MediaContent;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.util.StrUtils;
import edu.xtec.util.VFlowScrollPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Content;
import org.jdom.Element;

public class Menu
extends Activity
implements Editable {
    protected ArrayList menuElements;
    public static final int MAX_LABEL_LENGTH = 30;

    public Menu(JClicProject jClicProject) {
        super(jClicProject);
        this.includeInReports = false;
        this.reportActions = false;
        this.bActionsCounter = false;
        this.bScoreCounter = false;
        this.bTimeCounter = false;
        this.menuElements = new ArrayList();
    }

    public String getPublicName() {
        return this.description;
    }

    public Element getJDomElement() {
        Element element = super.getJDomElement();
        int n = 0;
        while (n < this.menuElements.size()) {
            element.addContent((Content)this.getMenuElement(n).getJDomElement());
            ++n;
        }
        return element;
    }

    public void setProperties(Element element, Object object) throws Exception {
        super.setProperties(element, object);
        this.includeInReports = false;
        Iterator iterator = element.getChildren("menuElement").iterator();
        while (iterator.hasNext()) {
            this.menuElements.add(MenuElement.getMenuElement((Element)iterator.next()));
        }
    }

    public int getMenuElementCount() {
        return this.menuElements.size();
    }

    public MenuElement getMenuElement(int n) {
        if (n < 0 || n >= this.menuElements.size()) {
            return null;
        }
        return (MenuElement)this.menuElements.get(n);
    }

    public void addMenuElement(MenuElement menuElement) {
        this.menuElements.add(menuElement);
    }

    public int getMinNumActions() {
        return 0;
    }

    public Editor getEditor(Editor editor) {
        return Editor.createEditor((String)(((Object)((Object)this)).getClass().getName() + "Editor"), (Object)((Object)this), (Editor)editor);
    }

    public Activity.Panel getActivityPanel(PlayStation playStation) {
        return new Panel(playStation);
    }

    class Panel
    extends Activity.Panel
    implements ActionListener {
        VFlowScrollPane scrollPane;
        JPanel panel;

        protected Panel(PlayStation playStation) {
            super((Activity)Menu.this, playStation);
        }

        public void buildVisualComponents() throws Exception {
            super.buildVisualComponents();
            this.panel = new JPanel();
            this.panel.setBackground(Menu.this.activityBgColor);
            this.panel.setLayout(new FlowLayout());
            this.scrollPane = new VFlowScrollPane(this.panel);
            this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.scrollPane.getVerticalScrollBar().setBorder(BorderFactory.createLineBorder(Color.darkGray, 1));
            this.addButtons();
            ((Container)((Object)this)).add((Component)this.scrollPane);
        }

        public void addButtons() {
            this.panel.removeAll();
            int n = 0;
            while (n < Menu.this.menuElements.size()) {
                MenuElement menuElement = Menu.this.getMenuElement(n);
                JButton jButton = new JButton();
                jButton.setIcon(menuElement.getIcon(((Menu)Menu.this).project.mediaBag));
                if (menuElement.caption != null) {
                    jButton.setText(StrUtils.getShortExpression((String)menuElement.caption, (int)30));
                }
                if (menuElement.description != null) {
                    jButton.setToolTipText(menuElement.description);
                } else if (menuElement.caption != null) {
                    jButton.setToolTipText(menuElement.caption);
                }
                jButton.setHorizontalTextPosition(0);
                jButton.setVerticalTextPosition(3);
                jButton.setActionCommand(Integer.toString(n));
                jButton.addActionListener(this);
                this.panel.add(jButton);
                ++n;
            }
        }

        public void doLayout() {
            this.scrollPane.setBounds(0, 0, ((JComponent)((Object)this)).getWidth(), ((JComponent)((Object)this)).getHeight());
        }

        public void clear() {
        }

        public Dimension setDimension(Dimension dimension) {
            return dimension;
        }

        public void initActivity() throws Exception {
            super.initActivity();
            if (!this.firstRun) {
                this.buildVisualComponents();
            }
            this.firstRun = false;
            this.setAndPlayMsg(1, 0);
            this.playing = true;
        }

        public void render(Graphics2D graphics2D, Rectangle rectangle) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MenuElement menuElement;
            int n = -1;
            try {
                n = Integer.parseInt(actionEvent.getActionCommand());
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            if (n >= 0 && (menuElement = Menu.this.getMenuElement(n)) != null && (menuElement.projectPath != null || menuElement.sequence != null)) {
                MediaContent mediaContent = new MediaContent();
                if ("@RETURN".equals(menuElement.sequence)) {
                    mediaContent.mediaType = 12;
                } else {
                    mediaContent.mediaType = 8;
                    mediaContent.mediaFileName = menuElement.sequence;
                    mediaContent.externalParam = menuElement.projectPath;
                }
                this.ps.playMedia(mediaContent, null);
            }
        }
    }
}

