/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.media;

import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.media.AudioPlayer;
import edu.xtec.jclic.media.QTTools;
import quicktime.app.players.QTPlayer;

public class QTAudioPlayer
implements AudioPlayer {
    QTPlayer player = null;

    public void play() {
        if (this.player != null) {
            this.stop();
            try {
                this.player.setTime(0);
                this.player.startTasking();
                this.player.setRate(1.0f);
            }
            catch (Exception exception) {
                System.err.println("QT Exception:\n" + exception);
            }
        }
    }

    public boolean setDataSource(Object object) throws Exception {
        this.close();
        this.player = QTTools.getPlayer(object);
        if (this.player != null) {
            this.player.setControllerVisible(false);
        }
        return this.player != null;
    }

    public void stop() {
        try {
            if (this.player != null) {
                this.player.setRate(0.0f);
                this.player.stopTasking();
            }
        }
        catch (Exception exception) {
            System.err.println("QT Error:\n" + exception);
        }
    }

    public void close() {
        if (this.player != null) {
            this.stop();
            try {
                this.player.getMovieController().getMovie().disposeQTObject();
                this.player.getMovieController().disposeQTObject();
            }
            catch (Exception exception) {
                System.err.println("QT Error:\n" + exception);
            }
            this.player = null;
        }
    }

    public void realize(String string, MediaBag mediaBag) throws Exception {
        if (string != null) {
            this.setDataSource(mediaBag.getMediaDataSource(string));
        }
    }
}

