/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.media;

import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.media.ActiveMediaPlayer;
import edu.xtec.jclic.media.AudioBuffer;
import edu.xtec.jclic.media.MediaContent;
import edu.xtec.jclic.media.QTAudioBuffer;
import edu.xtec.jclic.media.QTTools;
import java.awt.Component;
import quicktime.app.display.Drawable;
import quicktime.app.display.QTCanvas;
import quicktime.app.players.QTPlayer;
import quicktime.std.clocks.TimeRecord;

public class QTActiveMediaPlayer
extends ActiveMediaPlayer {
    QTPlayer player = null;
    QTCanvas canvas;
    boolean realized = false;

    public QTActiveMediaPlayer(MediaContent mediaContent, MediaBag mediaBag, PlayStation playStation) {
        super(mediaContent, mediaBag, playStation);
        if (!this.useAudioBuffer) {
            try {
                this.player = QTTools.getPlayer(mediaBag.getMediaDataSource(mediaContent.mediaFileName));
                if (this.player != null) {
                    this.player.setControllerVisible(false);
                    this.player.setControllerSizeReserved(false);
                }
            }
            catch (Exception exception) {
                System.err.println("Error reading media \"" + mediaContent.mediaFileName + "\":\n" + exception);
            }
        }
    }

    public AudioBuffer createAudioBuffer(int n) throws Exception {
        return new QTAudioBuffer(this.mc.length);
    }

    public void realize() {
        if (!this.useAudioBuffer) {
            try {
                if (this.player != null) {
                    this.attachVisualComponent();
                    this.player.startTasking();
                    this.player.getMovieController().getMovie().setTimeScale(1000);
                    this.setTimeRanges();
                    this.player.stopTasking();
                    this.realized = true;
                }
            }
            catch (Exception exception) {
                System.err.println("QuickTime exception:\n" + exception);
            }
        }
    }

    protected void playNow(ActiveBox activeBox) {
        if (this.useAudioBuffer) {
            super.playNow(activeBox);
        } else if (this.player != null) {
            try {
                this.stop();
                if (!this.realized) {
                    this.realize();
                }
                if (this.mc.mediaType == 2) {
                    this.linkTo(activeBox);
                }
                this.attachVisualComponent();
                this.player.startTasking();
                this.player.setTime(Math.max(this.mc.from, 0));
                this.player.setRate(1.0f);
            }
            catch (Exception exception) {
                System.err.println("QuickTime Exception:\n" + exception);
            }
        }
    }

    public void stop() {
        super.stop();
        if (!this.useAudioBuffer) {
            try {
                if (this.player != null) {
                    this.player.setRate(0.0f);
                    this.player.stopTasking();
                }
            }
            catch (Exception exception) {
                System.err.println("QuickTime Error:\n" + exception);
            }
        }
    }

    public void clear() {
        super.clear();
        if (!this.useAudioBuffer) {
            try {
                if (this.player != null) {
                    this.destroyVisualComponent();
                    this.realized = false;
                }
            }
            catch (Exception exception) {
                System.err.println("QuickTime Error:\n" + exception);
            }
        }
    }

    protected void setTimeRanges() {
        if (this.useAudioBuffer || this.player == null) {
            return;
        }
        try {
            if (this.mc.from >= 0 || this.mc.to >= 0) {
                int n = Math.max(0, this.mc.from);
                int n2 = this.mc.to;
                if (n2 < 0) {
                    n2 = this.player.getDuration();
                }
                this.player.setTime(Math.max(this.mc.from, 0));
                this.player.getMovieController().setSelectionBegin(new TimeRecord(1000, (long)n));
                this.player.getMovieController().setSelectionDuration(new TimeRecord(1000, (long)(n2 - n)));
                this.player.getMovieController().setPlaySelection(true);
            }
            if (this.mc.loop) {
                this.player.getMovieController().setLooping(true);
            }
        }
        catch (Exception exception) {
            System.err.println("QuickTime Error:\n" + exception);
        }
    }

    protected Component getVisualComponent() {
        if (this.player == null || this.mc.mediaType != 2) {
            return null;
        }
        if (this.canvas == null) {
            try {
                this.canvas = new QTCanvas();
                this.canvas.setClient((Drawable)this.player, false);
            }
            catch (Exception exception) {
                System.err.println("Error building QTCanvas!\n" + exception);
            }
        }
        return this.canvas;
    }
}

