/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share;

import org.tritonus.share.TDebug;

public class TCircularBuffer {
    private boolean m_bBlockingRead;
    private boolean m_bBlockingWrite;
    private byte[] m_abData;
    private int m_nSize;
    private int m_nReadPos;
    private int m_nWritePos;
    private Trigger m_trigger;
    private boolean m_bOpen;

    public TCircularBuffer(int n, boolean bl, boolean bl2, Trigger trigger) {
        this.m_bBlockingRead = bl;
        this.m_bBlockingWrite = bl2;
        this.m_nSize = n;
        this.m_abData = new byte[this.m_nSize];
        this.m_nReadPos = 0;
        this.m_nWritePos = 0;
        this.m_trigger = trigger;
        this.m_bOpen = true;
    }

    public void close() {
        this.m_bOpen = false;
    }

    private boolean isOpen() {
        return this.m_bOpen;
    }

    public int availableRead() {
        return this.m_nWritePos - this.m_nReadPos;
    }

    public int availableWrite() {
        return this.m_nSize - this.availableRead();
    }

    private int getReadPos() {
        return this.m_nReadPos % this.m_nSize;
    }

    private int getWritePos() {
        return this.m_nWritePos % this.m_nSize;
    }

    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    /*
     * Unable to fully structure code
     */
    public int read(byte[] var1_1, int var2_2, int var3_3) {
        if (TDebug.TraceCircularBuffer) {
            TDebug.out(">TCircularBuffer.read(): called.");
            this.dumpInternalState();
        }
        if (!this.isOpen()) {
            if (this.availableRead() > 0) {
                var3_3 = Math.min(var3_3, this.availableRead());
                if (TDebug.TraceCircularBuffer) {
                    TDebug.out("reading rest in closed buffer, length: " + var3_3);
                }
            } else {
                if (TDebug.TraceCircularBuffer) {
                    TDebug.out("< not open. returning -1.");
                }
                return -1;
            }
        }
        var4_4 = this;
        synchronized (var4_4) {
            if (this.m_trigger != null && this.availableRead() < var3_3) {
                if (TDebug.TraceCircularBuffer) {
                    TDebug.out("executing trigger.");
                }
                this.m_trigger.execute();
            }
            if (!this.m_bBlockingRead) {
                var3_3 = Math.min(this.availableRead(), var3_3);
            }
            var5_5 = var3_3;
            ** GOTO lbl43
            {
                block18: {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException var6_6) {
                        if (!TDebug.TraceAllExceptions) break block18;
                        TDebug.out(var6_6);
                    }
                }
                do {
                    if (this.availableRead() == 0) continue block5;
                    var6_7 = Math.min(this.availableRead(), var5_5);
                    while (var6_7 > 0) {
                        var7_8 = Math.min(var6_7, this.m_nSize - this.getReadPos());
                        System.arraycopy(this.m_abData, this.getReadPos(), var1_1, var2_2, var7_8);
                        this.m_nReadPos += var7_8;
                        var2_2 += var7_8;
                        var6_7 -= var7_8;
                        var5_5 -= var7_8;
                    }
                    this.notifyAll();
lbl43:
                    // 2 sources

                } while (var5_5 > 0);
            }
            if (TDebug.TraceCircularBuffer) {
                TDebug.out("After read:");
                this.dumpInternalState();
                TDebug.out("< completed. Read " + var3_3 + " bytes");
            }
            var6_7 = var3_3;
            return var6_7;
        }
    }

    public int write(byte[] byArray) {
        return this.write(byArray, 0, byArray.length);
    }

    /*
     * Unable to fully structure code
     */
    public int write(byte[] var1_1, int var2_2, int var3_3) {
        if (TDebug.TraceCircularBuffer) {
            TDebug.out(">TCircularBuffer.write(): called; nLength: " + var3_3);
            this.dumpInternalState();
        }
        var4_4 = this;
        synchronized (var4_4) {
            if (TDebug.TraceCircularBuffer) {
                TDebug.out("entered synchronized block.");
            }
            if (!this.m_bBlockingWrite) {
                var3_3 = Math.min(this.availableWrite(), var3_3);
            }
            var5_5 = var3_3;
            ** GOTO lbl32
            {
                block12: {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException var6_6) {
                        if (!TDebug.TraceAllExceptions) break block12;
                        TDebug.out(var6_6);
                    }
                }
                do {
                    if (this.availableWrite() == 0) continue block5;
                    var6_7 = Math.min(this.availableWrite(), var5_5);
                    while (var6_7 > 0) {
                        var7_8 = Math.min(var6_7, this.m_nSize - this.getWritePos());
                        System.arraycopy(var1_1, var2_2, this.m_abData, this.getWritePos(), var7_8);
                        this.m_nWritePos += var7_8;
                        var2_2 += var7_8;
                        var6_7 -= var7_8;
                        var5_5 -= var7_8;
                    }
                    this.notifyAll();
lbl32:
                    // 2 sources

                } while (var5_5 > 0);
            }
            if (TDebug.TraceCircularBuffer) {
                TDebug.out("After write:");
                this.dumpInternalState();
                TDebug.out("< completed. Wrote " + var3_3 + " bytes");
            }
            var6_7 = var3_3;
            return var6_7;
        }
    }

    private void dumpInternalState() {
        TDebug.out("m_nReadPos  = " + this.m_nReadPos + " ^= " + this.getReadPos());
        TDebug.out("m_nWritePos = " + this.m_nWritePos + " ^= " + this.getWritePos());
        TDebug.out("availableRead()  = " + this.availableRead());
        TDebug.out("availableWrite() = " + this.availableWrite());
    }

    public static interface Trigger {
        public void execute();
    }
}

