/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.skins;

import edu.xtec.util.ExtendedJDialog;
import edu.xtec.util.Html;
import edu.xtec.util.Messages;
import edu.xtec.util.ResourceBridge;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.StrUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;

public class AboutWindow
extends ExtendedJDialog
implements HyperlinkListener {
    protected ResourceBridge rb;
    protected JTabbedPane tPane;
    private static URL urlBase;

    public AboutWindow(Component component, ResourceBridge resourceBridge, Dimension dimension) {
        super(component, resourceBridge.getMsg("about_window_caption"), true);
        this.rb = resourceBridge;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setPreferredSize(dimension);
        this.tPane = new JTabbedPane();
        jPanel.add((Component)this.tPane, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2));
        JButton jButton = new JButton(resourceBridge.getMsg("about_window_close_button"), ResourceManager.getImageIcon((String)"icons/exit_small.gif"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AboutWindow.this.setVisible(false);
            }
        });
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "South");
        ((JDialog)((Object)this)).getContentPane().add(jPanel);
        ((Window)((Object)this)).pack();
        this.centerOver(component);
    }

    public JTabbedPane getTabbedPane() {
        return this.tPane;
    }

    public void addUrlDocumentTab(URL uRL, String string, Icon icon) {
        try {
            final JEditorPane jEditorPane = new JEditorPane(uRL);
            jEditorPane.setEditable(false);
            jEditorPane.addHyperlinkListener(this);
            this.tPane.addTab(string, icon, new JScrollPane(jEditorPane));
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    jEditorPane.scrollRectToVisible(new Rectangle(0, 0));
                }
            });
        }
        catch (IOException iOException) {
            System.err.println("Error building about window:\n" + iOException);
            this.tPane.addTab(string, new JLabel("ERROR"));
        }
    }

    public void addStrDocumentTab(String string, String string2, URL uRL, Icon icon) {
        final JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditorKit(jEditorPane.getEditorKitForContentType("text/html"));
        if (uRL == null) {
            uRL = AboutWindow.getAboutUrlBase();
        }
        if (uRL != null) {
            ((HTMLDocument)jEditorPane.getDocument()).setBase(uRL);
        }
        jEditorPane.setText(string);
        jEditorPane.setEditable(false);
        jEditorPane.addHyperlinkListener(this);
        this.tPane.addTab(string2, icon, new JScrollPane(jEditorPane));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                jEditorPane.scrollRectToVisible(new Rectangle(0, 0));
            }
        });
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            final String string = hyperlinkEvent.getURL().toString();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AboutWindow.this.rb.displayUrl(string, true);
                }
            });
        }
    }

    public static URL getAboutUrlBase() {
        if (urlBase == null) {
            try {
                URL uRL = ResourceManager.getResource((String)"about/about.html");
                String string = uRL.toString();
                urlBase = new URL(string.substring(0, string.lastIndexOf(47) + 1));
            }
            catch (Exception exception) {
                System.err.println("Resource missing: about.html");
            }
        }
        return urlBase;
    }

    public void buildAboutTab(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws Exception {
        String string8 = ResourceManager.getResourceText((String)"about/about.html", (boolean)false);
        if (string == null) {
            string = "JClic";
        }
        if (string3 == null) {
            string3 = "logo_small.png";
        }
        if (string4 == null) {
            string4 = this.rb.getMsg("about_creditsDoc");
        }
        String string9 = ResourceManager.getResourceText((String)string4, (boolean)false);
        if (string5 == null) {
            string5 = this.rb.getMsg("about_otherCreditsDoc");
        }
        String string10 = ResourceManager.getResourceText((String)string5, (boolean)false);
        if (string6 == null) {
            string6 = this.rb.getMsg("about_licenseDoc");
        }
        String string11 = ResourceManager.getResourceText((String)string6, (boolean)false);
        if (string7 == null) {
            string7 = this.rb.getMsg("about_sponsorsDoc");
        }
        String string12 = ResourceManager.getResourceText((String)string7, (boolean)false);
        URL uRL = ResourceManager.getResource((String)("about/" + string3));
        string8 = StrUtils.replace((String)string8, (String)"%LOGO", (String)uRL.toExternalForm());
        StringBuffer stringBuffer = new StringBuffer(string);
        if (string2 != null) {
            stringBuffer.append(" ").append(this.rb.getMsg("VERSION")).append(" ").append(string2);
        }
        string8 = StrUtils.replace((String)string8, (String)"%APPVERSION", (String)stringBuffer.substring(0));
        string8 = StrUtils.replace((String)string8, (String)"%CREDITS", (String)string9);
        stringBuffer.setLength(0);
        stringBuffer.append(this.rb.getMsg("about_otherCreditsCaption")).append("<BR>&nbsp;<BR>").append(string10);
        string8 = StrUtils.replace((String)string8, (String)"%OTHERCREDITS", (String)stringBuffer.substring(0));
        string8 = StrUtils.replace((String)string8, (String)"%LICENSE", (String)string11);
        stringBuffer.setLength(0);
        if (string12 != null && string12.length() > 0) {
            stringBuffer.append(this.rb.getMsg("about_sponsorsCaption")).append("<BR>").append(string12);
        }
        string8 = StrUtils.replace((String)string8, (String)"%SPONSORS", (String)stringBuffer.substring(0));
        this.addStrDocumentTab(string8, this.rb.getMsg("ABOUT"), AboutWindow.getAboutUrlBase(), ResourceManager.getImageIcon((String)"icons/about_small.gif"));
    }

    public void buildStandardTab(String string, String string2, String string3, String string4) {
        String string5 = this.rb.getMsg("about_window_html_bgcolor");
        String string6 = this.rb.getMsg("about_window_html_style");
        String string7 = this.rb.getMsg("about_window_html_header");
        StringBuffer stringBuffer = new StringBuffer(4096);
        stringBuffer.append(string7);
        if (string2 != null) {
            stringBuffer.append("<br><b>").append(this.rb.getMsg(string2)).append("</b><hr>");
        }
        stringBuffer.append(string);
        String string8 = Html.table((String)stringBuffer.substring(0), (String)"100%", (int)0, (int)5, (int)-1, (String)string6, (boolean)true);
        this.addStrDocumentTab(Html.getHtmlDoc((String)string8, (String)string5), this.rb.getMsg(string3), AboutWindow.getAboutUrlBase(), ResourceManager.getImageIcon((String)string4));
    }

    public String getHtmlSystemInfo() {
        Messages messages = this.rb.getOptions().getMessages();
        Html html = new Html(3000);
        html.doubleCell(messages.get("about_window_lb_os"), true, System.getProperty("os.name") + " " + System.getProperty("os.version") + " - " + System.getProperty("os.arch"), false);
        html.doubleCell(messages.get("about_window_lb_java_version"), true, System.getProperty("java.version"), false);
        html.doubleCell(messages.get("about_window_lb_java_vm"), true, System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + "\n" + System.getProperty("java.vm.vendor"), false);
        html.doubleCell(messages.get("about_window_lb_java_home"), true, System.getProperty("java.home"), false);
        html.doubleCell(messages.get("about_window_lb_free_mem"), true, messages.kValue(Runtime.getRuntime().freeMemory()), false);
        html.doubleCell(messages.get("about_window_lb_total_mem"), true, messages.kValue(Runtime.getRuntime().totalMemory()), false);
        Object v = this.rb.getOptions().get("mediaSystem");
        String string = "Java Media Framework".equals(v) ? "Java Media Framework" : ("QuickTime".equals(v) ? "QuickTime for Java 6.0-" : ("QuickTime 6.1".equals(v) ? "QuickTime for Java 6.1+" : "-"));
        html.doubleCell(messages.get("about_window_lb_mediaSystem"), true, string, false);
        if (this.rb.getOptions().getBoolean("trace")) {
            Iterator iterator = ((Hashtable)System.getProperties()).keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                html.doubleCell(string2, true, System.getProperty(string2), false);
            }
        }
        return Html.table((String)html.toString(), null, (int)0, (int)5, (int)-1, null, (boolean)false);
    }
}

