/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.media;

import edu.xtec.jclic.media.AudioBuffer;
import java.io.ByteArrayOutputStream;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;

public class JavaSoundAudioBuffer
extends AudioBuffer {
    public static final float RATE = 11025.0f;
    public static final int BITS = 16;
    public static final int CHANNELS = 1;
    public static final int LINE_BUFFER = 10000;
    public static final int STEP_BUFFER = 5000;
    private static TargetDataLine m_targetLine;
    private static SourceDataLine m_sourceLine;
    private static RecordThread recordThread;
    private static PlayThread playThread;
    private static Timer recordTimer;
    private static boolean initialized;
    private byte[] m_buffer;
    static /* synthetic */ Class class$javax$sound$sampled$TargetDataLine;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;

    public JavaSoundAudioBuffer(int n) throws Exception {
        super(n);
        JavaSoundAudioBuffer.initialize();
    }

    public static void initialize() throws Exception {
        if (!initialized) {
            JavaSoundAudioBuffer.buildLines();
        }
    }

    protected static void buildLines() throws Exception {
        Object object;
        Vector<AudioFormat> vector = new Vector<AudioFormat>();
        Vector<AudioFormat> vector2 = new Vector<AudioFormat>();
        Line.Info[] infoArray = AudioSystem.getTargetLineInfo(new Line.Info(class$javax$sound$sampled$TargetDataLine == null ? (class$javax$sound$sampled$TargetDataLine = JavaSoundAudioBuffer.class$("javax.sound.sampled.TargetDataLine")) : class$javax$sound$sampled$TargetDataLine));
        int n = 0;
        while (n < infoArray.length) {
            if (infoArray[n] instanceof DataLine.Info) {
                object = ((DataLine.Info)infoArray[n]).getFormats();
                int n2 = 0;
                while (n2 < ((AudioFormat[])object).length) {
                    AudioFormat audioFormat = object[n2];
                    if (audioFormat.getSampleRate() == -1.0f || audioFormat.getSampleRate() >= 8000.0f) {
                        vector2.add(audioFormat);
                    }
                    if (audioFormat.getChannels() == 1 && audioFormat.getSampleSizeInBits() == 16 && (audioFormat.getSampleRate() == -1.0f || audioFormat.getSampleRate() == 11025.0f)) {
                        vector.add(audioFormat);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        if (vector2.isEmpty()) {
            throw new Exception("Unable to find any available TargetDataLine for recording");
        }
        if (!vector.isEmpty()) {
            AudioFormat[] audioFormatArray = vector.toArray(new AudioFormat[vector.size()]);
            object = new DataLine.Info(class$javax$sound$sampled$TargetDataLine == null ? (class$javax$sound$sampled$TargetDataLine = JavaSoundAudioBuffer.class$("javax.sound.sampled.TargetDataLine")) : class$javax$sound$sampled$TargetDataLine, audioFormatArray, 10000, 11000);
            try {
                m_targetLine = (TargetDataLine)AudioSystem.getLine((Line.Info)object);
                m_targetLine.open();
            }
            catch (Exception exception) {
                m_targetLine = null;
            }
        }
        if (m_targetLine == null) {
            AudioFormat[] audioFormatArray = vector2.toArray(new AudioFormat[vector2.size()]);
            object = new DataLine.Info(class$javax$sound$sampled$TargetDataLine == null ? (class$javax$sound$sampled$TargetDataLine = JavaSoundAudioBuffer.class$("javax.sound.sampled.TargetDataLine")) : class$javax$sound$sampled$TargetDataLine, audioFormatArray, 10000, 11000);
            m_targetLine = (TargetDataLine)AudioSystem.getLine((Line.Info)object);
            m_targetLine.open();
        }
        object = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = JavaSoundAudioBuffer.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, m_targetLine.getFormat());
        m_sourceLine = (SourceDataLine)AudioSystem.getLine((Line.Info)object);
        m_sourceLine.open();
        initialized = true;
    }

    public void record() throws Exception {
        if (!initialized) {
            AudioBuffer.hideRecordingCursor();
            AudioBuffer.activeAudioBuffer = null;
            return;
        }
        this.stop();
        recordThread = new RecordThread();
        recordThread.start();
        recordTimer = new Timer();
        recordTimer.schedule(new TimerTask(){

            public void run() {
                recordTimer = null;
                if (recordThread != null) {
                    recordThread.running = false;
                }
            }
        }, this.m_seconds * 1000);
    }

    public void play() throws Exception {
        if (!initialized) {
            return;
        }
        this.stop();
        if (this.m_buffer != null && this.m_buffer.length > 0) {
            playThread = new PlayThread();
            playThread.start();
        }
    }

    private boolean isRunning() {
        return playThread != null || recordThread != null;
    }

    public void stop() {
        if (recordThread != null) {
            JavaSoundAudioBuffer.recordThread.running = false;
        }
        if (playThread != null) {
            JavaSoundAudioBuffer.playThread.running = false;
        }
        while (recordThread != null || playThread != null) {
            Thread.currentThread();
            Thread.yield();
        }
    }

    protected void clear() {
        this.stop();
        this.m_buffer = null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ byte[] access$002(JavaSoundAudioBuffer javaSoundAudioBuffer, byte[] byArray) {
        javaSoundAudioBuffer.m_buffer = byArray;
        return byArray;
    }

    class PlayThread
    extends Thread {
        public boolean running = false;
        byte[] buf;

        public PlayThread() {
            this.buf = new byte[JavaSoundAudioBuffer.this.m_buffer.length];
            System.arraycopy(JavaSoundAudioBuffer.this.m_buffer, 0, this.buf, 0, JavaSoundAudioBuffer.this.m_buffer.length);
        }

        public void run() {
            this.running = true;
            try {
                m_sourceLine.start();
                int n = m_sourceLine.getBufferSize() / 2;
                int n2 = 0;
                int n3 = this.buf.length;
                while (this.running && n3 > 0) {
                    int n4 = m_sourceLine.write(this.buf, n2, Math.min(n, n3));
                    n2 += n4;
                    n3 -= n4;
                    Thread.currentThread();
                    Thread.yield();
                }
            }
            catch (Exception exception) {
                System.err.println("JavaSound playing error:\n" + exception);
            }
            m_sourceLine.drain();
            m_sourceLine.stop();
            JavaSoundAudioBuffer.playThread = null;
            this.running = false;
        }
    }

    class RecordThread
    extends Thread {
        public boolean running = false;

        public void run() {
            AudioBuffer.activeAudioBuffer = JavaSoundAudioBuffer.this;
            this.running = true;
            JavaSoundAudioBuffer.access$002(JavaSoundAudioBuffer.this, null);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(10000);
            try {
                byte[] byArray = new byte[5000];
                m_targetLine.start();
                do {
                    int n;
                    if ((n = m_targetLine.available()) > 0) {
                        int n2 = m_targetLine.read(byArray, 0, Math.min(n, byArray.length));
                        byteArrayOutputStream.write(byArray, 0, n2);
                    }
                    Thread.currentThread();
                    Thread.yield();
                } while (this.running);
                if (recordTimer != null) {
                    recordTimer.cancel();
                    recordTimer = null;
                }
            }
            catch (Exception exception) {
                System.err.println("JavaSound recording error:\n" + exception);
            }
            m_targetLine.stop();
            m_targetLine.flush();
            JavaSoundAudioBuffer.access$002(JavaSoundAudioBuffer.this, byteArrayOutputStream.toByteArray());
            AudioBuffer.hideRecordingCursor();
            AudioBuffer.activeAudioBuffer = null;
            JavaSoundAudioBuffer.recordThread = null;
            this.running = false;
        }
    }
}

