/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.media;

import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.media.AudioBuffer;
import edu.xtec.jclic.media.CheckMediaSystem;
import edu.xtec.jclic.media.MediaContent;
import edu.xtec.util.GlobalMouseAdapter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Constructor;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public abstract class ActiveMediaPlayer {
    public static final int AUDIO_BUFFERS = 10;
    protected static final AudioBuffer[] audioBuffer = new AudioBuffer[10];
    MediaContent mc;
    PlayStation ps;
    ActiveBox bx;
    Component visualComponent;
    GlobalMouseAdapter mouseAdapter;
    boolean useAudioBuffer;
    static /* synthetic */ Class class$edu$xtec$jclic$media$MediaContent;
    static /* synthetic */ Class class$edu$xtec$jclic$bags$MediaBag;
    static /* synthetic */ Class class$edu$xtec$jclic$PlayStation;

    public static ActiveMediaPlayer createActiveMediaPlayer(MediaContent mediaContent, MediaBag mediaBag, PlayStation playStation) {
        ActiveMediaPlayer activeMediaPlayer = null;
        String string = null;
        String string2 = playStation.getOptions().getString("mediaSystem");
        switch (mediaContent.mediaType) {
            case 5: 
            case 6: {
                if (playStation.getOptions().getBoolean("Mac")) {
                    if ("QuickTime 6.1".equals(string2)) {
                        string = "edu.xtec.jclic.media.QT61ActiveMediaPlayer";
                        break;
                    }
                    if ("QuickTime".equals(string2)) {
                        string = "edu.xtec.jclic.media.QTActiveMediaPlayer";
                        break;
                    }
                }
            }
            case 1: 
            case 3: {
                string = "edu.xtec.jclic.media.JavaSoundActiveMediaPlayer";
                break;
            }
            default: {
                if ("QuickTime 6.1".equals(string2)) {
                    string = "edu.xtec.jclic.media.QT61ActiveMediaPlayer";
                    break;
                }
                if ("QuickTime".equals(string2)) {
                    string = "edu.xtec.jclic.media.QTActiveMediaPlayer";
                    break;
                }
                if ("Java Media Framework".equals(string2)) {
                    string = "edu.xtec.jclic.media.JMFActiveMediaPlayer";
                    break;
                }
                CheckMediaSystem.warn(playStation.getOptions());
            }
        }
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                Constructor<?> constructor = clazz.getConstructor(class$edu$xtec$jclic$media$MediaContent == null ? (class$edu$xtec$jclic$media$MediaContent = ActiveMediaPlayer.class$("edu.xtec.jclic.media.MediaContent")) : class$edu$xtec$jclic$media$MediaContent, class$edu$xtec$jclic$bags$MediaBag == null ? (class$edu$xtec$jclic$bags$MediaBag = ActiveMediaPlayer.class$("edu.xtec.jclic.bags.MediaBag")) : class$edu$xtec$jclic$bags$MediaBag, class$edu$xtec$jclic$PlayStation == null ? (class$edu$xtec$jclic$PlayStation = ActiveMediaPlayer.class$("edu.xtec.jclic.PlayStation")) : class$edu$xtec$jclic$PlayStation);
                activeMediaPlayer = (ActiveMediaPlayer)constructor.newInstance(mediaContent, mediaBag, playStation);
            }
            catch (Exception exception) {
                System.err.println("Error building media player:\n" + exception);
            }
        }
        return activeMediaPlayer;
    }

    protected ActiveMediaPlayer(MediaContent mediaContent, MediaBag mediaBag, PlayStation playStation) {
        this.mc = mediaContent;
        this.ps = playStation;
        this.bx = null;
        this.visualComponent = null;
        this.mouseAdapter = null;
        this.useAudioBuffer = false;
        try {
            switch (mediaContent.mediaType) {
                case 5: {
                    ActiveMediaPlayer.clearAudioBuffer(mediaContent.recBuffer);
                    ActiveMediaPlayer.audioBuffer[mediaContent.recBuffer] = this.createAudioBuffer(mediaContent.length);
                }
                case 6: {
                    this.useAudioBuffer = true;
                    break;
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Error:\n" + exception);
        }
    }

    public abstract AudioBuffer createAudioBuffer(int var1) throws Exception;

    public abstract void realize();

    public void play(final ActiveBox activeBox) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ActiveMediaPlayer.stopAllAudioBuffers();
                ActiveMediaPlayer.this.playNow(activeBox);
            }
        });
    }

    protected void playNow(ActiveBox activeBox) {
        try {
            switch (this.mc.mediaType) {
                case 5: {
                    if (audioBuffer[this.mc.recBuffer] == null) break;
                    audioBuffer[this.mc.recBuffer].record(this.ps, activeBox);
                    break;
                }
                case 6: {
                    if (audioBuffer[this.mc.recBuffer] == null) break;
                    audioBuffer[this.mc.recBuffer].play();
                    break;
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Error playing media \"" + this.mc.mediaFileName + "\":\n" + exception);
        }
    }

    public void stop() {
        if (this.useAudioBuffer) {
            ActiveMediaPlayer.stopAudioBuffer(this.mc.recBuffer);
        }
    }

    protected void finalize() throws Throwable {
        this.clear();
        super.finalize();
    }

    public void clear() {
        this.stop();
        if (this.useAudioBuffer) {
            ActiveMediaPlayer.clearAudioBuffer(this.mc.recBuffer);
        }
    }

    protected abstract void setTimeRanges();

    public static void clearAudioBuffer(int n) {
        if (n >= 0 && n < 10 && audioBuffer[n] != null) {
            audioBuffer[n].clear();
            ActiveMediaPlayer.audioBuffer[n] = null;
        }
    }

    public static void clearAllAudioBuffers() {
        int n = 0;
        while (n < 10) {
            ActiveMediaPlayer.clearAudioBuffer(n);
            ++n;
        }
    }

    public static int countActiveBuffers() {
        int n = 0;
        int n2 = 0;
        while (n2 < 10) {
            if (audioBuffer[n2] != null) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public static void stopAllAudioBuffers() {
        int n = 0;
        while (n < 10) {
            if (audioBuffer[n] != null) {
                audioBuffer[n].stop();
            }
            ++n;
        }
    }

    public static void stopAudioBuffer(int n) {
        if (n >= 0 && n < 10 && audioBuffer[n] != null) {
            audioBuffer[n].stop();
        }
    }

    public void checkVisualComponentBounds(ActiveBox activeBox) {
        if (this.visualComponent == null) {
            return;
        }
        Rectangle rectangle = new Rectangle();
        if (!this.mc.free) {
            rectangle.setBounds(activeBox.getBounds());
        } else {
            rectangle.setBounds(this.ps.getComponent().getBounds());
        }
        Point point = new Point();
        Dimension dimension = new Dimension(this.visualComponent.getPreferredSize());
        if (this.mc.absLocation != null) {
            point.setLocation(this.mc.absLocation);
            if (point.x + dimension.width > rectangle.width) {
                point.x = rectangle.width - dimension.width;
            }
            if (point.y + dimension.height > rectangle.height) {
                point.y = rectangle.height - dimension.height;
            }
        }
        if (this.mc.stretch) {
            int n;
            int n2 = rectangle.width - point.x - dimension.width;
            if (n2 < 0) {
                dimension.width = rectangle.width - point.x;
                n2 = 0;
            }
            if ((n = rectangle.height - point.y - dimension.height) < 0) {
                dimension.height = rectangle.height - point.y;
                n = 0;
            }
            if (this.mc.absLocation == null) {
                point.x += n2 / 2;
                point.y += n / 2;
            }
        }
        Rectangle rectangle2 = new Rectangle(rectangle.x + point.x, rectangle.y + point.y, dimension.width, dimension.height);
        this.visualComponent.setSize(dimension);
        this.visualComponent.setLocation(rectangle2.getLocation());
        this.visualComponent.setBounds(rectangle2);
    }

    public void setVisualComponentVisible(boolean bl) {
        if (this.visualComponent != null) {
            this.visualComponent.setVisible(bl);
        }
    }

    protected abstract Component getVisualComponent();

    public void attachVisualComponent() {
        if (this.mc.mediaType != 2 || this.bx == null) {
            return;
        }
        this.visualComponent = this.getVisualComponent();
        if (this.visualComponent == null) {
            return;
        }
        this.visualComponent.setVisible(false);
        JComponent jComponent = this.bx.getContainerResolve();
        if (this.mc.free) {
            jComponent = this.ps.getComponent();
        }
        if (jComponent != this.visualComponent.getParent()) {
            jComponent.add(this.visualComponent);
        }
        if (this.mouseAdapter == null && !this.mc.catchMouseEvents) {
            this.mouseAdapter = new GlobalMouseAdapter((Component)jComponent);
            this.mouseAdapter.attachTo(this.visualComponent, true);
        }
        this.checkVisualComponentBounds(this.bx);
        this.visualComponent.setVisible(true);
    }

    protected void destroyVisualComponent() {
        if (this.mouseAdapter != null) {
            this.mouseAdapter.detach(this.visualComponent);
            this.mouseAdapter = null;
        }
        if (this.visualComponent != null) {
            this.visualComponent.setVisible(false);
            this.stop();
            this.visualComponent = null;
        }
    }

    public void linkTo(ActiveBox activeBox) {
        if (this.bx != null && this.bx != activeBox) {
            this.bx.setHostedMediaPlayer(null);
            this.destroyVisualComponent();
        }
        this.bx = activeBox;
        if (this.bx != null) {
            this.bx.setHostedMediaPlayer(this);
        } else {
            this.destroyVisualComponent();
        }
    }

    public MediaContent getMediaContent() {
        return this.mc;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

