/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.jclic.edit.Editable;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.misc.Bmp;
import edu.xtec.jclic.misc.Utils;
import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import java.awt.Image;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import org.jdom.Element;

public class MediaBagElement
implements Editable,
Domable,
Comparable {
    private String name;
    private String fileName;
    private int usageCount;
    private Object data;
    public boolean projectFlag;
    public boolean saveFlag;
    public boolean animated;
    private boolean hasThumb;
    public static final String ELEMENT_NAME = "media";
    public static final String FILE = "file";
    public static final String NAME = "name";
    public static final String SAVE = "save";
    public static final String USAGE = "usage";
    private static int imgReadyFlag = 3;

    public MediaBagElement(String string) {
        this(string, null);
    }

    public MediaBagElement(String string, Object object) {
        this(string, object, string);
    }

    public MediaBagElement(String string, Object object, String string2) {
        this.setName(string2);
        this.setFileName(string);
        this.setData(object);
        this.usageCount = 0;
        this.animated = false;
        this.saveFlag = true;
    }

    public Element getJDomElement() {
        Element element = new Element(ELEMENT_NAME);
        element.setAttribute(NAME, this.name);
        element.setAttribute(FILE, this.fileName);
        if (!this.saveFlag) {
            element.setAttribute(SAVE, JDomUtility.BOOL_STR[0]);
        }
        if (this.usageCount > 0) {
            element.setAttribute(USAGE, Integer.toString(this.usageCount));
        }
        return element;
    }

    protected static MediaBagElement getMediaBagElement(Element element) throws Exception {
        MediaBagElement mediaBagElement = new MediaBagElement("NONAME", null);
        mediaBagElement.setProperties(element, null);
        return mediaBagElement;
    }

    public void setProperties(Element element, Object object) throws Exception {
        JDomUtility.checkName((Element)element, (String)ELEMENT_NAME);
        this.setName(JDomUtility.getStringAttr((Element)element, (String)NAME, (String)this.name, (boolean)false));
        this.setFileName(JDomUtility.getStringAttr((Element)element, (String)FILE, (String)this.fileName, (boolean)false));
        this.saveFlag = JDomUtility.getBoolAttr((Element)element, (String)SAVE, (boolean)true);
        this.usageCount = JDomUtility.getIntAttr((Element)element, (String)USAGE, (int)this.usageCount);
    }

    public Editor getEditor(Editor editor) {
        return Editor.createEditor(this.getClass().getName() + "Editor", this, editor);
    }

    public boolean isEmpty() {
        return this.data == null;
    }

    public void setFileName(String string) {
        this.fileName = FileSystem.stdFn(string);
        this.data = null;
        this.animated = false;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isImage() {
        return Utils.getFileType(this.fileName) == 0;
    }

    public void setData(Object object) {
        this.data = object;
        this.animated = false;
        if (this.data != null && this.data instanceof Image) {
            Toolkit.getDefaultToolkit().prepareImage((Image)this.data, -1, -1, null);
        }
    }

    public Object getData() {
        return this.data;
    }

    public boolean isInternal() {
        return this.data != null;
    }

    public void incUsageCount() {
        ++this.usageCount;
    }

    public void decUsageCount() {
        --this.usageCount;
    }

    public boolean isUsed() {
        return this.usageCount <= 0;
    }

    protected void finalize() throws Throwable {
        Image image = this.getImage();
        if (image != null) {
            image.flush();
        }
        this.data = null;
        super.finalize();
    }

    public boolean prepareImage(FileSystem fileSystem) throws Exception {
        boolean bl = false;
        if (this.isImage()) {
            if (this.data == null || !(this.data instanceof Image)) {
                if (this.fileName.toLowerCase().endsWith(".bmp")) {
                    Bmp bmp = new Bmp(fileSystem.getInputStream(this.fileName));
                    this.setData(bmp.getImage());
                } else {
                    this.setData(fileSystem.getImageFile(this.fileName));
                }
            }
            bl = true;
        }
        return bl;
    }

    public Image getImage() throws Exception {
        int n = 0;
        if (this.data == null || !(this.data instanceof Image)) {
            return null;
        }
        if (!this.animated) {
            while (true) {
                if (((n = Toolkit.getDefaultToolkit().checkImage((Image)this.data, -1, -1, null)) & 0xC0) != 0) {
                    this.data = null;
                    break;
                }
                if ((n & imgReadyFlag) == imgReadyFlag) break;
                Thread.currentThread();
                Thread.sleep(50L);
            }
        }
        if (this.data != null && (n & 0x10) != 0) {
            this.animated = true;
        }
        return (Image)this.data;
    }

    public Image prepareAndGetImage(FileSystem fileSystem) throws Exception {
        Image image = this.getImage();
        if (image == null && this.data == null && this.prepareImage(fileSystem)) {
            image = this.getImage();
        }
        return image;
    }

    public ImageIcon getThumbNail(int n, int n2, FileSystem fileSystem) {
        ImageIcon imageIcon = null;
        try {
            Image image = this.prepareAndGetImage(fileSystem);
            if (image == null) {
                image = Utils.getFileIcon(this.fileName).getImage();
            }
            if (image != null && n > 0 && n2 > 0) {
                int n3 = image.getWidth(null);
                int n4 = image.getHeight(null);
                if (n3 > 0 && n4 > 0 && (n3 > n || n4 > n2)) {
                    double d = Math.min((double)n / (double)n3, (double)n2 / (double)n4);
                    image = image.getScaledInstance((int)(d * (double)n3), (int)(d * (double)n4), 4);
                }
                imageIcon = new ImageIcon(image);
                this.hasThumb = true;
            }
        }
        catch (Exception exception) {
            System.err.println("Error reading image:\n" + exception);
        }
        return imageIcon;
    }

    public boolean isWaitingForImage() {
        if (this.hasThumb || this.animated || this.data == null || !(this.data instanceof Image)) {
            return false;
        }
        int n = Toolkit.getDefaultToolkit().checkImage((Image)this.data, -1, -1, null);
        if ((n & 0x10) != 0) {
            this.animated = true;
        }
        boolean bl = (n & 0x30) == 0;
        return bl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = FileSystem.stdFn(string);
    }

    public String toString() {
        return this.name;
    }

    public int compareTo(Object object) {
        int n = -1;
        if (this.getName() != null && object instanceof MediaBagElement) {
            n = this.getName().compareTo(((MediaBagElement)object).getName());
        }
        return n;
    }
}

