/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.media;

import edu.xtec.jclic.media.AudioBuffer;
import edu.xtec.jclic.media.QT61Tools;
import java.io.File;
import quicktime.app.time.TaskAllMovies;
import quicktime.app.view.MoviePlayer;
import quicktime.io.QTFile;
import quicktime.std.sg.SGChannel;
import quicktime.std.sg.SGSoundChannel;
import quicktime.std.sg.SequenceGrabber;

public class QT61AudioBuffer
extends AudioBuffer {
    protected File file;
    protected SequenceGrabber mGrabber;
    protected SGSoundChannel mAudio;
    protected MoviePlayer player;
    protected Thread recordThread;
    protected boolean initialized = false;

    public QT61AudioBuffer(int n) throws Exception {
        super(n);
    }

    public void play() throws Exception {
        this.stop();
        if (this.initialized) {
            if (this.player == null && this.file != null) {
                this.player = QT61Tools.getPlayer(this.file);
            }
            if (this.player != null) {
                this.player.setTime(0);
                TaskAllMovies.addMovieAndStart();
                this.player.getMovie().setActive(true);
                this.player.setRate(1.0f);
            }
        }
    }

    protected void clear() {
        this.stop();
        if (this.file != null) {
            try {
                this.file.delete();
            }
            catch (Exception exception) {
                System.err.println("ERROR: Unable to delete file " + this.file.getPath() + "\n" + exception);
            }
            this.file = null;
        }
    }

    public void stop() {
        try {
            if (this.player != null) {
                this.player.setRate(0.0f);
                this.player.getMovie().setActive(false);
                TaskAllMovies.removeMovie();
            }
            int n = 0;
            while (n < 10) {
                if (this.mGrabber != null && this.mGrabber.isRecordMode()) {
                    this.mGrabber.stop();
                    Thread.currentThread();
                    Thread.sleep(50L);
                    ++n;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            System.err.println("QuickTime recording error at STOP:\n" + exception);
        }
    }

    protected void record() throws Exception {
        this.stop();
        if (this.player != null) {
            try {
                this.player.getMovie().disposeQTObject();
            }
            catch (Exception exception) {
                System.err.println("QuickTime error: unable to release player\n" + exception);
            }
            this.player = null;
            this.initialized = false;
        }
        if (this.file != null) {
            this.file.delete();
            this.file = null;
        }
        this.file = File.createTempFile("rec", ".tmp");
        this.file.deleteOnExit();
        this.mGrabber = new SequenceGrabber();
        this.mAudio = new SGSoundChannel(this.mGrabber);
        this.mAudio.setUsage(1);
        this.mAudio.setSoundInputRate(22050.0f);
        this.mAudio.setSoundInputParameters(16, 1, 0);
        this.mGrabber.setDataOutput(new QTFile(this.file), 1);
        this.mGrabber.setMaximumRecordTime(this.m_seconds * 60);
        this.mGrabber.prepare(false, true);
        AudioBuffer.activeAudioBuffer = this;
        this.recordThread = new Thread("JClic sound record"){

            public void run() {
                try {
                    while (QT61AudioBuffer.this.mGrabber.isRecordMode() && QT61AudioBuffer.this.mGrabber.idleMore()) {
                        QT61AudioBuffer.this.mGrabber.idle();
                        Thread.sleep(20L);
                    }
                    if (QT61AudioBuffer.this.mGrabber.isRecordMode()) {
                        QT61AudioBuffer.this.mGrabber.stop();
                    }
                    QT61AudioBuffer.this.recordThread = null;
                    if (QT61AudioBuffer.this.mAudio != null) {
                        QT61AudioBuffer.this.mGrabber.disposeChannel((SGChannel)QT61AudioBuffer.this.mAudio);
                        QT61AudioBuffer.this.mAudio = null;
                    }
                    QT61AudioBuffer.this.mGrabber.release();
                    QT61AudioBuffer.this.mGrabber = null;
                    QT61AudioBuffer.this.initialized = true;
                    AudioBuffer.activeAudioBuffer = null;
                    AudioBuffer.hideRecordingCursor();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        this.mGrabber.startRecord();
        this.recordThread.start();
    }
}

