/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.text;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.Constants;
import edu.xtec.jclic.activities.text.TextActivityBase;
import edu.xtec.jclic.activities.text.TextTarget;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.boxes.BoxBase;
import java.awt.AWTEvent;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.rtf.RTFEditorKit;

public class TextActivityPane
extends JTextPane {
    TextActivityBase.Panel tabp;
    TextActivityBase tab;
    ActiveBox bx;

    public TextActivityPane(TextActivityBase.Panel panel) {
        this.tabp = panel;
        this.tab = (TextActivityBase)panel.getActivity();
        this.bx = new ActiveBox(null, (JComponent)((Object)panel), null);
        this.bx.setVisible(false);
        this.setEditorKit(new RTFEditorKit());
        this.enableEvents(16L);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof MouseEvent && !this.processMouse((MouseEvent)aWTEvent)) {
            ((MouseEvent)aWTEvent).consume();
            return;
        }
        super.processEvent(aWTEvent);
    }

    public boolean processMouse(MouseEvent mouseEvent) {
        boolean bl = true;
        if (mouseEvent.getID() == 501) {
            if (this.tabp.showingPrevScreen) {
                this.tabp.ps.startActivity((Activity.Panel)this.tabp);
                bl = false;
            } else if (this.tabp.isPlaying() && this.bx.isVisible() && this.bx.contains((Point2D)mouseEvent.getPoint())) {
                if (this.bx.getContent().mediaContent != null) {
                    this.bx.playMedia(this.tabp.ps);
                }
                bl = false;
            }
        }
        return bl;
    }

    public void enableActiveBox(ActiveBoxContent activeBoxContent, Point point) {
        if (activeBoxContent.dimension != null) {
            this.bx.setContent(activeBoxContent);
            this.bx.setBounds((Rectangle2D)new Rectangle(point, activeBoxContent.dimension));
            this.bx.setVisible(true);
            this.bx.repaint();
        }
    }

    public void disableActiveBox() {
        this.bx.setVisible(false);
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        super.paint(graphics2D);
        if (this.bx.isVisible()) {
            RenderingHints renderingHints = graphics2D.getRenderingHints();
            graphics2D.setRenderingHints(Constants.DEFAULT_RENDERING_HINTS);
            do {
                BoxBase.flagFontReduced = false;
                this.bx.update(graphics2D, graphics2D.getClipBounds(), (ImageObserver)this);
            } while (BoxBase.flagFontReduced);
            graphics2D.setRenderingHints(renderingHints);
        }
    }

    public void setStyledDocument(StyledDocument styledDocument) {
        this.transferFocus();
        Style style = styledDocument.getStyle("default");
        AttributeSet attributeSet = style.copyAttributes();
        super.setStyledDocument(styledDocument);
        style.addAttributes(attributeSet);
        this.setBackground(StyleConstants.getBackground(style));
        Style style2 = this.tab.styleContext.getStyle("target");
        if (style2 != null) {
            this.setCaretColor(StyleConstants.getForeground(style2));
        }
        this.requestFocus();
    }

    protected void targetChanged(TextTarget textTarget) {
    }
}

