/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.text;

import edu.xtec.jclic.activities.text.Evaluator;
import edu.xtec.jclic.activities.text.TargetMarker;
import edu.xtec.jclic.activities.text.TextActivityBase;
import edu.xtec.jclic.activities.text.TextActivityDocument;
import edu.xtec.jclic.activities.text.TextActivityPane;
import edu.xtec.jclic.activities.text.TextTarget;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class TargetMarkerBag
extends ArrayList {
    private TargetMarker currentTarget = null;

    public TargetMarkerBag() {
        super(10);
    }

    public boolean add(Object object) {
        if (!(object instanceof TargetMarker)) {
            return false;
        }
        TargetMarker targetMarker = (TargetMarker)object;
        int n = 0;
        while (n < this.size()) {
            if (this.getElement((int)n).begOffset >= targetMarker.begOffset) break;
            ++n;
        }
        if (n == this.size()) {
            return super.add(object);
        }
        super.add(n, object);
        return true;
    }

    public TargetMarker getElement(int n) {
        try {
            return (TargetMarker)this.get(n);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setParentPane(TextActivityPane textActivityPane) {
        int n = 0;
        while (n < this.size()) {
            TargetMarker targetMarker = this.getElement(n);
            if (targetMarker.target != null) {
                targetMarker.target.setParentPane(textActivityPane);
            }
            ++n;
        }
    }

    public void setPositions() {
        int n = 0;
        while (n < this.size()) {
            this.getElement(n).setPositions();
            ++n;
        }
    }

    public void updateOffsets() {
        int n = 0;
        while (n < this.size()) {
            this.getElement(n).updateOffsets();
            ++n;
        }
    }

    public void removeUnattachedElements() {
        Iterator iterator = ((AbstractList)this).iterator();
        while (iterator.hasNext()) {
            TargetMarker targetMarker = (TargetMarker)iterator.next();
            targetMarker.updateOffsets();
            if (targetMarker.begOffset >= 0 && targetMarker.endOffset >= 0 && targetMarker.begOffset != targetMarker.endOffset) continue;
            iterator.remove();
        }
    }

    public int checkTargets(Evaluator evaluator) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.size()) {
            if (this.getElement(n2).checkText(evaluator)) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public int countSolvedTargets() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.size()) {
            TextTarget textTarget = this.getElement((int)n2).target;
            if (textTarget != null && textTarget.targetStatus == 2) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public void reset() {
        int n = 0;
        while (n < this.size()) {
            this.getElement(n).reset();
            ++n;
        }
    }

    public TargetMarker getElementByOffset(int n, boolean bl) {
        int n2 = 0;
        while (n2 < this.size()) {
            TargetMarker targetMarker = this.getElement(n2);
            if (targetMarker.contains(n, bl)) {
                return targetMarker;
            }
            ++n2;
        }
        return null;
    }

    public TargetMarker getNearestElement(int n, boolean bl) {
        TargetMarker targetMarker = null;
        TargetMarker targetMarker2 = null;
        int n2 = 0;
        while (n2 < this.size()) {
            TargetMarker targetMarker3 = this.getElement(n2);
            if (targetMarker3.begPos.getOffset() <= n) {
                targetMarker = targetMarker3;
            }
            if (targetMarker3.endPos.getOffset() >= n) {
                targetMarker2 = targetMarker3;
                break;
            }
            ++n2;
        }
        return bl ? targetMarker2 : targetMarker;
    }

    public void setCurrentTarget(TargetMarker targetMarker, TextActivityBase.Panel panel) {
        if (this.currentTarget != null) {
            this.currentTarget.lostFocus(panel);
        }
        if (targetMarker != null && this.contains(targetMarker)) {
            this.currentTarget = targetMarker;
            if (this.currentTarget.target != null) {
                this.currentTarget.target.setModified(false);
            }
            this.currentTarget.requestFocus(panel);
        } else {
            this.currentTarget = null;
        }
    }

    public TargetMarker getCurrentTarget() {
        return this.currentTarget;
    }

    public TargetMarker getElement(TextTarget textTarget) {
        int n = 0;
        while (n < this.size()) {
            TargetMarker targetMarker = this.getElement(n);
            if (targetMarker.target == textTarget) {
                return targetMarker;
            }
            ++n;
        }
        return null;
    }

    public TargetMarker getNextTarget(TargetMarker targetMarker) {
        return this.getElement(Math.min(this.indexOf(targetMarker == null ? this.currentTarget : targetMarker) + 1, this.size() - 1));
    }

    public TargetMarker getPrevTarget(TargetMarker targetMarker) {
        return this.getElement(Math.max(this.indexOf(targetMarker == null ? this.currentTarget : targetMarker) - 1, 0));
    }

    public void swapTargets(TargetMarker targetMarker, TargetMarker targetMarker2) {
        TextActivityDocument textActivityDocument = targetMarker.doc;
        if (textActivityDocument != targetMarker2.doc) {
            System.err.println("Error: unable to swap among different documents");
            return;
        }
        try {
            targetMarker.updateOffsets();
            String string = textActivityDocument.getText(targetMarker.begOffset, targetMarker.getLength());
            targetMarker2.updateOffsets();
            String string2 = textActivityDocument.getText(targetMarker2.begOffset, targetMarker2.getLength());
            textActivityDocument.remove(targetMarker.begOffset, string.length());
            textActivityDocument.insertString(targetMarker.begOffset, string2, textActivityDocument.getTargetAttributeSet());
            targetMarker.endOffset = targetMarker.begOffset + string2.length();
            targetMarker.setPositions();
            targetMarker2.updateOffsets();
            textActivityDocument.remove(targetMarker2.begOffset, string2.length());
            textActivityDocument.insertString(targetMarker2.begOffset, string, textActivityDocument.getTargetAttributeSet());
            targetMarker2.endOffset = targetMarker2.begOffset + string.length();
            targetMarker2.setPositions();
        }
        catch (Exception exception) {
            System.err.println("Error: unable to swap target texts:\n" + exception);
        }
        this.updateOffsets();
    }

    public int[] getParagragraphOffsets() {
        if (this.size() == 0) {
            return null;
        }
        int[] nArray = new int[this.size()];
        int n = 0;
        while (n < this.size()) {
            nArray[n] = this.getElement(n).getParagraphBegOffset();
            ++n;
        }
        return nArray;
    }
}

