/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.puzzles;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.HelpActivityComponent;
import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.automation.ActiveBagContentKit;
import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.boxes.ActiveBagContent;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.boxes.ActiveBoxBag;
import edu.xtec.jclic.boxes.ActiveBoxGrid;
import edu.xtec.jclic.boxes.BoxBag;
import edu.xtec.jclic.boxes.Resizable;
import edu.xtec.jclic.clic3.Clic3Activity;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.jclic.shapers.Rectangular;
import edu.xtec.jclic.shapers.Shaper;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.ResourceBridge;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.image.ImageObserver;
import java.util.Random;
import javax.swing.JComponent;
import org.jdom.Content;
import org.jdom.Element;

public class HolePuzzle
extends Activity
implements ActiveBagContentKit.Compatible {
    public HolePuzzle(JClicProject jClicProject) {
        super(jClicProject);
        this.abc = new ActiveBagContent[1];
        this.boxGridPos = 0;
    }

    public void initNew() {
        super.initNew();
        this.abc[0] = ActiveBagContent.initNew((int)3, (int)2, (int)65);
    }

    public Element getJDomElement() {
        Element element = null;
        if (this.abc[0] == null) {
            return null;
        }
        Element element2 = super.getJDomElement();
        element2.addContent((Content)this.abc[0].getJDomElement());
        element = new Element("scramble");
        element.setAttribute("times", Integer.toString(this.shuffles));
        element2.addContent((Content)element);
        element = new Element("layout");
        element.setAttribute("position", Activity.LAYOUT_NAMES[this.boxGridPos]);
        element2.addContent((Content)element);
        return element2;
    }

    public void setProperties(Element element, Object object) throws Exception {
        super.setProperties(element, object);
        Element element2 = element.getChild("cells");
        if (element2 != null) {
            this.abc[0] = ActiveBagContent.getActiveBagContent((Element)element2, (MediaBag)this.project.mediaBag);
        }
        if (this.abc[0] == null) {
            throw new IllegalArgumentException("Puzzle without content!");
        }
        element2 = element.getChild("scramble");
        if (element2 != null) {
            this.shuffles = JDomUtility.getIntAttr((Element)element2, (String)"times", (int)this.shuffles);
        }
        if ((element2 = element.getChild("layout")) != null) {
            this.boxGridPos = JDomUtility.getStrIndexAttr((Element)element2, (String)"position", (String[])Activity.LAYOUT_NAMES, (int)this.boxGridPos);
        }
    }

    public void setProperties(Clic3Activity clic3Activity) throws Exception {
        super.setProperties(clic3Activity);
        this.abc[0] = clic3Activity.createActiveBagContent(0);
        this.abc[0].setBoxBase(clic3Activity.getBoxBase(0));
        this.boxGridPos = clic3Activity.graPos;
    }

    public int getMinNumActions() {
        return this.abc[0] == null ? 0 : this.abc[0].getNumCells();
    }

    public boolean helpSolutionAllowed() {
        return true;
    }

    public boolean hasRandom() {
        return true;
    }

    public boolean shuffleAlways() {
        return true;
    }

    public Activity.Panel getActivityPanel(PlayStation playStation) {
        return new Panel(playStation);
    }

    class Panel
    extends Activity.Panel {
        ActiveBoxGrid bg = null;
        ActiveBoxGrid parkBg = null;
        int hiddenBoxIndex = 0;
        ActiveBox hiddenBox = null;

        protected Panel(PlayStation playStation) {
            super((Activity)HolePuzzle.this, playStation);
        }

        public void clear() {
            if (this.bg != null) {
                this.bg.end();
                this.bg = null;
            }
            if (this.parkBg != null) {
                this.parkBg.end();
                this.parkBg = null;
            }
        }

        public void buildVisualComponents() throws Exception {
            if (this.firstRun) {
                super.buildVisualComponents();
            }
            this.clear();
            if (HolePuzzle.this.abc[0] != null) {
                if (HolePuzzle.this.acp != null) {
                    HolePuzzle.this.acp.generateContent((Object)new ActiveBagContentKit(HolePuzzle.this.abc[0].nch, HolePuzzle.this.abc[0].ncw, HolePuzzle.this.abc, false), (ResourceBridge)this.ps);
                }
                this.bg = ActiveBoxGrid.createEmptyGrid(null, (JComponent)((Object)this), (double)HolePuzzle.this.margin, (double)HolePuzzle.this.margin, (ActiveBagContent)HolePuzzle.this.abc[0]);
                this.bg.setContent(HolePuzzle.this.abc[0]);
                this.bg.setVisible(true);
                this.hiddenBoxIndex = (int)(Math.random() * (double)this.bg.getNumCells());
                this.hiddenBox = this.bg.getActiveBox(this.hiddenBoxIndex);
                this.hiddenBox.setVisible(false);
                this.parkBg = new ActiveBoxGrid(null, (JComponent)((Object)this), (double)HolePuzzle.this.margin, (double)HolePuzzle.this.margin, this.hiddenBox.width, this.hiddenBox.height, (Shaper)new Rectangular(1, 1), HolePuzzle.this.abc[0].bb);
                this.parkBg.setContent(HolePuzzle.this.abc[0], null, this.hiddenBoxIndex, 0, 1);
                this.parkBg.setBorder(this.bg.hasBorder());
                this.parkBg.setVisible(true);
                ((Container)((Object)this)).invalidate();
            }
        }

        public void initActivity() throws Exception {
            super.initActivity();
            if (!this.firstRun) {
                this.buildVisualComponents();
            }
            this.firstRun = false;
            this.setAndPlayMsg(1, 0);
            if (this.bg != null) {
                Random random = new Random();
                if (HolePuzzle.this.shuffles % 2 != 1) {
                    HolePuzzle.this.shuffles++;
                }
                int n = 0;
                while (n < HolePuzzle.this.shuffles) {
                    ActiveBox activeBox;
                    int n2;
                    Point point = this.bg.getCoord(this.hiddenBox);
                    int n3 = n2 = random.nextBoolean() ? 1 : -1;
                    if (random.nextBoolean()) {
                        point.x += n2;
                        if (point.x < 0 || point.x >= this.bg.nCols) {
                            point.x -= 2 * n2;
                        }
                    } else {
                        point.y += n2;
                        if (point.y < 0 || point.y >= this.bg.nRows) {
                            point.y -= 2 * n2;
                        }
                    }
                    if ((activeBox = this.bg.getActiveBoxWithIdLoc(point.y * this.bg.nCols + point.x)) != null) {
                        this.hiddenBox.exchangeLocation(activeBox);
                    }
                    ++n;
                }
                this.ps.setCounterValue(0, this.bg.countCellsAtEquivalentPlace(true));
                this.playing = true;
            }
        }

        public void render(Graphics2D graphics2D, Rectangle rectangle) {
            if (this.bg != null) {
                this.bg.update(graphics2D, rectangle, (ImageObserver)((Object)this));
            }
            if (this.parkBg != null) {
                this.parkBg.update(graphics2D, rectangle, (ImageObserver)((Object)this));
            }
        }

        public Dimension setDimension(Dimension dimension) {
            if (this.bg == null || this.parkBg == null || ((Component)((Object)this)).getSize().equals(dimension)) {
                return dimension;
            }
            return BoxBag.layoutDouble((Dimension)dimension, (Resizable)this.bg, (Resizable)this.parkBg, (int)HolePuzzle.this.boxGridPos, (int)HolePuzzle.this.margin);
        }

        public void processMouse(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            boolean bl = false;
            if (this.playing) {
                switch (mouseEvent.getID()) {
                    case 501: {
                        this.ps.stopMedia(1);
                        ActiveBox activeBox = this.bg.findActiveBox((Point2D)point);
                        if (activeBox != null) {
                            if (activeBox.isVisible()) {
                                Point point2 = this.bg.getCoordDist(activeBox, this.hiddenBox);
                                if (Math.abs(point2.x) + Math.abs(point2.y) == 1) {
                                    bl = activeBox.playMedia(this.ps);
                                    String string = activeBox.getDescription() + "(" + activeBox.idOrder + ")";
                                    String string2 = "(" + this.hiddenBox.idLoc + ")";
                                    activeBox.exchangeLocation(this.hiddenBox);
                                    boolean bl2 = activeBox.idOrder == activeBox.idLoc;
                                    int n = this.bg.countCellsAtEquivalentPlace(true);
                                    this.ps.reportNewAction(this.getActivity(), "SELECT", string, string2, bl2, n);
                                    if (bl2 && n == this.bg.getNumCells()) {
                                        this.hiddenBox.setVisible(true);
                                        this.parkBg.setVisible(false);
                                        this.finishActivity(true);
                                    } else if (!bl) {
                                        this.playEvent(1);
                                    }
                                }
                            } else {
                                this.playEvent(2);
                            }
                        }
                        ((Component)((Object)this)).repaint();
                    }
                }
            }
        }

        public void showHelp() {
            if (!HolePuzzle.this.helpWindowAllowed() || this.bg == null) {
                return;
            }
            HelpActivityComponent helpActivityComponent = null;
            if (HolePuzzle.this.showSolution) {
                helpActivityComponent = new HelpActivityComponent(this, this){
                    ActiveBoxBag abb;
                    private final /* synthetic */ Panel this$1;
                    {
                        this.this$1 = panel;
                        this.abb = null;
                    }

                    public void render(Graphics2D graphics2D, Rectangle rectangle) {
                        if (this.abb != null) {
                            this.abb.update(graphics2D, rectangle, (ImageObserver)((Object)this));
                        }
                    }

                    public void init() {
                        this.abb = ActiveBoxGrid.createEmptyGrid(null, (JComponent)((Object)this), (double)8.0, (double)8.0, (ActiveBagContent)Panel.access$500((Panel)this.this$1).abc[0]);
                        this.abb.setContent(Panel.access$500((Panel)this.this$1).abc[0]);
                        this.abb.setVisible(true);
                        Dimension dimension = this.this$1.bg.getBounds().getSize();
                        this.abb.setBounds(8.0, 8.0, (double)dimension.width, (double)dimension.height);
                        dimension.width += 16;
                        dimension.height += 16;
                        ((JComponent)((Object)this)).setPreferredSize(dimension);
                        ((JComponent)((Object)this)).setMaximumSize(dimension);
                        ((JComponent)((Object)this)).setMinimumSize(dimension);
                        Point point = (Point)((JComponent)((Object)this)).getClientProperty("prefLoc");
                        if (point != null) {
                            point.translate((int)this.this$1.bg.x - 8, (int)this.this$1.bg.y - 8);
                        }
                    }

                    public void processMouse(MouseEvent mouseEvent) {
                    }
                };
                helpActivityComponent.init();
            }
            if (this.ps.showHelp((JComponent)helpActivityComponent, HolePuzzle.this.helpMsg)) {
                this.ps.reportNewAction(this.getActivity(), "HELP", null, null, false, this.bg.countCellsAtEquivalentPlace(true));
            }
            if (helpActivityComponent != null) {
                helpActivityComponent.end();
            }
        }

        static /* synthetic */ HolePuzzle access$500(Panel panel) {
            return panel.HolePuzzle.this;
        }
    }
}

