/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.skins;

import edu.xtec.jclic.Constants;
import edu.xtec.jclic.boxes.AbstractBox;
import edu.xtec.jclic.boxes.ActiveBagContent;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.boxes.AnimatedActiveBox;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.boxes.Counter;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.misc.Utils;
import edu.xtec.jclic.skins.Skin;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.ResourceManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JProgressBar;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import org.jdom.Element;

public class BasicSkin
extends Skin {
    BufferedImage img;
    Color fillColor;
    int initiated;
    Rectangle frame;
    int leftSlicer;
    int rightSlicer;
    int topSlicer;
    int bottomSlicer;
    Rectangle playerRect;
    Rectangle msgRect;
    Rectangle[] msgAreaRect = new Rectangle[3];
    Color textColor;
    Rectangle[] buttonsRect = new Rectangle[8];
    Rectangle[][] countersRect = new Rectangle[3][];
    ActiveBox[] countersLabel = new ActiveBox[3];
    AbstractBox[] boxes = new AbstractBox[11];
    JProgressBar progressBar;
    Rectangle progressBarRect;
    Rectangle progressAnimationRect;
    AnimatedActiveBox progressAnimation;
    boolean hideProgressBar;
    boolean hideProgressAnim;
    static final int NUM_BOXES = 11;
    public static final String IMAGE = "image";
    public static final String PREFERRED_SIZE = "preferredSize";
    public static final String FRAME = "frame";
    public static final String PLAYER = "player";
    public static final String FILL = "fill";
    public static final String SLICER = "slicer";
    public static final String MESSAGES = "messages";
    public static final String STATUS_BAR = "statusBar";
    public static final String SETTINGS = "settings";
    public static final String STYLE = "style";
    public static final String FOREGROUND = "foreground";
    public static final String BACKGROUND = "background";
    public static final String MSG_AREA = "msgArea";
    public static final String BORDER = "border";
    public static final String BUTTONS = "buttons";
    public static final String BUTTON = "button";
    public static final String ACTIVE = "active";
    public static final String OVER = "over";
    public static final String DISABLED = "disabled";
    public static final String POS = "pos";
    public static final String SOURCE = "source";
    public static final String COUNTERS = "counters";
    public static final String COUNTER = "counter";
    public static final String LABEL = "label";
    public static final String DIGITS = "digits";
    public static final String TOGGLE = "toggle";
    public static final String PROGRESS_BAR = "progressBar";
    public static final String AUTO_HIDE = "autoHide";
    public static final String SHOW_PERCENT = "showPercent";
    public static final String PROGRESS_ANIMATION = "progressAnimation";
    public static final String FRAMES = "frames";
    public static final String DELAY = "delay";
    public static final String STEP = "step";

    protected BasicSkin() {
        int n = 0;
        while (n < 3) {
            this.countersRect[n] = new Rectangle[2];
            ++n;
        }
        this.progressBar = null;
        this.progressAnimation = null;
        this.hideProgressBar = true;
        this.hideProgressAnim = true;
        this.initiated = 0;
    }

    protected void setProperties(Element element, FileSystem fileSystem) throws Exception {
        Element element2;
        Element element3;
        Object object;
        int n;
        int n2;
        Object object2;
        Cloneable cloneable;
        Object object3;
        this.setPreferredSize(JDomUtility.getDimension((Element)element, (String)PREFERRED_SIZE, (Dimension)new Dimension(640, 480)));
        this.fillColor = JDomUtility.getColorByPoint((Element)element, (String)FILL, (BufferedImage)this.img, (Color)Color.white);
        String string = JDomUtility.getStringAttr((Element)element, (String)IMAGE, null, (boolean)true);
        if (string == null || string.length() == 0) {
            throw new Exception("BasicSkin properties without image name!");
        }
        if (fileSystem == null) {
            object3 = ResourceManager.getImageIcon((String)("skins/" + string));
            this.img = Utils.toBufferedImage(((ImageIcon)object3).getImage(), this.fillColor, this);
        } else {
            object3 = new ImageIcon(fileSystem.getBytes(string));
            this.img = Utils.toBufferedImage(((ImageIcon)object3).getImage(), this.fillColor, this);
        }
        this.fillColor = JDomUtility.getColorByPoint((Element)element, (String)FILL, (BufferedImage)this.img, (Color)Color.gray);
        this.setBackground(this.fillColor);
        this.frame = JDomUtility.getRectangle((Element)element, (String)FRAME, null);
        this.setMinimumSize(this.frame.getSize());
        Element element4 = element.getChild(SLICER);
        this.leftSlicer = JDomUtility.getIntAttr((Element)element4, (String)"left", (int)0);
        this.rightSlicer = JDomUtility.getIntAttr((Element)element4, (String)"right", (int)0);
        this.topSlicer = JDomUtility.getIntAttr((Element)element4, (String)"top", (int)0);
        this.bottomSlicer = JDomUtility.getIntAttr((Element)element4, (String)"bottom", (int)0);
        this.playerRect = JDomUtility.getRectangle((Element)element, (String)PLAYER, null);
        this.msgRect = JDomUtility.getRectangle((Element)element, (String)MESSAGES, null);
        BoxBase boxBase = new BoxBase();
        boxBase.transparent = true;
        this.msgBox = new ActiveBox(null, this, 0, this.msgRect, boxBase);
        element4 = element.getChild(PROGRESS_BAR);
        if (element4 != null) {
            this.hideProgressBar = JDomUtility.getBoolAttr((Element)element4, (String)AUTO_HIDE, (boolean)true);
            object3 = this.getBoxBase(element4, null);
            this.progressBarRect = JDomUtility.getRectangle((Element)element4, null, null);
            if (this.progressBarRect != null) {
                this.progressBar = new JProgressBar();
                cloneable = this.getBoxBase(element4, null);
                this.progressBar.setBackground(((BoxBase)cloneable).backColor);
                this.progressBar.setForeground(((BoxBase)cloneable).textColor);
                this.progressBar.setFont(((BoxBase)cloneable).getFont());
                this.progressBar.setStringPainted(JDomUtility.getBoolAttr((Element)element4, (String)SHOW_PERCENT, (boolean)true));
                this.progressBar.setOpaque(false);
                this.progressBar.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                this.add(this.progressBar);
                this.progressBar.setVisible(!this.hideProgressBar);
                this.hasProgress = true;
            }
        }
        if ((element4 = element.getChild(PROGRESS_ANIMATION)) != null) {
            object3 = JDomUtility.getDimension((Element)element4, null, null);
            cloneable = JDomUtility.getPoint((Element)element4, (String)SOURCE, null);
            object2 = JDomUtility.getPoint((Element)element4, (String)POS, null);
            int n3 = JDomUtility.getIntAttr((Element)element4, (String)FRAMES, (int)0);
            n2 = JDomUtility.getIntAttr((Element)element4, (String)DELAY, (int)0);
            int n4 = JDomUtility.getDirection((Element)element4, (int)1);
            this.hideProgressAnim = JDomUtility.getBoolAttr((Element)element4, (String)AUTO_HIDE, (boolean)true);
            if (object3 != null && cloneable != null && n3 > 0 && n2 >= 50) {
                int n5;
                switch (n4) {
                    case 3: {
                        n = 1;
                        n5 = 0;
                        break;
                    }
                    case 2: {
                        n = -1;
                        n5 = 0;
                        break;
                    }
                    case 0: {
                        n = 0;
                        n5 = -1;
                        break;
                    }
                    default: {
                        n = 0;
                        n5 = 1;
                    }
                }
                int n6 = JDomUtility.getIntAttr((Element)element4, (String)STEP, (int)((Dimension)object3).width);
                int n7 = JDomUtility.getIntAttr((Element)element4, (String)STEP, (int)((Dimension)object3).height);
                this.progressAnimationRect = new Rectangle((Point)object2, (Dimension)object3);
                this.progressAnimation = new AnimatedActiveBox(null, this, 0, this.progressAnimationRect, this.getBoxBase(element4, null));
                this.progressAnimation.setDelay(n2);
                object = new ActiveBagContent(1, n3);
                int n8 = 0;
                while (n8 < n3) {
                    ActiveBoxContent activeBoxContent = new ActiveBoxContent();
                    activeBoxContent.setImgContent(this.img, new Rectangle(((Point)cloneable).x + n * n8 * n6, ((Point)cloneable).y + n5 * n8 * n7, ((Dimension)object3).width, ((Dimension)object3).height));
                    ((ActiveBagContent)object).addActiveBoxContent(activeBoxContent);
                    ++n8;
                }
                this.progressAnimation.setContent((ActiveBagContent)object);
                this.progressAnimation.setVisible(!this.hideProgressAnim);
            }
        }
        if ((element4 = element.getChild(STATUS_BAR)) != null) {
            object3 = this.getBoxBase(element4, null);
            this.textColor = ((BoxBase)object3).textColor;
            int n9 = 0;
            while (n9 < 3) {
                element3 = JDomUtility.getChildWithId((Element)element4, (String)MSG_AREA, (String)Skin.msgAreaNames[n9]);
                if (element3 != null) {
                    this.msgAreaRect[n9] = JDomUtility.getRectangle((Element)element3, null, null);
                    boxBase = this.getBoxBase(element3, (BoxBase)object3);
                    boxBase.textMargin = 0;
                    this.msgArea[n9] = new ActiveBox(null, this, 0, this.msgAreaRect[n9], boxBase);
                    object2 = new ActiveBoxContent();
                    ((ActiveBoxContent)object2).setBoxBase(boxBase);
                    ((ActiveBoxContent)object2).setTxtAlign(JDomUtility.getAlignment((Element)element3, null, null));
                    this.msgArea[n9].setContent((ActiveBoxContent)object2);
                }
                ++n9;
            }
        }
        if ((element4 = element.getChild(BUTTONS)) != null) {
            element3 = element4.getChild(SETTINGS);
            object3 = JDomUtility.getDimension((Element)element3, null, (Dimension)new Dimension());
            Point point = JDomUtility.getOffset((Element)element3, (String)ACTIVE, null);
            object2 = JDomUtility.getOffset((Element)element3, (String)OVER, null);
            Point point2 = JDomUtility.getOffset((Element)element3, (String)DISABLED, null);
            n2 = 0;
            while (n2 < 8) {
                element3 = JDomUtility.getChildWithId((Element)element4, (String)BUTTON, (String)Constants.ACTION_NAME[n2]);
                if (element3 != null) {
                    Point point3 = JDomUtility.getPoint((Element)element3, (String)POS, null);
                    n = JDomUtility.getBoolAttr((Element)element3, (String)TOGGLE, (boolean)false) ? 1 : 0;
                    if (point3 != null) {
                        element2 = element3.getChild(SETTINGS);
                        Dimension dimension = JDomUtility.getDimension((Element)element2, null, (Dimension)object3);
                        this.buttonsRect[n2] = new Rectangle(point3, dimension);
                        Point point4 = JDomUtility.getPoint((Element)element3, (String)SOURCE, null);
                        Point point5 = JDomUtility.getOffset((Element)element2, (String)ACTIVE, (Point)point);
                        object = JDomUtility.getOffset((Element)element2, (String)OVER, (Point)object2);
                        Point point6 = JDomUtility.getOffset((Element)element2, (String)DISABLED, (Point)point2);
                        this.buttons[n2] = this.createButton(n2, dimension, point4, point5, (Point)object, point6, n != 0);
                    }
                }
                ++n2;
            }
        }
        if ((element4 = element.getChild(COUNTERS)) != null) {
            element3 = element4.getChild(SETTINGS);
            object3 = JDomUtility.getDimension((Element)element3, (String)COUNTER, (Dimension)new Dimension());
            Dimension dimension = JDomUtility.getDimension((Element)element3, (String)LABEL, (Dimension)new Dimension());
            object2 = JDomUtility.getAlignment((Element)element3, (String)LABEL, null);
            BoxBase boxBase2 = this.getBoxBase(element4, null);
            element3 = element4.getChild(DIGITS);
            Dimension dimension2 = JDomUtility.getDimension((Element)element3, null, null);
            Point point = JDomUtility.getPoint((Element)element3, (String)SOURCE, null);
            n = 0;
            while (n < 3) {
                element3 = JDomUtility.getChildWithId((Element)element4, (String)COUNTER, (String)Constants.counterNames[n]);
                if (element3 != null) {
                    Point point7;
                    element2 = element4.getChild(SETTINGS);
                    boxBase = this.getBoxBase(element3, boxBase2);
                    boxBase.textMargin = 0;
                    Point point8 = JDomUtility.getPoint((Element)element3, (String)COUNTER, null);
                    if (point8 != null) {
                        Dimension dimension3 = JDomUtility.getDimension((Element)element2, (String)COUNTER, (Dimension)object3);
                        this.countersRect[n][0] = new Rectangle(point8, dimension3);
                        Element element5 = element3.getChild(DIGITS);
                        Dimension dimension4 = JDomUtility.getDimension((Element)element5, null, (Dimension)dimension2);
                        object = JDomUtility.getPoint((Element)element5, (String)SOURCE, (Point)point);
                        this.counters[n] = new Counter(null, this, this.countersRect[n][0], boxBase);
                        this.counters[n].setSource(this.img, (Point)object, dimension4);
                    }
                    if ((point7 = JDomUtility.getPoint((Element)element3, (String)LABEL, null)) != null) {
                        Dimension dimension5 = JDomUtility.getDimension((Element)element2, (String)LABEL, (Dimension)dimension);
                        this.countersRect[n][1] = new Rectangle(point7, dimension5);
                        this.countersLabel[n] = new ActiveBox(null, this, 0, this.countersRect[n][1], boxBase);
                        object = new ActiveBoxContent();
                        ((ActiveBoxContent)object).setBoxBase(boxBase);
                        ((ActiveBoxContent)object).setTxtAlign(JDomUtility.getAlignment((Element)element3, (String)LABEL, (int[])object2));
                        ((ActiveBoxContent)object).setTextContent(this.ps.getMsg("label_" + Constants.counterNames[n]));
                        this.countersLabel[n].setContent((ActiveBoxContent)object);
                    }
                }
                ++n;
            }
        }
        int n10 = 0;
        int n11 = 0;
        while (n11 < 3) {
            this.boxes[n10++] = this.counters[n11];
            this.boxes[n10++] = this.countersLabel[n11];
            ++n11;
        }
        int n12 = 0;
        while (n12 < 3) {
            this.boxes[n10++] = this.msgArea[n12];
            ++n12;
        }
        this.boxes[n10++] = this.msgBox;
        this.boxes[n10++] = this.progressAnimation;
        this.initiated = 1;
    }

    protected BoxBase getBoxBase(Element element, BoxBase boxBase) throws Exception {
        Element element2;
        if (element == null || (element2 = element.getChild(STYLE)) == null) {
            return boxBase;
        }
        BoxBase boxBase2 = boxBase == null ? new BoxBase() : BoxBase.getBoxBase(boxBase.getJDomElement());
        Element element3 = element2.getChild("font");
        if (element3 != null) {
            boxBase2.setFont(JDomUtility.elementToFont((Element)element3));
        }
        boxBase2.textColor = JDomUtility.getColorByPoint((Element)element2, (String)FOREGROUND, (BufferedImage)this.img, (Color)boxBase2.textColor);
        boxBase2.backColor = JDomUtility.getColorByPoint((Element)element2, (String)BACKGROUND, (BufferedImage)this.img, (Color)boxBase2.backColor);
        boxBase2.transparent = boxBase2.backColor == BoxBase.DEFAULT_BACK_COLOR ? true : JDomUtility.getBoolAttr((Element)element2, (String)"transparent", (boolean)boxBase2.transparent);
        boxBase2.textMargin = JDomUtility.getIntAttr((Element)element2, (String)"margin", (int)boxBase2.textMargin);
        return boxBase2;
    }

    public void doLayout() {
        if (this.initiated < 1) {
            this.invalidate();
            return;
        }
        super.doLayout();
        if (this.player != null) {
            this.player.setBounds(this.translateRect(this.playerRect));
        }
        if (this.progressBar != null) {
            this.progressBar.setBounds(this.translateRect(this.progressBarRect));
        }
        int n = 0;
        while (n < this.buttons.length) {
            if (this.buttons[n] != null) {
                this.buttons[n].setBounds(this.translateRect(this.buttonsRect[n]));
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < 3) {
            if (this.counters[n2] != null) {
                this.counters[n2].setLocation(this.translatePoint(this.countersRect[n2][0].getLocation()));
            }
            if (this.countersLabel[n2] != null) {
                this.countersLabel[n2].setLocation(this.translatePoint(this.countersRect[n2][1].getLocation()));
            }
            ++n2;
        }
        if (this.msgBox != null) {
            this.msgBox.setBounds(this.translateRect(this.msgRect));
        }
        if (this.progressAnimation != null) {
            this.progressAnimation.setBounds(this.translateRect(this.progressAnimationRect));
        }
        int n3 = 0;
        while (n3 < 3) {
            if (this.msgArea[n3] != null) {
                this.msgArea[n3].setBounds(this.translateRect(this.msgAreaRect[n3]));
            }
            ++n3;
        }
        if (this.player != null) {
            this.initiated = 2;
        }
    }

    public void startAnimation() {
        if (this.progressAnimation != null) {
            if (this.hideProgressAnim) {
                this.progressAnimation.setStartDelay(1000);
            }
            this.progressAnimation.start();
        }
    }

    public void stopAnimation() {
        if (this.progressAnimation != null) {
            if (this.hideProgressAnim) {
                this.progressAnimation.setVisible(false);
            }
            this.progressAnimation.stop(false);
        }
    }

    public void render(Graphics2D graphics2D, Rectangle rectangle) {
        if (this.player == null || this.initiated < 2) {
            return;
        }
        if (!this.readyToPaint) {
            this.readyToPaint = true;
        }
        if (this.counters != null) {
            int n = 0;
            while (n < 3) {
                if (this.counters[n] != null && this.counters[n].equals(rectangle)) {
                    Utils.drawImage(graphics2D, this.img, this.counters[n].getBounds(), this.countersRect[n][0], this);
                    this.counters[n].update(graphics2D, rectangle, this);
                    return;
                }
                ++n;
            }
        }
        this.drawSlicedFrame(graphics2D, this.getBounds(), this.frame, this.img, this.leftSlicer, this.rightSlicer, this.topSlicer, this.bottomSlicer);
        if (this.boxes != null) {
            int n = 0;
            while (n < 11) {
                if (this.boxes[n] != null) {
                    this.boxes[n].update(graphics2D, rectangle, this);
                    if (this.boxes[n].equals(rectangle)) {
                        return;
                    }
                }
                ++n;
            }
        }
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this.ps != null && this.countersLabel != null) {
            int n = 0;
            while (n < 3) {
                if (this.countersLabel[n] != null) {
                    this.countersLabel[n].setTextContent(this.ps.getMsg("label_" + Constants.counterNames[n]));
                }
                ++n;
            }
        }
    }

    protected AbstractButton createButton(int n, Dimension dimension, Point point, Point point2, Point point3, Point point4, boolean bl) {
        AbstractButton abstractButton;
        Object object;
        Action action = this.ps.getAction(n);
        if (point != null) {
            object = new ImageIcon(this.img.getSubimage(point.x, point.y, dimension.width, dimension.height));
            abstractButton = !bl ? new JButton(action) : new JToggleButton(action);
            abstractButton.setIcon((Icon)object);
            abstractButton.setText(null);
            if (point2 != null) {
                object = new ImageIcon(this.img.getSubimage(point.x + point2.x, point.y + point2.y, dimension.width, dimension.height));
                if (!bl) {
                    abstractButton.setPressedIcon((Icon)object);
                } else {
                    abstractButton.setSelectedIcon((Icon)object);
                }
            }
            if (point3 != null) {
                object = new ImageIcon(this.img.getSubimage(point.x + point3.x, point.y + point3.y, dimension.width, dimension.height));
                abstractButton.setRolloverIcon((Icon)object);
            }
            if (point4 != null) {
                object = new ImageIcon(this.img.getSubimage(point.x + point4.x, point.y + point4.y, dimension.width, dimension.height));
                abstractButton.setDisabledIcon((Icon)object);
            }
            abstractButton.setFocusPainted(false);
            abstractButton.setBorderPainted(false);
            abstractButton.setBorder(new EmptyBorder(0, 0, 0, 0));
            abstractButton.setContentAreaFilled(false);
            abstractButton.setMargin(new Insets(0, 0, 0, 0));
        } else {
            abstractButton = new JButton(action);
        }
        abstractButton.setPreferredSize(this.buttonsRect[n].getSize());
        abstractButton.setVisible(true);
        if (bl) {
            object = action.getValue("Default");
            abstractButton.setSelected(object != null && object.equals(Boolean.FALSE));
            action.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("selected")) {
                        abstractButton.setSelected(propertyChangeEvent.getNewValue().equals(Boolean.FALSE));
                    }
                }
            });
        }
        this.add(abstractButton);
        return abstractButton;
    }

    Point translatePoint(Point point) {
        Rectangle rectangle = this.getBounds();
        Dimension dimension = new Dimension(rectangle.width - this.frame.width, rectangle.height - this.frame.height);
        Point point2 = new Point(point);
        if (point.x > this.rightSlicer) {
            point2.x += dimension.width;
        }
        if (point.y > this.bottomSlicer) {
            point2.y += dimension.height;
        }
        return point2;
    }

    Rectangle translateRect(Rectangle rectangle) {
        Rectangle rectangle2 = this.getBounds();
        Dimension dimension = new Dimension(rectangle2.width - this.frame.width, rectangle2.height - this.frame.height);
        Rectangle rectangle3 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (rectangle.x > this.rightSlicer) {
            rectangle3.x += dimension.width;
        } else if (rectangle.x + rectangle.width > this.leftSlicer) {
            rectangle3.width += dimension.width;
        }
        if (rectangle.y > this.bottomSlicer) {
            rectangle3.y += dimension.height;
        } else if (rectangle.y + rectangle.height > this.topSlicer) {
            rectangle3.height += dimension.height;
        }
        return rectangle3;
    }

    public void setProgressMax(int n) {
        super.setProgressMax(n);
        if (this.progressBar != null) {
            this.progressBar.setMaximum(n);
        }
    }

    public void setProgressValue(int n) {
        super.setProgressValue(n);
        if (this.progressBar != null) {
            this.progressBar.setValue(n);
            if (!this.progressBar.isVisible() && System.currentTimeMillis() - this.progressStartTime >= 1000L) {
                this.progressBar.setVisible(true);
            }
        }
    }

    public void endProgress() {
        super.endProgress();
        if (this.progressBar != null && this.hideProgressBar) {
            this.progressBar.setVisible(false);
        }
    }
}

