/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.project;

import edu.xtec.jclic.project.Author;
import edu.xtec.util.Domable;
import edu.xtec.util.Html;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.Messages;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.jdom.Content;
import org.jdom.Element;

public class Revision
implements Domable {
    public Date date;
    public Author[] authors;
    public String description;
    public String comments;
    public static final String ELEMENT_NAME = "revision";
    public static final String DATE = "date";
    public static final String DESCRIPTION = "description";
    public static final String COMMENTS = "comments";

    public Revision() {
        this.date = new Date();
        this.description = new String();
        this.comments = null;
    }

    public Revision(Date date, String string) {
        this.date = date;
        this.description = string;
        this.authors = null;
        this.comments = null;
    }

    public Element getJDomElement() {
        Element element = new Element(ELEMENT_NAME);
        element.setAttribute(DESCRIPTION, this.description);
        element.setAttribute(DATE, JDomUtility.dateToStringShortUS((Date)this.date));
        if (this.comments != null) {
            JDomUtility.addParagraphs((Element)element, (String)COMMENTS, (String)this.comments);
        }
        if (this.authors != null) {
            int n = 0;
            while (n < this.authors.length) {
                element.addContent((Content)this.authors[n].getJDomElement());
                ++n;
            }
        }
        return element;
    }

    public static Revision getRevision(Element element) throws Exception {
        Revision revision = new Revision();
        revision.setProperties(element, null);
        return revision;
    }

    public void setProperties(Element element, Object object) throws Exception {
        JDomUtility.checkName((Element)element, (String)ELEMENT_NAME);
        this.description = JDomUtility.getStringAttr((Element)element, (String)DESCRIPTION, (String)this.description, (boolean)true);
        this.date = JDomUtility.getDateAttrShortUS((Element)element, (String)DATE, (Date)this.date);
        this.comments = JDomUtility.getParagraphs((Element)element.getChild(COMMENTS));
        ArrayList<Author> arrayList = new ArrayList<Author>();
        Iterator iterator = element.getChildren("author").iterator();
        while (iterator.hasNext()) {
            arrayList.add(Author.getAuthor((Element)iterator.next()));
        }
        if (!arrayList.isEmpty()) {
            this.authors = arrayList.toArray(new Author[arrayList.size()]);
        }
    }

    public String toHtmlString(Messages messages) {
        Html html = new Html(300);
        html.bold(messages.getShortDateStr(this.date));
        if (this.description != null) {
            html.append("<B>: ").appendParagraphs(this.description).append("</B>");
        }
        if (this.authors != null) {
            int n = 0;
            while (n < this.authors.length) {
                html.br().append(this.authors[n].toHtmlString(messages));
                ++n;
            }
        }
        if (this.comments != null && this.comments.length() > 0) {
            html.br().appendParagraphs(this.comments);
        }
        return html.toString();
    }

    public String toString() {
        DateFormat dateFormat = DateFormat.getDateInstance(3);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(dateFormat.format(this.date)).append(" - ");
        if (this.description != null && this.description.length() > 0) {
            stringBuffer.append(this.description);
        }
        return stringBuffer.substring(0);
    }
}

