/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.project;

import edu.xtec.jclic.edit.Editable;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.media.EventSounds;
import edu.xtec.jclic.project.Author;
import edu.xtec.jclic.project.Organization;
import edu.xtec.jclic.project.Revision;
import edu.xtec.util.Domable;
import edu.xtec.util.Html;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.Messages;
import edu.xtec.util.StrUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import org.jdom.Content;
import org.jdom.Element;

public class ProjectSettings
implements Editable,
Domable {
    public String title = UNTITLED;
    public String iconFileName = null;
    public String description = null;
    public String descriptors = null;
    public String area = null;
    public String level = null;
    public Locale locale = null;
    public String[] languages = null;
    public Author[] authors = null;
    public Organization[] organizations = null;
    public Revision[] revisions = new Revision[]{new Revision(new Date(), "created")};
    public String skinFileName = null;
    public EventSounds eventSounds = new EventSounds(null);
    public static String UNTITLED = "untitled";
    public static String ELEMENT_NAME = "settings";
    public static String TITLE = "title";
    public static String LOCALE = "locale";
    public static String LANGUAGE = "language";
    public static String DESCRIPTION = "description";
    public static String DESCRIPTORS = "descriptors";
    public static String SKIN = "skin";
    public static String FILE = "file";
    public static String AREA = "area";
    public static String LEVEL = "level";
    public static String ICON = "icon";

    public Element getJDomElement() {
        Element element = new Element(ELEMENT_NAME);
        element.addContent((Content)new Element(TITLE).setText(this.title));
        if (this.revisions != null) {
            int n = 0;
            while (n < this.revisions.length) {
                element.addContent((Content)this.revisions[n].getJDomElement());
                ++n;
            }
        }
        if (this.authors != null) {
            int n = 0;
            while (n < this.authors.length) {
                element.addContent((Content)this.authors[n].getJDomElement());
                ++n;
            }
        }
        if (this.organizations != null) {
            int n = 0;
            while (n < this.organizations.length) {
                element.addContent((Content)this.organizations[n].getJDomElement());
                ++n;
            }
        }
        if (this.languages != null) {
            int n = 0;
            while (n < this.languages.length) {
                element.addContent((Content)new Element(LANGUAGE).setText(this.languages[n]));
                ++n;
            }
        }
        if (this.locale != null) {
            StringBuffer stringBuffer = new StringBuffer(this.locale.getLanguage());
            if (this.locale.getCountry() != null && this.locale.getCountry().length() > 0) {
                stringBuffer.append('-').append(this.locale.getCountry());
                if (this.locale.getVariant() != null && this.locale.getVariant().length() > 0) {
                    stringBuffer.append('-').append(this.locale.getVariant());
                }
            }
            element.setAttribute(LOCALE, stringBuffer.substring(0));
        }
        if (this.description != null) {
            JDomUtility.addParagraphs((Element)element, (String)DESCRIPTION, (String)this.description);
        }
        Element element2 = new Element(DESCRIPTORS);
        if (this.area != null) {
            element2.setAttribute(AREA, this.area);
        }
        if (this.level != null) {
            element2.setAttribute(LEVEL, this.level);
        }
        if (this.descriptors != null) {
            element2.setText(this.descriptors);
        }
        element.addContent((Content)element2);
        element2 = this.eventSounds.getJDomElement();
        if (element2 != null) {
            element.addContent((Content)element2);
        }
        if (this.skinFileName != null) {
            element2 = new Element(SKIN);
            element2.setAttribute(FILE, this.skinFileName);
            element.addContent((Content)element2);
        }
        if (this.iconFileName != null) {
            element2 = new Element(ICON);
            element2.setAttribute(FILE, this.iconFileName);
            element.addContent((Content)element2);
        }
        return element;
    }

    public static ProjectSettings getProjectSettings(Element element) throws Exception {
        ProjectSettings projectSettings = new ProjectSettings();
        projectSettings.setProperties(element, null);
        return projectSettings;
    }

    public void setProperties(Element element, Object object) throws Exception {
        String string;
        JDomUtility.checkName((Element)element, (String)ELEMENT_NAME);
        Element element2 = element.getChild(TITLE);
        if (element2 != null) {
            this.title = element2.getText();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = element.getChildren("revision").iterator();
        while (iterator.hasNext()) {
            arrayList.add(Revision.getRevision((Element)iterator.next()));
        }
        if (!arrayList.isEmpty()) {
            this.revisions = arrayList.toArray(new Revision[arrayList.size()]);
        }
        arrayList = new ArrayList();
        iterator = element.getChildren("author").iterator();
        while (iterator.hasNext()) {
            arrayList.add(Author.getAuthor((Element)iterator.next()));
        }
        if (!arrayList.isEmpty()) {
            this.authors = arrayList.toArray(new Author[arrayList.size()]);
        }
        arrayList = new ArrayList();
        iterator = element.getChildren("organization").iterator();
        while (iterator.hasNext()) {
            arrayList.add(Organization.getOrganization((Element)iterator.next()));
        }
        if (!arrayList.isEmpty()) {
            this.organizations = arrayList.toArray(new Organization[arrayList.size()]);
        }
        arrayList = new ArrayList();
        iterator = element.getChildren(LANGUAGE).iterator();
        while (iterator.hasNext()) {
            arrayList.add(((Element)iterator.next()).getText());
        }
        if (!arrayList.isEmpty()) {
            this.languages = arrayList.toArray(new String[arrayList.size()]);
        }
        if ((string = JDomUtility.getStringAttr((Element)element, (String)LOCALE, null, (boolean)false)) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
            String string2 = null;
            String string3 = null;
            String string4 = null;
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
            }
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
            }
            if (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
            }
            if (string2 != null && string3 != null) {
                this.locale = string4 != null ? new Locale(string2, string3, string4) : new Locale(string2, string3);
            }
        }
        this.description = JDomUtility.getParagraphs((Element)element.getChild(DESCRIPTION));
        element2 = element.getChild(DESCRIPTORS);
        if (element2 != null) {
            if (!element2.getChildren("p").isEmpty()) {
                this.descriptors = JDomUtility.getParagraphs((Element)element.getChild(DESCRIPTORS));
                this.descriptors = StrUtils.replace((String)this.descriptors, (String)"\n", (String)", ");
            } else {
                this.descriptors = StrUtils.nullableString((Object)element2.getTextNormalize());
            }
            this.area = JDomUtility.getStringAttr((Element)element2, (String)AREA, (String)this.area, (boolean)false);
            this.level = JDomUtility.getStringAttr((Element)element2, (String)LEVEL, (String)this.level, (boolean)false);
        }
        if ((element2 = element.getChild("eventSounds")) != null) {
            this.eventSounds = EventSounds.getEventSounds(element2);
        }
        if ((element2 = element.getChild(SKIN)) != null) {
            this.skinFileName = JDomUtility.getStringAttr((Element)element2, (String)FILE, (String)this.skinFileName, (boolean)false);
        }
        if ((element2 = element.getChild(ICON)) != null) {
            this.iconFileName = JDomUtility.getStringAttr((Element)element2, (String)FILE, (String)this.iconFileName, (boolean)false);
        }
    }

    public String toHtmlString(Messages messages) {
        int n;
        int n2;
        String string = "about_window_lb_";
        Html html = new Html(1000);
        html.doubleCell(messages.get(string + "project"), true, this.title, true);
        if (this.area != null) {
            html.doubleCell(messages.get(string + "area"), true, this.area, false);
        }
        if (this.level != null) {
            html.doubleCell(messages.get(string + "level"), true, this.level, false);
        }
        if (this.authors != null) {
            n2 = this.authors.length;
            html.tr(true).td(messages.get(string + "author" + (n2 > 1 ? "s" : "")), true).td(true);
            n = 0;
            while (n < n2) {
                if (this.authors[n] != null) {
                    html.append(this.authors[n].toHtmlString(messages)).br();
                }
                ++n;
            }
            html.td(false).tr(false);
        }
        if (this.organizations != null) {
            n2 = this.organizations.length;
            html.tr(true).td(messages.get(string + "organization" + (n2 > 1 ? "s" : "")), true).td(true);
            n = 0;
            while (n < this.organizations.length) {
                if (n > 0) {
                    html.nbsp().br();
                }
                if (this.organizations[n] != null) {
                    html.append(this.organizations[n].toHtmlString(messages)).br();
                }
                ++n;
            }
            html.td(false).tr(false);
        }
        if (this.revisions != null) {
            html.tr(true).td(messages.get(string + "history"), true).td(true);
            n2 = 0;
            while (n2 < this.revisions.length) {
                if (n2 > 0) {
                    html.nbsp().br();
                }
                if (this.revisions[n2] != null) {
                    html.append(this.revisions[n2].toHtmlString(messages)).br();
                }
                ++n2;
            }
            html.td(false).tr(false);
        }
        if (this.languages != null) {
            n2 = this.languages.length;
            html.tr(true).td(messages.get(string + "language" + (n2 > 1 ? "s" : "")), true).td(true);
            n = 0;
            while (n < n2) {
                if (this.languages[n] != null) {
                    html.append(this.languages[n]).sp();
                }
                ++n;
            }
            html.td(false).tr(false);
        }
        if (this.description != null) {
            html.doubleCell(messages.get(string + "description"), true, this.description, false);
        }
        if (this.descriptors != null) {
            html.doubleCell(messages.get(string + "descriptors"), true, this.descriptors, false);
        }
        return Html.table((String)html.toString(), null, (int)1, (int)5, (int)-1, null, (boolean)false);
    }

    public Editor getEditor(Editor editor) {
        return Editor.createEditor(this.getClass().getName() + "Editor", this, editor);
    }
}

