/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.misc;

import edu.xtec.jclic.Constants;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.SimpleFileFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import javax.swing.ImageIcon;

public abstract class Utils
implements Constants {
    public static final int JCLIC_FF = 0;
    public static final int JCLIC_ZIP_FF = 1;
    public static final int PAC_FF = 2;
    public static final int PCC_FF = 3;
    public static final int ALL_JCLIC_FF = 4;
    public static final int ALL_CLIC_FF = 5;
    public static final int ALL_JCLIC_CLIC_FF = 6;
    public static final int INSTALL_FF = 7;
    public static final int GIF_FF = 8;
    public static final int JPG_FF = 9;
    public static final int PNG_FF = 10;
    public static final int ALL_IMAGES_FF = 11;
    public static final int ALL_FF = 12;
    public static final int ALL_SOUNDS_FF = 13;
    public static final int MIDI_FF = 14;
    public static final int ALL_VIDEO_FF = 15;
    public static final int ALL_ANIM_FF = 16;
    public static final int SKINS_FF = 17;
    public static final int FONTS_FF = 18;
    public static final int ALL_MEDIA_FF = 19;
    public static final int ALL_MULTIMEDIA_FF = 20;
    public static final int ALL_HTML_FF = 21;
    public static final int NUM_FILE_FILTERS = 22;
    private static SimpleFileFilter[] fileFilters = new SimpleFileFilter[22];
    public static final String EXT_JCLIC = ".jclic";
    public static final String EXT_JCLIC_ZIP = ".jclic.zip";
    public static final String EXT_PAC = ".pac";
    public static final String EXT_PCC = ".pcc";
    public static final String EXT_INSTALL = ".jclic.inst";
    public static final String EXT_GIF = ".gif";
    public static final String EXT_JPG = ".jpg";
    public static final String EXT_PNG = ".png";
    public static final String EXT_BMP = ".bmp";
    public static final String EXT_WAV = ".wav";
    public static final String EXT_AU = ".au";
    public static final String EXT_MP3 = ".mp3";
    public static final String EXT_AIFF = ".aiff";
    public static final String EXT_MID = ".mid";
    public static final String EXT_OGG = ".ogg";
    public static final String EXT_AVI = ".avi";
    public static final String EXT_MOV = ".mov";
    public static final String EXT_MPEG = ".mpeg";
    public static final String EXT_SWF = ".swf";
    public static final String EXT_XML = ".xml";
    public static final String EXT_TTF = ".ttf";
    public static final String EXT_HTM = ".htm";
    public static final String EXT_HTML = ".html";
    public static final String EXT_ALL = ".*";
    public static final String[] EXT_ALL_JCLIC = new String[]{".jclic", ".jclic.zip"};
    public static final String[] EXT_ALL_CLIC = new String[]{".pac", ".pcc"};
    public static final String[] EXT_ALL_JCLIC_CLIC = new String[]{".jclic", ".jclic.zip", ".pac", ".pcc"};
    public static final String[] EXT_ALL_IMAGES = new String[]{".gif", ".jpg", ".png", ".bmp"};
    public static final String[] EXT_ALL_SOUNDS = new String[]{".wav", ".au", ".mp3", ".ogg", ".aiff"};
    public static final String[] EXT_ALL_VIDEO = new String[]{".avi", ".mov", ".mpeg", ".swf"};
    public static final String[] EXT_ALL_ANIM = new String[]{".swf"};
    public static final String[] EXT_ALL_MEDIA = new String[]{".gif", ".jpg", ".png", ".wav", ".au", ".mp3", ".ogg", ".aiff", ".mid", ".avi", ".mov", ".mpeg", ".swf", ".ttf", ".xml"};
    public static final String[] EXT_ALL_MULTIMEDIA = new String[]{".wav", ".au", ".mp3", ".ogg", ".aiff", ".mid", ".avi", ".mov", ".mpeg", ".swf"};
    public static final String[] EXT_ALL_HTML = new String[]{".htm", ".html"};
    public static final int TYPE_IMAGE = 0;
    public static final int TYPE_AUDIO = 1;
    public static final int TYPE_MIDI = 2;
    public static final int TYPE_VIDEO = 3;
    public static final int TYPE_ANIM = 4;
    public static final int TYPE_XML = 5;
    public static final int TYPE_FONT = 6;
    public static final int TYPE_JCLIC = 7;
    public static final int TYPE_CLIC = 8;
    public static final int TYPE_INST = 9;
    public static final int TYPE_UNKNOWN = 10;
    public static final String[] TYPE_CODES = new String[]{"ftype_image", "ftype_audio", "ftype_midi", "ftype_video", "ftype_anim", "ftype_xml", "ftype_font", "ftype_jclic", "ftype_clic", "ftype_inst", "ftype_unknown"};
    public static final int[] T_CODES = new int[]{16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384};

    public static final int getFileType(String string) {
        int n;
        int n2 = 10;
        if (string != null && (n = string.lastIndexOf(46)) > 0) {
            String string2;
            if (string.substring(0, n).toLowerCase().endsWith(EXT_JCLIC)) {
                n -= 6;
            }
            if ((string2 = string.substring(n).toLowerCase()).equals(EXT_GIF) || string2.equals(EXT_JPG) || string2.equals(EXT_PNG) || string2.equals(EXT_BMP)) {
                n2 = 0;
            } else if (string2.equals(EXT_WAV) || string2.equals(EXT_AU) || string2.equals(EXT_MP3) || string2.equals(EXT_OGG) || string2.equals(EXT_AIFF)) {
                n2 = 1;
            } else if (string2.equals(EXT_MID)) {
                n2 = 2;
            } else if (string2.equals(EXT_AVI) || string2.equals(EXT_MOV) || string2.equals(EXT_MPEG)) {
                n2 = 3;
            } else if (string2.equals(EXT_SWF)) {
                n2 = 4;
            } else if (string2.equals(EXT_XML)) {
                n2 = 5;
            } else if (string2.equals(EXT_TTF)) {
                n2 = 6;
            } else if (string2.equals(EXT_JCLIC) || string2.equals(EXT_JCLIC_ZIP)) {
                n2 = 7;
            } else if (string2.equals(EXT_PAC) || string2.equals(EXT_PCC)) {
                n2 = 8;
            } else if (string2.equals(EXT_INSTALL)) {
                n2 = 9;
            }
        }
        return n2;
    }

    public static ImageIcon getFileIcon(String string) {
        String string2 = "icons/icounknown.png";
        switch (Utils.getFileType(string)) {
            case 1: {
                string2 = "icons/icowave.png";
                break;
            }
            case 2: {
                string2 = "icons/icomidi.png";
                break;
            }
            case 3: 
            case 4: {
                string2 = "icons/icomci.png";
                break;
            }
            case 6: {
                string2 = "icons/icottf.png";
                break;
            }
            case 5: {
                string2 = "icons/icoxml.png";
            }
        }
        return ResourceManager.getImageIcon((String)string2);
    }

    public static int getFileFilterCode(String string) {
        int n = 12;
        switch (Utils.getFileType(string)) {
            case 0: {
                n = 11;
                break;
            }
            case 1: {
                n = 13;
                break;
            }
            case 2: {
                n = 14;
                break;
            }
            case 3: {
                n = 15;
                break;
            }
            case 4: {
                n = 16;
                break;
            }
            case 5: {
                n = 17;
                break;
            }
            case 6: {
                n = 18;
                break;
            }
            case 7: {
                n = 4;
                break;
            }
            case 8: {
                n = 5;
                break;
            }
            case 9: {
                n = 7;
            }
        }
        return n;
    }

    public static SimpleFileFilter getFileFilter(int n, Messages messages) {
        if (n < 0 || n >= 22) {
            return null;
        }
        if (fileFilters[n] == null) {
            switch (n) {
                case 0: {
                    Utils.fileFilters[n] = new SimpleFileFilter(EXT_JCLIC, messages.get("filefilter_jclic"));
                    break;
                }
                case 1: {
                    Utils.fileFilters[n] = new SimpleFileFilter(EXT_JCLIC_ZIP, messages.get("filefilter_jclic_zip"));
                    break;
                }
                case 2: {
                    Utils.fileFilters[n] = new SimpleFileFilter(EXT_PAC, messages.get("filefilter_pac"));
                    break;
                }
                case 3: {
                    Utils.fileFilters[n] = new SimpleFileFilter(EXT_PCC, messages.get("filefilter_pcc"));
                    break;
                }
                case 4: {
                    Utils.fileFilters[n] = new SimpleFileFilter(EXT_ALL_JCLIC, messages.get("filefilter_all_jclic"));
                    break;
                }
                case 5: {
                    Utils.fileFilters[n] = new SimpleFileFilter(EXT_ALL_CLIC, messages.get("filefilter_all_clic"));
                    break;
                }
                case 6: {
                    Utils.fileFilters[n] = new SimpleFileFilter(EXT_ALL_JCLIC_CLIC, messages.get("filefilter_all_jclic_clic"));
                    break;
                }
                case 7: {
                    Utils.fileFilters[n] = new SimpleFileFilter(EXT_INSTALL, messages.get("filefilter_install"));
                    break;
                }
                case 8: {
                    Utils.fileFilters[n] = new SimpleFileFilter(EXT_GIF, messages.get("filefilter_gif"));
                    break;
                }
                case 9: {
                    Utils.fileFilters[n] = new SimpleFileFilter(EXT_JPG, messages.get("filefilter_jpg"));
                    break;
                }
                case 10: {
                    Utils.fileFilters[n] = new SimpleFileFilter(EXT_PNG, messages.get("filefilter_png"));
                    break;
                }
                case 11: {
                    Utils.fileFilters[n] = new SimpleFileFilter(EXT_ALL_IMAGES, messages.get("filefilter_all_images"));
                    break;
                }
                case 13: {
                    Utils.fileFilters[n] = new SimpleFileFilter(EXT_ALL_SOUNDS, messages.get("filefilter_all_sounds"));
                    break;
                }
                case 14: {
                    Utils.fileFilters[n] = new SimpleFileFilter(EXT_MID, messages.get("filefilter_midi"));
                    break;
                }
                case 15: {
                    Utils.fileFilters[n] = new SimpleFileFilter(EXT_ALL_VIDEO, messages.get("filefilter_all_video"));
                    break;
                }
                case 16: {
                    Utils.fileFilters[n] = new SimpleFileFilter(EXT_ALL_ANIM, messages.get("filefilter_all_anim"));
                    break;
                }
                case 17: {
                    Utils.fileFilters[n] = new SimpleFileFilter(EXT_XML, messages.get("filefilter_skins"));
                    break;
                }
                case 18: {
                    Utils.fileFilters[n] = new SimpleFileFilter(EXT_TTF, messages.get("filefilter_fonts"));
                    break;
                }
                case 19: {
                    Utils.fileFilters[n] = new SimpleFileFilter(EXT_ALL_MEDIA, messages.get("filefilter_all_media"));
                    break;
                }
                case 20: {
                    Utils.fileFilters[n] = new SimpleFileFilter(EXT_ALL_MULTIMEDIA, messages.get("filefilter_all_media"));
                    break;
                }
                case 21: {
                    Utils.fileFilters[n] = new SimpleFileFilter(EXT_ALL_HTML, messages.get("filefilter_all_html"));
                    break;
                }
                case 12: {
                    Utils.fileFilters[n] = new SimpleFileFilter(EXT_ALL, messages.get("filefilter_all"));
                }
            }
        }
        return fileFilters[n];
    }

    public static String[] getFileFilterExtensions(int n) {
        String[] stringArray = null;
        if (n >= 0 && n < 22) {
            switch (n) {
                case 0: {
                    stringArray = new String[]{EXT_JCLIC};
                    break;
                }
                case 1: {
                    stringArray = new String[]{EXT_JCLIC_ZIP};
                    break;
                }
                case 2: {
                    stringArray = new String[]{EXT_PAC};
                    break;
                }
                case 3: {
                    stringArray = new String[]{EXT_PCC};
                    break;
                }
                case 4: {
                    stringArray = EXT_ALL_JCLIC;
                    break;
                }
                case 5: {
                    stringArray = EXT_ALL_CLIC;
                    break;
                }
                case 6: {
                    stringArray = EXT_ALL_JCLIC_CLIC;
                    break;
                }
                case 7: {
                    stringArray = new String[]{EXT_INSTALL};
                    break;
                }
                case 8: {
                    stringArray = new String[]{EXT_GIF};
                    break;
                }
                case 9: {
                    stringArray = new String[]{EXT_JPG};
                    break;
                }
                case 10: {
                    stringArray = new String[]{EXT_PNG};
                    break;
                }
                case 11: {
                    stringArray = EXT_ALL_IMAGES;
                    break;
                }
                case 13: {
                    stringArray = EXT_ALL_SOUNDS;
                    break;
                }
                case 14: {
                    stringArray = new String[]{EXT_MID};
                    break;
                }
                case 15: {
                    stringArray = EXT_ALL_VIDEO;
                    break;
                }
                case 16: {
                    stringArray = EXT_ALL_ANIM;
                    break;
                }
                case 17: {
                    stringArray = new String[]{EXT_XML};
                    break;
                }
                case 18: {
                    stringArray = new String[]{EXT_TTF};
                    break;
                }
                case 19: {
                    stringArray = EXT_ALL_MEDIA;
                    break;
                }
                case 20: {
                    stringArray = EXT_ALL_MULTIMEDIA;
                }
            }
        }
        return stringArray;
    }

    public static BufferedImage toBufferedImage(Image image, Color color, ImageObserver imageObserver) {
        int n = image.getWidth(imageObserver);
        int n2 = image.getHeight(imageObserver);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, color, imageObserver);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static void drawImage(Graphics graphics, Image image, Rectangle rectangle, Rectangle rectangle2, ImageObserver imageObserver) {
        if (graphics.getClip().intersects(rectangle)) {
            graphics.drawImage(image, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, rectangle2.x, rectangle2.y, rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height, imageObserver);
        }
    }

    public static void tileImage(Graphics graphics, Image image, Rectangle rectangle, Rectangle rectangle2, ImageObserver imageObserver) {
        if (graphics.getClip().intersects(rectangle)) {
            Area area = new Area(graphics.getClip());
            Area area2 = new Area(area);
            area2.intersect(new Area(rectangle));
            graphics.setClip(area2);
            Rectangle rectangle3 = new Rectangle(rectangle.x, rectangle.y, rectangle2.width, rectangle2.height);
            int n = 0;
            while (n < rectangle.height) {
                int n2 = 0;
                while (n2 < rectangle.width) {
                    rectangle3.setLocation(rectangle.x + n2, rectangle.y + n);
                    Utils.drawImage(graphics, image, rectangle3, rectangle2, imageObserver);
                    n2 += rectangle2.width;
                }
                n += rectangle2.height;
            }
            graphics.setClip(area);
        }
    }

    public static Point mapPointTo(Component component, Point point, Component component2) {
        Point point2 = new Point();
        try {
            point2 = new Point(component.getLocationOnScreen());
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
        point2.x += point.x;
        point2.y += point.y;
        Point point3 = new Point();
        try {
            point3 = component2.getLocationOnScreen();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
        point2.x -= point3.x;
        point2.y -= point3.y;
        return point2;
    }

    public static void refreshAnimatedImage(Image image) {
        if (image != null && (Toolkit.getDefaultToolkit().checkImage(image, -1, -1, null) & 0x20) != 0) {
            image.flush();
        }
    }

    public static void checkRenderingHints(Options options) {
        if (Constants.DEFAULT_RENDERING_HINTS.isEmpty()) {
            if (options == null) {
                options = new Options();
            }
            boolean bl = options.getBoolean("Mac");
            boolean bl2 = options.getBoolean("java14");
            boolean bl3 = options.getBoolean("Windows");
            if (bl3) {
                Constants.DEFAULT_RENDERING_HINTS.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            Constants.DEFAULT_RENDERING_HINTS.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            if (bl3) {
                Constants.DEFAULT_RENDERING_HINTS.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            }
            if (bl3) {
                Constants.DEFAULT_RENDERING_HINTS.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            }
            if (bl3) {
                Constants.DEFAULT_RENDERING_HINTS.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
        }
    }
}

