/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.bags.MediaBagElement;
import edu.xtec.jclic.edit.Editable;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.jclic.skins.Skin;
import edu.xtec.util.Domable;
import edu.xtec.util.ExtendedByteArrayInputStream;
import edu.xtec.util.FontCheck;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.StreamIO;
import java.awt.Font;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.jdom.Content;
import org.jdom.Element;

public class MediaBag
implements Editable,
Domable,
StreamIO.InputStreamProvider {
    protected JClicProject project;
    protected Vector elements;
    protected HashSet listeners;
    public static String ELEMENT_NAME = "mediaBag";

    public MediaBag(JClicProject jClicProject) {
        this.project = jClicProject;
        this.elements = new Vector(30);
        this.listeners = new HashSet(1);
    }

    public JClicProject getProject() {
        return this.project;
    }

    public Vector getElements() {
        return new Vector(this.elements);
    }

    public void clear() {
        this.elements.clear();
    }

    public Vector getElementsByName() {
        Vector vector = this.getElements();
        Collections.sort(vector, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((MediaBagElement)object).getName().compareToIgnoreCase(((MediaBagElement)object2).getName());
            }
        });
        return vector;
    }

    public Vector getElementsByType() {
        final StringBuffer stringBuffer = new StringBuffer(200);
        final StringBuffer stringBuffer2 = new StringBuffer(200);
        Vector vector = this.getElements();
        Collections.sort(vector, new Comparator(){

            public int compare(Object object, Object object2) {
                stringBuffer.setLength(0);
                MediaBagElement mediaBagElement = (MediaBagElement)object;
                String string = mediaBagElement.getFileName();
                String string2 = mediaBagElement.getName();
                int n = string.lastIndexOf(46);
                stringBuffer.append(n > 0 ? string.substring(n) : ".zzz");
                stringBuffer.append(string2);
                stringBuffer2.setLength(0);
                mediaBagElement = (MediaBagElement)object2;
                string = mediaBagElement.getFileName();
                string2 = mediaBagElement.getName();
                n = string.lastIndexOf(46);
                stringBuffer2.append(n > 0 ? string.substring(n) : ".zzz");
                stringBuffer2.append(string2);
                return stringBuffer.substring(0).compareToIgnoreCase(stringBuffer2.substring(0));
            }
        });
        return vector;
    }

    public Element getJDomElement() {
        Element element = new Element(ELEMENT_NAME);
        Iterator iterator = ((AbstractList)this.getElementsByType()).iterator();
        while (iterator.hasNext()) {
            element.addContent((Content)((MediaBagElement)iterator.next()).getJDomElement());
        }
        return element;
    }

    public void clearData() {
        Iterator iterator = ((AbstractList)this.elements).iterator();
        while (iterator.hasNext()) {
            MediaBagElement mediaBagElement = (MediaBagElement)iterator.next();
            if (mediaBagElement == null || mediaBagElement.getData() == null || mediaBagElement.getData() instanceof Font) continue;
            mediaBagElement.setData(null);
        }
    }

    public void setProperties(Element element, Object object) throws Exception {
        JDomUtility.checkName((Element)element, (String)ELEMENT_NAME);
        Iterator iterator = element.getChildren("media").iterator();
        while (iterator.hasNext()) {
            this.elements.add(MediaBagElement.getMediaBagElement((Element)iterator.next()));
        }
    }

    public boolean addElement(MediaBagElement mediaBagElement) {
        boolean bl;
        boolean bl2 = bl = mediaBagElement != null && this.getElement(mediaBagElement.getName()) == null;
        if (bl) {
            this.elements.add(mediaBagElement);
        }
        return bl;
    }

    public MediaBagElement getElement(String string) {
        MediaBagElement mediaBagElement = null;
        if (string != null) {
            int n = 0;
            while (n < this.elements.size()) {
                MediaBagElement mediaBagElement2 = (MediaBagElement)this.elements.get(n);
                if (string.equals(mediaBagElement2.getName())) {
                    mediaBagElement = mediaBagElement2;
                    break;
                }
                ++n;
            }
        }
        return mediaBagElement;
    }

    public MediaBagElement getElementByFileName(String string) {
        MediaBagElement mediaBagElement = null;
        if (string != null) {
            int n = 0;
            while (n < this.elements.size()) {
                MediaBagElement mediaBagElement2 = (MediaBagElement)this.elements.get(n);
                if (string.equals(mediaBagElement2.getFileName())) {
                    mediaBagElement = mediaBagElement2;
                    break;
                }
                ++n;
            }
        }
        return mediaBagElement;
    }

    public MediaBagElement registerElement(String string, String string2) {
        MediaBagElement mediaBagElement = this.getElement(string);
        if (mediaBagElement == null) {
            mediaBagElement = new MediaBagElement(FileSystem.stdFn(string2 == null ? string : string2), null, string);
            this.elements.add(mediaBagElement);
        }
        return mediaBagElement;
    }

    public boolean removeElement(MediaBagElement mediaBagElement) {
        return this.elements.remove(mediaBagElement);
    }

    public Object getMediaDataSource(String string) throws Exception {
        Object object = null;
        String string2 = this.project.getFileSystem().getCanonicalNameOf(string);
        MediaBagElement mediaBagElement = this.registerElement(string2, null);
        if (mediaBagElement != null) {
            if (mediaBagElement.getData() != null) {
                object = mediaBagElement.getData() instanceof ExtendedByteArrayInputStream ? ((ExtendedByteArrayInputStream)mediaBagElement.getData()).duplicate() : mediaBagElement.getData();
            } else {
                object = this.project.getFileSystem().getMediaDataSource(mediaBagElement.getFileName());
                mediaBagElement.setData(object);
            }
        }
        return object;
    }

    public InputStream getInputStream(String string) throws Exception {
        InputStream inputStream = null;
        String string2 = this.project.getFileSystem().getCanonicalNameOf(string);
        MediaBagElement mediaBagElement = this.registerElement(string2, null);
        if (mediaBagElement != null) {
            if (mediaBagElement.getData() instanceof ExtendedByteArrayInputStream) {
                ExtendedByteArrayInputStream extendedByteArrayInputStream = (ExtendedByteArrayInputStream)mediaBagElement.getData();
                mediaBagElement.setData(extendedByteArrayInputStream);
                inputStream = extendedByteArrayInputStream.duplicate();
            } else {
                inputStream = this.project.getFileSystem().getInputStream(mediaBagElement.getFileName());
                if (inputStream instanceof ExtendedByteArrayInputStream) {
                    mediaBagElement.setData(inputStream);
                }
            }
        }
        return inputStream;
    }

    public MediaBagElement getImageElement(String string) throws Exception {
        MediaBagElement mediaBagElement = null;
        String string2 = this.project.getFileSystem().getCanonicalNameOf(string);
        mediaBagElement = this.registerElement(string2, null);
        if (mediaBagElement != null) {
            mediaBagElement = mediaBagElement.prepareImage(this.project.getFileSystem()) ? mediaBagElement : null;
        }
        return mediaBagElement;
    }

    public void buildFonts() {
        String[] stringArray;
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        Iterator<Object> iterator = ((AbstractList)this.elements).iterator();
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            String string = stringArray.getName();
            if (stringArray == null || stringArray.getData() != null || !stringArray.getFileName().endsWith(".ttf")) continue;
            hashMap.put(string, stringArray);
        }
        if (!hashMap.isEmpty()) {
            stringArray = FontCheck.getFontList((boolean)false);
            int n = stringArray.length;
            iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                int n2 = 0;
                n2 = 0;
                while (n2 < n) {
                    if (stringArray[n2].equalsIgnoreCase(string)) break;
                    ++n2;
                }
                if (n2 != n) continue;
                MediaBagElement mediaBagElement = (MediaBagElement)hashMap.get(string);
                try {
                    mediaBagElement.setData(FontCheck.buildNewFont((String)mediaBagElement.getFileName(), (StreamIO.InputStreamProvider)this, (String)string));
                }
                catch (Exception exception) {
                    System.err.println("Unable to create font:\n" + exception);
                }
            }
        }
    }

    public Skin getSkinElement(String string, PlayStation playStation) {
        block7: {
            Skin skin = null;
            String string2 = string;
            if (string.startsWith("@")) {
                try {
                    return Skin.getSkin(string, this.project.getFileSystem(), playStation);
                }
                catch (Exception exception) {
                    System.err.println("Error loading skin \"" + string + "\":\n" + exception);
                    break block7;
                }
            }
            string2 = this.project.getFileSystem().getCanonicalNameOf(string);
            MediaBagElement mediaBagElement = this.registerElement(string2, null);
            if (mediaBagElement != null) {
                if (mediaBagElement.getData() == null || !(mediaBagElement.getData() instanceof Skin)) {
                    try {
                        skin = Skin.getSkin(mediaBagElement.getFileName(), this.project.getFileSystem(), playStation);
                        mediaBagElement.setData(skin);
                    }
                    catch (Exception exception) {
                        System.err.println("Error loading skin \"" + mediaBagElement.getFileName() + "\":\n" + exception);
                    }
                }
                return (Skin)mediaBagElement.getData();
            }
        }
        return null;
    }

    public boolean isWaitingForImages() {
        Iterator iterator = ((AbstractList)this.elements).iterator();
        while (iterator.hasNext()) {
            MediaBagElement mediaBagElement = (MediaBagElement)iterator.next();
            if (mediaBagElement == null || !mediaBagElement.isWaitingForImage()) continue;
            return true;
        }
        return false;
    }

    public void waitForAllImages() {
        while (this.isWaitingForImages()) {
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                System.err.println("error waiting for images!\n" + exception);
                return;
            }
        }
    }

    public Editor getEditor(Editor editor) {
        return Editor.createEditor(this.getClass().getName() + "Editor", this, editor);
    }

    public void addListener(Listener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void listReferencesTo(String string, String string2, HashMap hashMap) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((Listener)iterator.next()).listReferencesTo(string, string2, hashMap);
        }
    }

    public static interface Listener {
        public void listReferences(String var1, HashMap var2);

        public void listReferencesTo(String var1, String var2, HashMap var3);
    }
}

