/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.SwingWorker;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;

public class StreamIO {
    private static boolean cancel = false;
    public static final int DEFAULT_READ_STEP_SIZE = 4096;

    private StreamIO() {
    }

    public static void setCancel(boolean bl) {
        cancel = bl;
    }

    public static byte[] readInputStream(InputStream inputStream) throws IOException {
        return StreamIO.readInputStream(inputStream, null, 4096);
    }

    public static byte[] readInputStream(InputStream inputStream, InputStreamListener inputStreamListener, int n) throws IOException {
        cancel = false;
        BufferedInputStream bufferedInputStream = null;
        bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (!cancel) {
            n2 = bufferedInputStream.read(byArray);
            if (inputStreamListener != null) {
                inputStreamListener.notify(inputStream, n2);
            }
            if (n2 <= 0) break;
            byteArrayOutputStream.write(byArray, 0, n2);
            Thread.yield();
        }
        byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        bufferedInputStream.close();
        if (cancel) {
            throw new InterruptedIOException("Cancelled by user");
        }
        return byArray;
    }

    public static byte[] readFile(File file) throws IOException {
        return StreamIO.readFile(file, null, 0);
    }

    public static byte[] readFile(File file, InputStreamListener inputStreamListener, int n) throws IOException {
        cancel = false;
        long l = file.length();
        if (l > Integer.MAX_VALUE) {
            throw new IOException();
        }
        int n2 = (int)l;
        byte[] byArray = new byte[n2];
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        int n3 = 0;
        int n4 = 0;
        while ((long)n4 < l && !cancel) {
            int n5 = n2 - n4;
            if (n > 0 && n < n5) {
                n5 = n;
            }
            if ((n3 = bufferedInputStream.read(byArray, n4, n5)) < 0) break;
            if (inputStreamListener != null) {
                inputStreamListener.notify(bufferedInputStream, n3);
            }
            Thread.yield();
            n4 += n3;
        }
        bufferedInputStream.close();
        if (cancel) {
            throw new InterruptedIOException("Cancelled by user");
        }
        return byArray;
    }

    public static byte[] getResourceBytes(Object object, String string, String string2) throws IOException {
        return StreamIO.readInputStream(object.getClass().getResourceAsStream(string + "/" + string2));
    }

    public static void writeStreamTo(InputStream inputStream, OutputStream outputStream) throws IOException {
        StreamIO.writeStreamTo(inputStream, outputStream, null, 4096);
    }

    public static void writeStreamTo(InputStream inputStream, OutputStream outputStream, InputStreamListener inputStreamListener, int n) throws IOException {
        cancel = false;
        BufferedInputStream bufferedInputStream = null;
        bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        int n2 = 0;
        byte[] byArray = new byte[n];
        while (!cancel) {
            n2 = bufferedInputStream.read(byArray, 0, n);
            if (inputStreamListener != null) {
                inputStreamListener.notify(inputStream, n2);
            }
            if (n2 <= 0) break;
            outputStream.write(byArray, 0, n2);
            Thread.yield();
        }
        bufferedInputStream.close();
        outputStream.flush();
        outputStream.close();
        if (cancel) {
            throw new InterruptedIOException("Cancelled by user");
        }
    }

    public static boolean writeStreamDlg(final InputStream inputStream, final OutputStream outputStream, int n, String string, Component component, Options options) {
        JProgressBar jProgressBar;
        Messages messages = options.getMessages();
        String string2 = messages.get("WRITING_FILE");
        JDialog jDialog = null;
        jDialog = component instanceof Dialog ? new JDialog((Dialog)component, string2, true) : (component != null ? new JDialog(JOptionPane.getFrameForComponent(component), string2, true) : new JDialog((Frame)null, string2, true));
        if (string != null) {
            jDialog.getContentPane().add(new JLabel(string));
        }
        Object object = null;
        if (n > 0) {
            jProgressBar = new JProgressBar(0, n);
            object = new InputStreamListener(){

                public void notify(InputStream inputStream, int n) {
                    jProgressBar.setValue(n);
                }
            };
            jDialog.getContentPane().add(jProgressBar);
        }
        jProgressBar = object;
        JButton jButton = new JButton(messages.get("CANCEL"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                cancel = true;
            }
        });
        jDialog.getContentPane().add(jButton);
        jDialog.pack();
        JDialog jDialog2 = jDialog;
        SwingWorker swingWorker = new SwingWorker((InputStreamListener)((Object)jProgressBar), messages, jDialog2){
            private boolean result = false;
            private final /* synthetic */ InputStreamListener val$iis;
            private final /* synthetic */ Messages val$msg;
            private final /* synthetic */ JDialog val$dlg;
            {
                this.val$iis = inputStreamListener;
                this.val$msg = messages;
                this.val$dlg = jDialog;
            }

            public Object construct() {
                try {
                    StreamIO.writeStreamTo(inputStream, outputStream, this.val$iis, 4096);
                    this.result = !cancel;
                }
                catch (Exception exception) {
                    this.result = false;
                    this.val$msg.showErrorWarning(this.val$dlg, "ERROR", exception);
                }
                ((Component)this.val$dlg).setVisible(false);
                return new Boolean(this.result);
            }
        };
        swingWorker.startLater();
        ((Component)jDialog).setVisible(true);
        return (Boolean)swingWorker.get();
    }

    public static Object cloneObject(Serializable serializable) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(serializable);
        objectOutputStream.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        return objectInputStream.readObject();
    }

    public static interface InputStreamProvider {
        public InputStream getInputStream(String var1) throws Exception;
    }

    public static interface InputStreamListener {
        public void notify(InputStream var1, int var2);
    }
}

