/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.media;

import edu.xtec.util.ExtendedByteArrayInputStream;
import edu.xtec.util.StreamIO;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import javax.media.Duration;
import javax.media.Time;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;

public class ByteDataSource
extends PullDataSource {
    protected ByteSourceStream[] pss = new ByteSourceStream[1];
    protected ContentDescriptor contentType;
    protected String fName;
    static Method getMimeTypeMethod;
    static /* synthetic */ Class class$java$lang$String;

    public ByteDataSource(ExtendedByteArrayInputStream extendedByteArrayInputStream) throws IOException {
        this.init(extendedByteArrayInputStream);
    }

    public ByteDataSource(InputStream inputStream, String string) throws IOException {
        if (inputStream instanceof ExtendedByteArrayInputStream) {
            this.init((ExtendedByteArrayInputStream)inputStream);
        } else {
            this.init(new ExtendedByteArrayInputStream(StreamIO.readInputStream((InputStream)inputStream), string));
        }
    }

    public ByteDataSource(byte[] byArray, String string) throws IOException {
        this.init(new ExtendedByteArrayInputStream(byArray, string));
    }

    private void init(ExtendedByteArrayInputStream extendedByteArrayInputStream) throws IOException {
        this.contentType = this.getContentDescriptor(extendedByteArrayInputStream.getName());
        this.pss[0] = new ByteSourceStream(extendedByteArrayInputStream, this.contentType);
        this.fName = null;
    }

    private ByteDataSource() {
    }

    public ByteDataSource duplicate() throws IOException {
        ByteDataSource byteDataSource = new ByteDataSource();
        byteDataSource.contentType = this.contentType;
        byteDataSource.fName = this.fName;
        byteDataSource.pss[0] = this.pss[0].duplicate();
        return byteDataSource;
    }

    public ExtendedByteArrayInputStream getInputStream() {
        if (this.pss[0] != null) {
            return this.pss[0].inputStream;
        }
        return null;
    }

    public String getFName() {
        return this.fName;
    }

    public void setFName(String string) {
        this.fName = string;
    }

    public Object[] getControls() {
        return null;
    }

    public void connect() throws IOException {
    }

    public void disconnect() {
    }

    public void start() throws IOException {
    }

    public Time getDuration() {
        return Duration.DURATION_UNKNOWN;
    }

    public void stop() throws IOException {
    }

    public Object getControl(String string) {
        return null;
    }

    public String getContentType() {
        return this.contentType.toString();
    }

    public PullSourceStream[] getStreams() {
        return this.pss;
    }

    public ContentDescriptor getContentDescriptor(String string) {
        String string2 = null;
        if (string != null) {
            int n = string.lastIndexOf(46) + 1;
            String string3 = (n > 0 && n < string.length() ? string.substring(n) : string).toLowerCase();
            if (getMimeTypeMethod != null) {
                try {
                    string2 = (String)getMimeTypeMethod.invoke(null, string3);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (string2 == null) {
            string2 = "unknown";
        }
        return new ContentDescriptor(ContentDescriptor.mimeTypeToPackageName((String)string2));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            Class<?> clazz = Class.forName("com.sun.media.MimeManager");
            if (clazz != null) {
                getMimeTypeMethod = clazz.getMethod("getMimeType", class$java$lang$String == null ? (class$java$lang$String = ByteDataSource.class$("java.lang.String")) : class$java$lang$String);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class ByteSourceStream
    implements PullSourceStream,
    Seekable {
        protected ExtendedByteArrayInputStream inputStream;
        ContentDescriptor contentType;

        public ByteSourceStream(ExtendedByteArrayInputStream extendedByteArrayInputStream, ContentDescriptor contentDescriptor) throws IOException {
            this.inputStream = extendedByteArrayInputStream;
            this.contentType = contentDescriptor;
        }

        public ByteSourceStream duplicate() throws IOException {
            return new ByteSourceStream(this.inputStream.duplicate(), this.contentType);
        }

        public ContentDescriptor getContentDescriptor() {
            return this.contentType;
        }

        public long getContentLength() {
            return this.inputStream.getCount();
        }

        public boolean willReadBlock() {
            return this.inputStream.eosReached();
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.inputStream.read(byArray, n, n2);
        }

        public void close() throws IOException {
            this.inputStream.close();
        }

        public boolean endOfStream() {
            return this.inputStream.eosReached();
        }

        public Object[] getControls() {
            return new Object[0];
        }

        public Object getControl(String string) {
            return null;
        }

        public boolean isRandomAccess() {
            return true;
        }

        public long seek(long l) {
            try {
                return this.inputStream.seek(l);
            }
            catch (Exception exception) {
                return 0L;
            }
        }

        public long tell() {
            return this.inputStream.getPos();
        }
    }
}

