/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.fileSystem;

import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.fileSystem.ZipFileSystem;
import edu.xtec.util.ResourceBridge;
import edu.xtec.util.StreamIO;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileZip
extends ZipFileSystem {
    protected ZipFile zip;

    public FileZip(String string, String string2, ResourceBridge resourceBridge) throws Exception {
        super(string, string2, resourceBridge);
        this.open();
    }

    protected void open() throws Exception {
        if (this.zip == null) {
            this.zip = new ZipFile(FileSystem.sysFn(this.root + this.zipName));
            Enumeration<? extends ZipEntry> enumeration = this.zip.entries();
            Vector<FileZipEntry> vector = new Vector<FileZipEntry>();
            while (enumeration.hasMoreElements()) {
                vector.add(new FileZipEntry(enumeration.nextElement()));
            }
            this.entries = vector.toArray(new FileZipEntry[vector.size()]);
        }
    }

    public void close() {
        if (this.zip != null) {
            try {
                this.zip.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.zip = null;
        }
        super.close();
    }

    protected class FileZipEntry
    extends ZipFileSystem.ExtendedZipEntry {
        FileZipEntry(ZipEntry zipEntry) {
            super(zipEntry);
        }

        public byte[] getBytes() throws IOException {
            return StreamIO.readInputStream((InputStream)this.getInputStream());
        }

        public InputStream getInputStream() throws IOException {
            InputStream inputStream = FileZip.this.zip.getInputStream(this);
            if (FileZip.this.rb != null) {
                inputStream = FileZip.this.rb.getProgressInputStream(inputStream, (int)this.getSize(), this.getName());
            }
            return inputStream;
        }
    }
}

