/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.util.Options;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.image.ImageObserver;
import javax.swing.JComponent;

public class BoxConnector {
    public static final float LINE_WIDTH = 1.5f;
    public static final BasicStroke BASIC_STROKE = new BasicStroke(1.5f);
    public static final Color DEFAULT_LINE_COLOR = Color.black;
    public static final Color DEFAULT_XOR_COLOR = Color.white;
    public static final double ARROW_ANGLE = 0.5235987755982988;
    public static final double ARROW_L = 10.0;
    public static boolean USE_XOR = true;
    public static boolean GROW_BUG = false;
    public Point2D origin;
    public Point2D dest;
    public boolean arrow;
    public boolean active = false;
    public boolean linePainted = false;
    public double arrow_l = 10.0;
    public double arrow_angle = 0.5235987755982988;
    public Color lineColor = DEFAULT_LINE_COLOR;
    public Color xorColor = DEFAULT_XOR_COLOR;
    Point2D relativePos;
    ActiveBox bx;
    JComponent parent;
    public float line_width = 1.5f;

    public BoxConnector(JComponent jComponent) {
        this.parent = jComponent;
        this.origin = new Point2D.Double();
        this.dest = new Point2D.Double();
        this.arrow = false;
        this.active = false;
        this.linePainted = false;
        this.relativePos = new Point2D.Double();
    }

    public boolean update(Graphics2D graphics2D, Rectangle rectangle, ImageObserver imageObserver) {
        if (!this.active) {
            return false;
        }
        if (this.bx != null) {
            this.bx.setTemporaryHidden(false);
            this.bx.update(graphics2D, rectangle, imageObserver);
            this.bx.setTemporaryHidden(true);
        } else {
            this.drawLine(graphics2D);
            this.linePainted = true;
        }
        return true;
    }

    public void drawLine(Graphics2D graphics2D) {
        if (this.active) {
            BoxConnector.drawLine(graphics2D, this.origin, this.dest, this.arrow, this.lineColor, this.xorColor, this.arrow_l, this.arrow_angle, this.line_width);
        }
    }

    public void moveBy(double d, double d2) {
        this.moveTo(new Point2D.Double(this.dest.getX() + d, this.dest.getY() + d2));
    }

    public void moveTo(Point2D point2D) {
        this.moveTo(point2D, false);
    }

    public void moveTo(Point2D point2D, boolean bl) {
        Rectangle rectangle;
        if (!this.active || !bl && this.dest.equals(point2D)) {
            return;
        }
        if (this.bx != null) {
            rectangle = new Rectangle((int)(point2D.getX() - this.relativePos.getX()), (int)(point2D.getY() - this.relativePos.getY()), (int)this.bx.width, (int)this.bx.height);
            rectangle.add(this.bx);
            this.bx.setLocation(new Point2D.Double(point2D.getX() - this.relativePos.getX(), point2D.getY() - this.relativePos.getY()));
        } else if (bl || !USE_XOR) {
            rectangle = new Rectangle((int)this.origin.getX(), (int)this.origin.getY(), 0, 0);
            rectangle.add(point2D);
            rectangle.add(this.dest);
            this.dest.setLocation(point2D);
        } else {
            Graphics2D graphics2D = (Graphics2D)this.parent.getGraphics();
            if (this.linePainted) {
                this.drawLine(graphics2D);
            }
            this.dest.setLocation(point2D);
            this.drawLine(graphics2D);
            this.linePainted = true;
            return;
        }
        BoxConnector.growRect(rectangle, this.arrow ? (int)this.arrow_l : 1, this.arrow ? (int)this.arrow_l : 1);
        this.parent.repaint(rectangle);
    }

    public void begin(Point2D point2D) {
        if (this.active) {
            this.end();
        }
        this.origin.setLocation(point2D);
        this.dest.setLocation(point2D);
        this.linePainted = false;
        this.active = true;
        this.parent.setCursor(Cursor.getPredefinedCursor(12));
    }

    public void begin(Point2D point2D, ActiveBox activeBox) {
        this.begin(point2D);
        this.bx = activeBox;
        this.relativePos.setLocation(point2D.getX() - this.bx.x, point2D.getY() - this.bx.y);
        this.bx.setTemporaryHidden(true);
        Rectangle rectangle = new Rectangle(this.bx.getBounds());
        BoxConnector.growRect(rectangle, 1, 1);
        this.linePainted = false;
        this.parent.repaint(rectangle);
    }

    public ActiveBox getBox() {
        return this.bx;
    }

    public void end() {
        if (!this.active) {
            return;
        }
        if (this.bx != null) {
            Rectangle rectangle = new Rectangle(this.bx.getBounds());
            BoxConnector.growRect(rectangle, 1, 1);
            this.parent.repaint(rectangle);
            this.bx.setLocation(this.origin.getX() - this.relativePos.getX(), this.origin.getY() - this.relativePos.getY());
            this.bx.setTemporaryHidden(false);
            rectangle.setBounds(this.bx.getBounds());
            BoxConnector.growRect(rectangle, 1, 1);
            this.parent.repaint(rectangle);
            this.bx = null;
            this.relativePos.setLocation(0.0, 0.0);
        } else {
            this.moveTo(this.dest, true);
        }
        this.active = false;
        this.linePainted = false;
        this.parent.setCursor(null);
    }

    public static void drawLine(Graphics2D graphics2D, Point2D point2D, Point2D point2D2, boolean bl) {
        BoxConnector.drawLine(graphics2D, point2D, point2D2, bl, DEFAULT_LINE_COLOR, DEFAULT_XOR_COLOR, 10.0, 0.5235987755982988, 1.5f);
    }

    public static void drawLine(Graphics2D graphics2D, Point2D point2D, Point2D point2D2, boolean bl, Color color, Color color2, double d, double d2, float f) {
        Stroke stroke = graphics2D.getStroke();
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
        graphics2D.setColor(color);
        if (USE_XOR && color2 != null) {
            graphics2D.setXORMode(color2);
        }
        graphics2D.setStroke(f == 1.5f ? BASIC_STROKE : new BasicStroke(f));
        graphics2D.drawLine((int)point2D.getX(), (int)point2D.getY(), (int)point2D2.getX(), (int)point2D2.getY());
        if (bl) {
            double d3 = Math.atan2(point2D.getY() - point2D2.getY(), point2D2.getX() - point2D.getX());
            Point2D.Double double_ = new Point2D.Double(point2D2.getX() - d * Math.cos(d3 + d2), point2D2.getY() + d * Math.sin(d3 + d2));
            graphics2D.drawLine((int)point2D2.getX(), (int)point2D2.getY(), (int)((Point2D)double_).getX(), (int)((Point2D)double_).getY());
            ((Point2D)double_).setLocation(point2D2.getX() - d * Math.cos(d3 - d2), point2D2.getY() + d * Math.sin(d3 - d2));
            graphics2D.drawLine((int)point2D2.getX(), (int)point2D2.getY(), (int)((Point2D)double_).getX(), (int)((Point2D)double_).getY());
        }
        if (USE_XOR && color2 != null) {
            graphics2D.setPaintMode();
        }
        graphics2D.setStroke(stroke);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, object);
    }

    public static void checkOptions(Options options) {
        if (options.getBoolean("java141") && options.getBoolean("Mac")) {
            USE_XOR = false;
        }
    }

    public static void growRect(Rectangle rectangle, int n, int n2) {
        if (GROW_BUG) {
            rectangle.x -= n2;
            rectangle.width += 2 * n2;
            rectangle.y -= n;
            rectangle.height += 2 * n;
        } else {
            rectangle.grow(n, n2);
        }
    }

    public static Color getXORColor(Color color) {
        return BoxConnector.getXORColor(color, Color.white);
    }

    public static Color getXORColor(Color color, Color color2) {
        return new Color(color.getRGB() ^ color2.getRGB());
    }
}

