/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.bags.ActivityBagElement;
import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.clic3.Clic3;
import edu.xtec.jclic.edit.Editable;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;

public class ActivityBag
implements Editable,
MediaBag.Listener,
Domable {
    protected JClicProject project;
    private Vector elements = new Vector(20);
    public static final String ELEMENT_NAME = "activities";

    public ActivityBag(JClicProject jClicProject) {
        this.project = jClicProject;
    }

    public JClicProject getProject() {
        return this.project;
    }

    public int size() {
        return this.elements.size();
    }

    public ActivityBagElement elementAt(int n) throws ArrayIndexOutOfBoundsException {
        return (ActivityBagElement)this.elements.elementAt(n);
    }

    public void insertElementAt(ActivityBagElement activityBagElement, int n) throws ArrayIndexOutOfBoundsException {
        this.elements.insertElementAt(activityBagElement, n);
    }

    public void removeElementAt(int n) throws ArrayIndexOutOfBoundsException {
        this.elements.removeElementAt(n);
    }

    public void addElement(ActivityBagElement activityBagElement) {
        this.elements.addElement(activityBagElement);
    }

    public boolean removeElement(ActivityBagElement activityBagElement) {
        return this.elements.removeElement(activityBagElement);
    }

    public int getElementIndex(String string) {
        String string2 = FileSystem.stdFn(string);
        int n = -1;
        int n2 = 0;
        while (n2 < this.size()) {
            if (this.elementAt(n2).getName().equals(string2)) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    public ActivityBagElement getElementByName(String string) {
        int n = this.getElementIndex(string);
        return n >= 0 ? this.elementAt(n) : null;
    }

    public ActivityBagElement getElement(String string) throws Exception {
        ActivityBagElement activityBagElement = this.getElementByName(string);
        if (activityBagElement == null && Clic3.isClic3Extension(Clic3.getExt(string))) {
            Clic3.addActivityToBag(this.project, string);
            activityBagElement = this.getElementByName(string);
        }
        return activityBagElement;
    }

    public boolean activityExists(String string) {
        return this.getElementByName(string) != null;
    }

    public Element getJDomElement() {
        Element element = new Element(ELEMENT_NAME);
        int n = 0;
        while (n < this.size()) {
            element.addContent(this.elementAt(n).getData().detach());
            ++n;
        }
        return element;
    }

    public void addActivity(Activity activity) {
        if (activity != null) {
            this.addJDomElement(activity.getJDomElement());
        }
    }

    public void addJDomElement(Element element) {
        if (element != null) {
            ActivityBagElement activityBagElement = this.getElementByName(element.getAttributeValue("name"));
            if (activityBagElement != null) {
                activityBagElement.setData(element);
            } else {
                this.addElement(new ActivityBagElement(element));
            }
        }
    }

    public ActivityBagElement[] getElements() {
        Object[] objectArray = new ActivityBagElement[this.size()];
        this.elements.copyInto(objectArray);
        return objectArray;
    }

    public void sortByName() {
        Collections.sort(this.elements, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((ActivityBagElement)object).getName().compareTo(((ActivityBagElement)object2).getName());
            }
        });
    }

    public void sortByClassAndName() {
        final StringBuffer stringBuffer = new StringBuffer(200);
        final StringBuffer stringBuffer2 = new StringBuffer(200);
        Collections.sort(this.elements, new Comparator(){

            public int compare(Object object, Object object2) {
                Element element = ((ActivityBagElement)object).getData();
                Element element2 = ((ActivityBagElement)object2).getData();
                stringBuffer.setLength(0);
                stringBuffer.append(element.getAttributeValue("class"));
                stringBuffer.append(element.getAttributeValue("name"));
                stringBuffer2.setLength(0);
                stringBuffer2.append(element2.getAttributeValue("class"));
                stringBuffer2.append(element2.getAttributeValue("name"));
                return stringBuffer.substring(0).compareTo(stringBuffer2.substring(0));
            }
        });
    }

    public void setProperties(Element element, Object object) throws Exception {
        JDomUtility.checkName((Element)element, (String)ELEMENT_NAME);
        List list = element.getChildren("activity");
        this.elements.ensureCapacity(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            iterator.remove();
            this.addJDomElement((Element)element2.detach());
        }
    }

    public void removeElementByName(String string) {
        ActivityBagElement activityBagElement = this.getElementByName(string);
        if (activityBagElement != null) {
            this.removeElement(activityBagElement);
        }
    }

    public Editor getEditor(Editor editor) {
        return Editor.createEditor(this.getClass().getName() + "Editor", this, editor);
    }

    public void listReferencesTo(String string, String string2, HashMap hashMap) {
        int n = 0;
        while (n < this.size()) {
            ActivityBagElement activityBagElement = this.elementAt(n);
            HashMap hashMap2 = activityBagElement.getReferences();
            if (hashMap2 != null && hashMap2.containsKey(string) && (string2 == null || string2.equals(hashMap2.get(string)))) {
                hashMap.put(activityBagElement.getName(), "activity");
            }
            ++n;
        }
    }

    public void listReferences(String string, HashMap hashMap) {
        int n = 0;
        while (n < this.size()) {
            HashMap hashMap2;
            ActivityBagElement activityBagElement = this.elementAt(n);
            if (string == null || string == "activity") {
                hashMap.put(activityBagElement.getName(), "activity");
            }
            if ((hashMap2 = activityBagElement.getReferences()) != null) {
                if (string == null) {
                    hashMap.putAll(hashMap2);
                } else {
                    Iterator iterator = hashMap2.keySet().iterator();
                    while (iterator.hasNext()) {
                        Object k = iterator.next();
                        if (!string.equals(hashMap2.get(k))) continue;
                        hashMap.put(k, string);
                    }
                }
            }
            ++n;
        }
    }
}

