/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller;

import freemind.controller.Controller;
import freemind.modes.MindMapArrowLink;
import freemind.view.mindmapview.MapView;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPopupMenu;

public class MapMouseMotionListener
implements MouseMotionListener,
MouseListener {
    private final Controller c;
    int originX = -1;
    int originY = -1;

    public MapMouseMotionListener(Controller controller) {
        this.c = controller;
    }

    private void handlePopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            JPopupMenu popup = null;
            MindMapArrowLink obj = this.c.getView().detectCollision(e.getPoint());
            if (obj != null) {
                popup = this.c.getMode().getModeController().getPopupForModel(obj);
            }
            if (popup == null) {
                popup = this.c.getFrame().getFreeMindMenuBar().getMapsPopupMenu();
            }
            popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if (this.originX >= 0) {
            ((MapView)e.getComponent()).scrollBy(this.originX - e.getX(), this.originY - e.getY());
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.c.getView().selectAsTheOnlyOneSelected(this.c.getView().getSelected());
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.handlePopup(e);
        } else if (!this.c.getMode().getModeController().isBlocked() && e.getButton() == 1) {
            this.c.getView().setMoveCursor(true);
            this.originX = e.getX();
            this.originY = e.getY();
        }
        e.consume();
    }

    public void mouseReleased(MouseEvent e) {
        this.originX = -1;
        this.originY = -1;
        this.handlePopup(e);
        e.consume();
        this.c.getView().setMoveCursor(false);
    }
}

